/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Properties;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSH
extends Protocol {
    final String name = "BSH";
    Interpreter interpreter;

    public String getName() {
        return "BSH";
    }

    public boolean setProperties(Properties props) {
        return super.setProperties(props);
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
        if (this.interpreter != null) {
            this.destroyInterpreter();
        }
    }

    public void destroy() {
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    public void up(Event evt) {
        Message msg;
        Header h;
        if (evt.getType() == 1 && (h = (msg = (Message)evt.getArg()).removeHeader("BSH")) != null && h instanceof BshHeader) {
            int type = ((BshHeader)h).type;
            switch (type) {
                case 1: {
                    this.handleRequest(msg.getSrc(), msg.getBuffer());
                    return;
                }
                case 2: {
                    msg.putHeader("BSH", h);
                    this.passUp(evt);
                    return;
                }
                case 3: {
                    this.destroyInterpreter();
                    return;
                }
            }
            Trace.error("BSH.handleRequest()", "header type was not REQ as expected (was " + type + ')');
            return;
        }
        this.passUp(evt);
    }

    void handleRequest(Address sender, byte[] buf) {
        Object retval;
        if (buf == null) {
            Trace.error("BSH.handleRequest()", "buffer was null");
            return;
        }
        String code = new String(buf);
        if (this.interpreter == null) {
            this.interpreter = new Interpreter();
            if (Trace.trace) {
                Trace.info("BSH.handleRequest()", "beanshell interpreter was created");
            }
            try {
                this.interpreter.set("bsh_prot", (Object)this);
                if (Trace.trace) {
                    Trace.info("BSH.handleRequest()", "set \"bsh_prot\" to " + this);
                }
            }
            catch (EvalError err) {
                Trace.error("BSH.handleRequest()", "failed setting \"bsh_prot\": " + (Object)((Object)err));
            }
        }
        try {
            retval = this.interpreter.eval(code);
            if (Trace.trace) {
                Trace.info("BSH.handleRequest()", "eval: \"" + code + "\", retval=" + retval);
            }
        }
        catch (EvalError ex) {
            Trace.error("BSH.handleRequest()", "error is " + Trace.getStackTrace(ex));
            retval = ex;
        }
        if (sender != null) {
            Message rsp = new Message(sender, null, null);
            if (retval != null) {
                if (retval instanceof Serializable) {
                    rsp.setObject((Serializable)retval);
                } else {
                    rsp.setObject((Serializable)((Object)retval.toString()));
                }
            }
            if (Trace.trace) {
                Trace.info("BSH.handleRequest()", "sending back response " + retval + " to " + rsp.getDest());
            }
            rsp.putHeader("BSH", new BshHeader(2));
            this.passDown(new Event(1, rsp));
        }
    }

    public void destroyInterpreter() {
        this.interpreter = null;
        if (Trace.trace) {
            Trace.info("BSH.destroyInterpreter()", "beanshell interpreter was destroyed");
        }
    }

    private final /* synthetic */ void this() {
        this.name = "BSH";
        this.interpreter = null;
    }

    public BSH() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class BshHeader
    extends Header {
        public static final int REQ = 1;
        public static final int RSP = 2;
        public static final int DESTROY_INTERPRETER = 3;
        int type;

        public long size() {
            return 10L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.type == 1) {
                sb.append("REQ");
            } else if (this.type == 2) {
                sb.append("RSP");
            } else if (this.type == 3) {
                sb.append("DESTROY_INTERPRETER");
            } else {
                sb.append("<unknown type>");
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        private final /* synthetic */ void this() {
            this.type = 1;
        }

        public BshHeader() {
            this.this();
        }

        public BshHeader(int type) {
            this.this();
            this.type = type;
        }
    }
}

