/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.service;

import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import org.javagroups.JChannel;
import org.javagroups.log.Trace;
import org.javagroups.service.AbstractService;

public class ServiceRunner {
    public static final String SERVICE_CLASS = "serviceClass";
    public static final String SERVICE_CHANNEL_STACK = "serviceChannel";
    public static final String SERVICE_GROUP_NAME = "serviceGroup";
    public static final String CLIENT_CHANNEL_STACK = "clientChannel";
    public static final String CLIENT_GROUP_NAME = "clientGroup";
    public static final String HELP_SWITCH = "-help";
    public static final String RESOURCE_SWITCH = "-res";
    static /* synthetic */ Class class$org$javagroups$service$AbstractService;
    static /* synthetic */ Class class$org$javagroups$Channel;

    public static void startService(ResourceBundle res) throws Exception {
        Class clazz;
        Trace.init();
        String className = res.getString(SERVICE_CLASS);
        if (className == null || "".equals(className)) {
            System.out.println("Specified resource does not contain service class name");
            System.exit(1);
        }
        Class<?> serviceClass = Class.forName(className);
        Class clazz2 = class$org$javagroups$service$AbstractService;
        if (clazz2 == null) {
            clazz2 = class$org$javagroups$service$AbstractService = ServiceRunner.class$("[Lorg.javagroups.service.AbstractService;", false);
        }
        if (!clazz2.isAssignableFrom(serviceClass)) {
            StringBuffer stringBuffer = new StringBuffer("Specified service class is not instance of ");
            Class clazz3 = class$org$javagroups$service$AbstractService;
            if (clazz3 == null) {
                clazz3 = class$org$javagroups$service$AbstractService = ServiceRunner.class$("[Lorg.javagroups.service.AbstractService;", false);
            }
            System.out.println(stringBuffer.append(clazz3.getName()).toString());
            System.exit(1);
        }
        String serviceChannelStack = res.getString(SERVICE_CHANNEL_STACK);
        JChannel svcChannel = new JChannel(serviceChannelStack);
        svcChannel.setOpt(4, new Boolean(true));
        String clientChannelStack = res.getString(CLIENT_CHANNEL_STACK);
        JChannel clientChannel = new JChannel(clientChannelStack);
        String svcGroup = res.getString(SERVICE_GROUP_NAME);
        String clientGroup = res.getString(CLIENT_GROUP_NAME);
        svcChannel.connect(svcGroup);
        clientChannel.connect(clientGroup);
        Class[] classArray = new Class[2];
        Class clazz4 = class$org$javagroups$Channel;
        if (clazz4 == null) {
            clazz4 = classArray[0] = (class$org$javagroups$Channel = ServiceRunner.class$("[Lorg.javagroups.Channel;", false));
        }
        if ((clazz = class$org$javagroups$Channel) == null) {
            clazz = class$org$javagroups$Channel = ServiceRunner.class$("[Lorg.javagroups.Channel;", false);
        }
        classArray[1] = clazz;
        Constructor<?> serviceConstructor = serviceClass.getConstructor(classArray);
        AbstractService service = (AbstractService)serviceConstructor.newInstance(svcChannel, clientChannel);
        service.start();
        Runnable shutdownHook = new Runnable(service, svcChannel, clientChannel){
            final /* synthetic */ AbstractService val$service;
            final /* synthetic */ JChannel val$svcChannel;
            final /* synthetic */ JChannel val$clientChannel;

            public final void run() {
                System.out.println("Shutting down service " + this.val$service.getName());
                this.val$service.stop();
                this.val$svcChannel.close();
                this.val$clientChannel.close();
                System.out.println("Done.");
            }
            {
                this.val$service = abstractService;
                this.val$svcChannel = jChannel;
                this.val$clientChannel = jChannel2;
            }
        };
        Thread shutdownThread = new Thread(shutdownHook, service.getName() + " shutdown hook [" + service.getAddress() + ']');
        shutdownThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        System.out.println("Service '" + service.getName() + "' is up'n'running");
    }

    public static void main(String[] args) throws Exception {
        Trace.init();
        if (args.length == 0) {
            ServiceRunner.printUsage();
            System.exit(0);
        }
        String resourceName = null;
        int i = 0;
        while (i < args.length) {
            if (HELP_SWITCH.equals(args[i])) {
                ServiceRunner.printUsage();
                System.exit(0);
            } else if (RESOURCE_SWITCH.equals(args[i])) {
                resourceName = args[++i];
            }
            ++i;
        }
        if (resourceName == null) {
            ServiceRunner.printUsage();
            System.exit(0);
        }
        ResourceBundle res = ResourceBundle.getBundle(resourceName);
        ServiceRunner.startService(res);
    }

    private static final void printUsage() {
        System.out.println();
        System.out.println("Usage: java org.javagroups.service.ServiceRunner -res <service_desc_res>");
        System.out.println("<service_desc_res> -\tservice description resource,");
        System.out.println("\t\t\tstandard properties file containing information");
        System.out.println("\t\t\tabout service to run.");
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

