/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.Enumeration;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Retransmitter;
import org.javagroups.util.List;
import org.javagroups.util.RWLock;
import org.javagroups.util.TimeScheduler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NakReceiverWindow {
    private RWLock lock;
    private long head;
    private long tail;
    private long lowest_seen;
    private long highest_seen;
    private List msgs;
    private List delivered_msgs;
    private Retransmitter retransmitter;

    public void setRetransmitTimeouts(long[] timeouts) {
        if (this.retransmitter != null) {
            this.retransmitter.setRetransmitTimeouts(timeouts);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(long seqno, Message msg) {
        Entry current = null;
        this.lock.writeLock();
        try {
            block11: {
                long old_tail = this.tail;
                if (seqno < this.head) {
                    Object var8_5 = null;
                    this.lock.writeUnlock();
                    return;
                }
                if (seqno == this.tail) {
                    this.msgs.add(new Entry(seqno, msg));
                    ++this.tail;
                } else {
                    if (seqno > this.tail) {
                        long i = this.tail;
                        while (true) {
                            if (i >= seqno) {
                                this.msgs.add(new Entry(seqno, msg));
                                this.tail = seqno + 1L;
                                if (this.retransmitter == null) break block11;
                                this.retransmitter.add(old_tail, seqno - 1L);
                                break block11;
                            }
                            this.msgs.add(new Entry(i, null));
                            ++this.tail;
                            ++i;
                        }
                    }
                    if (seqno < this.tail) {
                        Enumeration en = this.msgs.elements();
                        while (en.hasMoreElements()) {
                            current = (Entry)en.nextElement();
                            if (seqno != current.seqno) continue;
                            current.msg = msg;
                            if (this.retransmitter == null) break;
                            this.retransmitter.remove(seqno);
                            break;
                        }
                    }
                }
            }
            this._updateLowestSeen();
            this._updateHighestSeen();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
        {
            Object var8_7 = null;
            this.lock.writeUnlock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval = null;
        this.lock.writeLock();
        try {
            Entry e = (Entry)this.msgs.peekAtHead();
            if (e != null && e.msg != null) {
                retval = e.msg;
                this.msgs.removeFromHead();
                this.delivered_msgs.add(e.copy());
                ++this.head;
            }
            Message message = retval;
            Object var4_4 = null;
            this.lock.writeUnlock();
            return message;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stable(long seqno) {
        this.lock.writeLock();
        try {
            Entry e;
            while ((e = (Entry)this.delivered_msgs.peekAtHead()) != null && e.seqno <= seqno) {
                this.delivered_msgs.removeFromHead();
            }
            this._updateLowestSeen();
            this._updateHighestSeen();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
        {
            Object var5_5 = null;
            this.lock.writeUnlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.reset();
            }
            this._reset();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.lock.writeUnlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.stop();
            }
            this._reset();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.lock.writeUnlock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        this.lock.readLock();
        try {
            long l = Math.max(this.head - 1L, (long)-1);
            Object var2_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        this.lock.readLock();
        try {
            long l = this.lowest_seen;
            Object var2_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestSeen() {
        this.lock.readLock();
        try {
            long l = this.highest_seen;
            Object var2_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMissingMessages(long low, long high) {
        List retval = new List();
        if (low > high) {
            if (Trace.trace) {
                Trace.error("NakReceiverWindow.getMissingMessages()", "invalid range: low (" + low + ") is higher than high (" + high + ')');
            }
            return null;
        }
        this.lock.readLock();
        try {
            Entry entry;
            long my_high = Math.max(this.head - 1L, 0L);
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno < low || entry.seqno > high || entry.msg != null) continue;
                retval.add(new Long(entry.seqno));
            }
            if (this.msgs.size() > 0 && (entry = (Entry)this.msgs.peek()) != null) {
                my_high = entry.seqno;
            }
            long i = my_high + 1L;
            while (i <= high) {
                retval.add(new Long(i));
                ++i;
            }
            List list = retval.size() == 0 ? null : retval;
            Object var10_9 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        this.lock.readLock();
        try {
            long l = Math.max(this.tail - 1L, (long)-1);
            Object var2_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesHigherThan(long seqno) {
        List retval = new List();
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= seqno) continue;
                retval.add(entry.msg);
            }
            e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= seqno) continue;
                retval.add(entry.msg);
            }
            List list = retval;
            Object var6_6 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInRange(long lower, long upper) {
        List retval = new List();
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= lower || entry.seqno > upper) continue;
                retval.add(entry.msg);
            }
            e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= lower || entry.seqno > upper) continue;
                retval.add(entry.msg);
            }
            List list = retval.size() == 0 ? null : retval;
            Object var8_7 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInList(List missing_msgs) {
        List ret = new List();
        if (missing_msgs == null) {
            if (Trace.trace) {
                Trace.error("NakReceiverWindow.getMessagesInList()", "argument list is null");
            }
            return ret;
        }
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (!missing_msgs.contains(new Long(entry.seqno)) || entry.msg == null) continue;
                ret.add(entry.msg.copy());
            }
            e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (!missing_msgs.contains(new Long(entry.seqno)) || entry.msg == null) continue;
                ret.add(entry.msg.copy());
            }
            List list = ret;
            Object var5_6 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock();
        try {
            int n = this.msgs.size();
            Object var2_2 = null;
            this.lock.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.lock.readLock();
        try {
            sb.append("delivered_msgs: " + this.delivered_msgs);
            sb.append("\nreceived_msgs: " + this.msgs);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.lock.readUnlock();
            return sb.toString();
        }
    }

    private final void _updateLowestSeen() {
        Entry entry = null;
        if (this.delivered_msgs.size() == 0 && this.msgs.size() == 0) {
            this.lowest_seen = 0L;
            return;
        }
        entry = (Entry)this.delivered_msgs.peekAtHead();
        if (entry != null) {
            this.lowest_seen = entry.seqno;
        } else if (this.msgs.size() != 0 && (entry = (Entry)this.msgs.peekAtHead()) != null && entry.msg != null) {
            this.lowest_seen = entry.seqno;
        }
    }

    private final void _updateHighestSeen() {
        long ret = 0L;
        Entry entry = null;
        if (this.delivered_msgs.size() == 0 && this.msgs.size() == 0) {
            this.highest_seen = 0L;
            return;
        }
        entry = (Entry)this.delivered_msgs.peek();
        ret = entry != null ? entry.seqno : Math.max(this.head - 1L, 0L);
        Enumeration e = this.msgs.elements();
        while (e.hasMoreElements()) {
            entry = (Entry)e.nextElement();
            if (entry.msg == null) break;
            ret = entry.seqno;
        }
        this.highest_seen = Math.max(ret, 0L);
    }

    private final void _reset() {
        this.msgs.removeAll();
        this.delivered_msgs.removeAll();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
    }

    private final /* synthetic */ void this() {
        this.lock = new RWLock();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
        this.msgs = new List();
        this.delivered_msgs = new List();
        this.retransmitter = null;
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno, TimeScheduler sched) {
        this.this();
        this.tail = this.head = start_seqno;
        if (cmd != null) {
            this.retransmitter = sched == null ? new Retransmitter(sender, cmd) : new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno) {
        this(sender, cmd, start_seqno, null);
    }

    public NakReceiverWindow(Address sender, long start_seqno) {
        this(sender, null, start_seqno);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Entry {
        private long seqno;
        private Message msg;

        public Entry copy() {
            Entry retval = new Entry();
            retval.seqno = this.seqno;
            if (this.msg != null) {
                retval.msg = this.msg.copy();
            }
            return retval;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.seqno);
            if (this.msg == null) {
                ret.append("-");
            } else {
                ret.append("+");
            }
            return ret.toString();
        }

        private final /* synthetic */ void this() {
            this.seqno = 0L;
            this.msg = null;
        }

        public Entry() {
            this.this();
            this.seqno = 0L;
            this.msg = null;
        }

        public Entry(long seqno, Message msg) {
            this.this();
            this.seqno = seqno;
            this.msg = msg;
        }
    }
}

