/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PrintXMLTree {
    public static void print(PrintWriter out, Element root) {
        PrintXMLTree.print("", out, root);
    }

    protected static void print(String prepend, PrintWriter out, Element root) {
        String attributeName = null;
        if (root == null) {
            return;
        }
        PrintXMLTree.print(prepend, out, root, root.getAttributes());
        NodeList elements = root.getChildNodes();
        if (elements == null) {
            return;
        }
        if (attributeName == null) {
            int elementCount = elements.getLength();
            int i = 0;
            while (i < elementCount) {
                if (elements.item(i).getNodeType() == 1) {
                    Element element = (Element)elements.item(i);
                    PrintXMLTree.print(prepend, out, element, element.getAttributes());
                }
                ++i;
            }
        } else {
            int elementCount = elements.getLength();
            int i = 0;
            while (i < elementCount) {
                Element element = (Element)elements.item(i);
                NamedNodeMap attributes = element.getAttributes();
                if (attributes.getNamedItem(attributeName) != null) {
                    PrintXMLTree.print(prepend, out, element, attributes);
                }
                ++i;
            }
        }
    }

    protected static void print(String prepend, PrintWriter out, Element element, NamedNodeMap attributes) {
        int i;
        out.print(prepend);
        out.print('<');
        out.print(element.getNodeName());
        if (attributes != null) {
            int attributeCount = attributes.getLength();
            i = 0;
            while (i < attributeCount) {
                Attr attribute = (Attr)attributes.item(i);
                out.print(' ');
                out.print(attribute.getNodeName());
                out.print("=\"");
                out.print(PrintXMLTree.normalize(attribute.getNodeValue()));
                out.print('\"');
                ++i;
            }
        }
        out.println('>');
        NodeList list = element.getChildNodes();
        i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                PrintXMLTree.print(prepend + "  ", out, (Element)list.item(i));
            } else if (list.item(i).getNodeType() == 3 && list.item(i).getNodeValue().trim().length() > 0) {
                out.println(prepend + "  " + list.item(i).getNodeValue());
            }
            ++i;
        }
        out.print(prepend + "</");
        out.print(element.getNodeName());
        out.println(">");
        out.flush();
    }

    public static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int n = 0;
        if (s != null) {
            n = s.length();
        }
        int len = n;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }
}

