/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of uuid.xs. Do not edit this file, edit uuid.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "uuid.xs"
/*
**  OSSP uuid - Universally Unique Identifier
**  Copyright (c) 2004-2005 Ralf S. Engelschall <rse@engelschall.com>
**  Copyright (c) 2004-2005 The OSSP Project <http://www.ossp.org/>
**
**  This file is part of OSSP uuid, a library for the generation
**  of UUIDs which can found at http://www.ossp.org/pkg/lib/uuid/
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  uuid.xs: Perl Binding (Perl/XS part)
*/

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "uuid.h"

#line 46 "uuid.c"
XS(XS_OSSP__uuid_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_constant)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::constant(sv)");
    SP -= items;
    {
#line 41 "uuid.xs"
        dXSTARG;
        STRLEN          len;
        int             i;
        static struct {
            const char *name;
            int         value;
        } constant_table[] = {
            { "UUID_VERSION", UUID_VERSION },
            { "UUID_LEN_BIN", UUID_LEN_BIN },
            { "UUID_LEN_STR", UUID_LEN_STR },
            { "UUID_RC_OK",   UUID_RC_OK   },
            { "UUID_RC_ARG",  UUID_RC_ARG  },
            { "UUID_RC_MEM",  UUID_RC_MEM  },
            { "UUID_RC_SYS",  UUID_RC_SYS  },
            { "UUID_RC_INT",  UUID_RC_INT  },
            { "UUID_RC_IMP",  UUID_RC_IMP  },
            { "UUID_MAKE_V1", UUID_MAKE_V1 },
            { "UUID_MAKE_V3", UUID_MAKE_V3 },
            { "UUID_MAKE_V4", UUID_MAKE_V4 },
            { "UUID_MAKE_MC", UUID_MAKE_MC },
            { "UUID_FMT_BIN", UUID_FMT_BIN },
            { "UUID_FMT_STR", UUID_FMT_STR },
            { "UUID_FMT_TXT", UUID_FMT_TXT }
        };
#line 80 "uuid.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 69 "uuid.xs"
        for (i = 0; i < sizeof(constant_table)/sizeof(constant_table[0]); i++) {
            if (strcmp(s, constant_table[i].name) == 0) {
                EXTEND(SP, 1);
                PUSHs(&PL_sv_undef);
                PUSHi(constant_table[i].value);
                break;
            }
        }
        if (i == sizeof(constant_table)/sizeof(constant_table[0])) {
            sv = sv_2mortal(newSVpvf("unknown contant OSSP::uuid::%s", s));
            PUSHs(sv);
        }
#line 96 "uuid.c"
	PUTBACK;
	return;
    }
}

XS(XS_OSSP__uuid_uuid_create); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_create)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_create(uuid)");
    {
	uuid_t *	uuid;
	uuid_rc_t	RETVAL;
	dXSTARG;
#line 90 "uuid.xs"
        RETVAL = uuid_create(&uuid);
#line 114 "uuid.c"
	sv_setref_pv(ST(0), Nullch, (void*)uuid);
	SvSETMAGIC(ST(0));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_destroy); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_destroy)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_destroy(uuid)");
    {
	uuid_t *	uuid;
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");
#line 102 "uuid.xs"
        RETVAL = uuid_destroy(uuid);
#line 141 "uuid.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_load); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_load)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_load(uuid, name)");
    {
	uuid_t *	uuid;
	const char *	name = (const char *)SvPV_nolen(ST(1));
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");
#line 114 "uuid.xs"
        RETVAL = uuid_load(uuid, name);
#line 167 "uuid.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_make); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_make)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_make(uuid, mode, ...)");
    {
	uuid_t *	uuid;
	unsigned int	mode = (unsigned int)SvUV(ST(1));
#line 126 "uuid.xs"
        uuid_t *ns;
        const char *name;
#line 185 "uuid.c"
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");
#line 129 "uuid.xs"
        if (mode & UUID_MAKE_V3) {
            if (items != 4)
                croak("mode UUID_MAKE_V3 requires two additional arguments to uuid_make()");
	        if (!SvROK(ST(2)))
                croak("mode UUID_MAKE_V3 requires a UUID object as namespace");
            ns   = INT2PTR(uuid_t *, SvIV((SV*)SvRV(ST(2))));
            name = (const char *)SvPV_nolen(ST(3));
            RETVAL = uuid_make(uuid, mode, ns, name);
        }
        else {
            if (items != 2)
                croak("invalid number of arguments to uuid_make()");
            RETVAL = uuid_make(uuid, mode);
        }
#line 210 "uuid.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_isnil); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_isnil)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_isnil(uuid, result)");
    {
	uuid_t *	uuid;
	int	result;
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");
#line 154 "uuid.xs"
        RETVAL = uuid_isnil(uuid, &result);
#line 236 "uuid.c"
	sv_setiv(ST(1), (IV)result);
	SvSETMAGIC(ST(1));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_compare); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_compare)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_compare(uuid, uuid2, result)");
    {
	uuid_t *	uuid;
	uuid_t *	uuid2;
	int	result;
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    uuid2 = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid2 is not a reference");
#line 168 "uuid.xs"
        RETVAL = uuid_compare(uuid, uuid2, &result);
#line 272 "uuid.c"
	sv_setiv(ST(2), (IV)result);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_import); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_import)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_import(uuid, fmt, data_ptr, data_len)");
    {
	uuid_t *	uuid;
	uuid_fmt_t	fmt = (uuid_fmt_t)SvIV(ST(1));
	const void *	data_ptr = (const void *)SvPV_nolen(ST(2));
	size_t	data_len = (size_t)SvUV(ST(3));
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");
#line 183 "uuid.xs"
        if (ST(3) == &PL_sv_undef)
            data_len = sv_len(ST(2));
        RETVAL = uuid_import(uuid, fmt, data_ptr, data_len);
#line 304 "uuid.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_export); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_export)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_export(uuid, fmt, data_ptr, data_len)");
    SP -= items;
    {
	uuid_t *	uuid;
	uuid_fmt_t	fmt = (uuid_fmt_t)SvIV(ST(1));
	void *	data_ptr;
	size_t	data_len;
	uuid_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    uuid = INT2PTR(uuid_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "uuid is not a reference");
#line 199 "uuid.xs"
        data_ptr = NULL;
        data_len = 0;
        RETVAL = uuid_export(uuid, fmt, &data_ptr, &data_len);
        if (RETVAL == UUID_RC_OK) {
            if (fmt == UUID_FMT_STR)
                data_len--; /* Perl doesn't wish NUL-termination on strings */
            sv_setpvn(ST(2), data_ptr, data_len);
            free(data_ptr);
            if (ST(3) != &PL_sv_undef)
                sv_setuv(ST(3), (UV)data_len);
        }
        PUSHi((IV)RETVAL);
#line 344 "uuid.c"
	PUTBACK;
	return;
    }
}

XS(XS_OSSP__uuid_uuid_error); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_error)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_error(rc)");
    {
	uuid_rc_t	rc = (uuid_rc_t)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;
#line 219 "uuid.xs"
        RETVAL = uuid_error(rc);
#line 362 "uuid.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_OSSP__uuid_uuid_version); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__uuid_uuid_version)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: OSSP::uuid::uuid_version()");
    {
	unsigned long	RETVAL;
	dXSTARG;
#line 228 "uuid.xs"
        RETVAL = uuid_version();
#line 379 "uuid.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_OSSP__uuid); /* prototype to pass -Wmissing-prototypes */
XS(boot_OSSP__uuid)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("OSSP::uuid::constant", XS_OSSP__uuid_constant, file);
        newXSproto("OSSP::uuid::uuid_create", XS_OSSP__uuid_uuid_create, file, "$");
        newXSproto("OSSP::uuid::uuid_destroy", XS_OSSP__uuid_uuid_destroy, file, "$");
        newXSproto("OSSP::uuid::uuid_load", XS_OSSP__uuid_uuid_load, file, "$$");
        newXSproto("OSSP::uuid::uuid_make", XS_OSSP__uuid_uuid_make, file, "$$;$$");
        newXSproto("OSSP::uuid::uuid_isnil", XS_OSSP__uuid_uuid_isnil, file, "$$");
        newXSproto("OSSP::uuid::uuid_compare", XS_OSSP__uuid_uuid_compare, file, "$$$");
        newXSproto("OSSP::uuid::uuid_import", XS_OSSP__uuid_uuid_import, file, "$$$$");
        newXSproto("OSSP::uuid::uuid_export", XS_OSSP__uuid_uuid_export, file, "$$$$");
        newXSproto("OSSP::uuid::uuid_error", XS_OSSP__uuid_uuid_error, file, "$");
        newXSproto("OSSP::uuid::uuid_version", XS_OSSP__uuid_uuid_version, file, "");
    XSRETURN_YES;
}

