//
// C++ Interface: singlehandlemaker
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __SINGLEHANDLEMAKER_H_2004_07_03
#define __SINGLEHANDLEMAKER_H_2004_07_03

#include <string>
#include <assert.h>


#include <HandleMaker.h>
#include <singleton.h>

using namespace std;

/** This offers easy access to the HandleMaker.  */
// typedef Singleton< Tagcoll::HandleMaker<string> > SingleHandleMaker;

class SingleHandleMaker : public Tagcoll::HandleMaker<string>
{

	static SingleHandleMaker* _pInstance;
public:
	/** This gets the instance managed by the singleton. */
 	static SingleHandleMaker* instance() 
	{
		if (_pInstance == 0)
			_pInstance = new SingleHandleMaker;
		return _pInstance;
	}
	/** This can be used to get the instance managed by the singleton. It assumes the instance
	  * to be allready created
	  * @pre the instance must have been created (i.e. instance must have been called) */
	static SingleHandleMaker* uncheckedInstance() 
	{
		assert (_pInstance != 0);
		return _pInstance;
	}
protected:
	SingleHandleMaker() {};
};

#endif	// __SINGLEHANDLEMAKER_H_2004_07_03
