#include "util.h"

/* Standard implementation of xrealloc -- exit if anything goes
   wrong */

void *xrealloc(void *ptr, size_t size) {
  void *r = realloc(ptr, size);
  if (r == NULL) {
    _log_err(LOG_ERR, "Out of memory in xrealloc");
      exit(1);
  }
  return r;
}

/* Standard implementation of xmalloc -- exit if anything goes
   wrong */

void *xmalloc(size_t size) {
  void *r = malloc(size);
  if (r == NULL) {
    _log_err(LOG_ERR, "Out of memory in xmalloc");
    exit(1);
  }
  return r;
}

/* Why doesn't libc have a method to read a line from a file, similar
   to python's f.readline()?  This is an implementation. */

char *freadline(FILE *stream) {
  char buf[512];
  size_t alloc = 0;
  char *ret = NULL;
  char *t;
  t = fgets(buf, sizeof(buf), stream);
  if (t == NULL) {
    return NULL;
  }
  ret = xmalloc(sizeof(buf));
  strcpy(ret, buf);
  t = fgets(buf, sizeof(buf), stream);
  while (t != NULL) {
    alloc += (strlen(t));
    ret = xrealloc(ret, alloc);
    strcat(ret,buf);
  }
  return ret;
}

/* some syslogging */

void _log_err(int err, const char *format, ...) {
  va_list args;
  
  va_start(args, format);
  openlog("PAM_umask", LOG_CONS|LOG_PID, LOG_AUTH);
  vsyslog(err, format, args);
  va_end(args);
  closelog();
}
