#ifndef INCLUDE_INPUTMANAGER_H
#define INCLUDE_INPUTMANAGER_H
/* ----------------------------------------------------------------------------
 * input_manager.h
 * prototypes and definitions for input_manager.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

typedef void (*inputqueue_t)();

#define MAXINPUTS   8
#define TIMERCOUNT  3     /* ATTENTION: keep an eye on the init routine */
#define EVDEVCOUNT	32

/* queue identifier */
#define KBDQUEUE	0      /* keyboard events */
#define MOUSEQUEUE	1      /* mouse events */
#define T10QUEUE	2      /* timer tic every 10ms */
#define T100QUEUE	3      /* timer tic every 100ms */
#define T1000QUEUE	4      /* timer tic every second */
#define QUERYQUEUE	5      /* ask for properties */
#define CONFIGQUEUE	6      /* set properties */
#define SECUREQUEUE 7      /* called if user is idle */

#define QUEUECOUNT	8

#define MOD_NONE			0
#define MOD_SHIFT			1     /* 001 */
#define MOD_ALT				2     /* 010 */
#define MOD_SHIFTALT		3
#define MOD_CTRL			4     /* 100 */
#define MOD_SHIFTCTRL		5
#define MOD_ALTCTRL			6
#define MOD_SHIFTALTCTRL	7

#define BITS_PER_LONG (sizeof(long) * 8)
#define NBITS(x) ((((x)-1)/BITS_PER_LONG)+1)
#define OFF(x) ((x)%BITS_PER_LONG)
#define LONG(x) ((x)/BITS_PER_LONG)
#define test_bit(bit, array) ((array[LONG(bit)] >> OFF(bit)) & 1)

struct evdevice {
	int inputid; /* in fact the filehandle to identify the input handler */
	unsigned short vendor;
	unsigned short product;
};

/* public prototypes */
int inputmanager_init (struct tagitem *taglist);
int inputmanager_exit ();
int register_inputhandler (int fd, void *func);
void unregister_inputhandler (int fd);
int register_function (int queueid, void *func );
long process_queue_single (int queueid, long tag, long data);
void process_queue (int queueid, struct tagitem *taglist);
int create_fdset (fd_set *watchset);
void call_inputhandler(fd_set *inset);
void call_timertick ();

 /* private prototypes */
void scan_for_kbdevdevs();
int track_modifier(unsigned short code, unsigned int value);
int get_modifier();
void ipc_handler ();
void keyboard_handler (int fd);
void mouse_handler (int fd);
void timer10_handler ();
void timer100_handler ();
void timer1000_handler ();

#endif    /* INCLUDE_INPUTMANAGER_H */
