#ifndef _PFE_MISC_EXT_H
#define _PFE_MISC_EXT_H 1063198930
/* generated 2003-0910-1502 ../../../pfe/../mk/Make-H.pl ../../../pfe/misc-ext.c */

#include <pfe/pfe-ext.h>

/** 
 * -- miscellaneous useful words, mostly stemming from fig-forth
 *
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version: bln_mpt1!33.65 %
 *    (%date_modified: Mon Feb 24 20:03:36 2003 %)
 *
 *  @description
 *      Compatiblity with former standards, miscellaneous useful words.
 */

#ifdef __cplusplus
extern "C" {
#endif




/** COLD ( -- )
 * cold abort - reinitialize everything and go to => QUIT routine
 * ... this routine is implemented as a warm-boot in pfe.
 : COLD [ ALSO ENVIRONMENT ] EMPTY SCRIPT-FILE INCLUDED QUIT ;
 */
extern P4_CODE (p4_cold);

/** .LINE ( line# block# -- )
 */
extern P4_CODE (p4_dot_line);

/** UD.R ( 2val r -- )
 */
extern P4_CODE (p4_u_d_dot_r);

/** UD. ( 2val -- )
 * see also => UD.R
 */
extern P4_CODE (p4_u_d_dot);

/** ID. ( nfa -- )
 * print the name-field pointed to by the nfa-argument.
 * a synonym for .NAME - but this word is more portable due its
 * heritage from fig-forth. 
 * 
 * in fig-forth the name-field is effectivly a bstring with some flags,
 * so the nfa's count has to be masked out, e.g. 
 : .NAME COUNT 32 AND TYPE ;
 *
 * in other pfe configurations, the name might not contain the flags it
 * it just a counted string - and there may be even more possibility.
 : .NAME COUNT TYPE ;
 * 
 * you should more and more convert your code to use the sequence
 * => NAME>STRING => TYPE
 */
extern P4_CODE(p4_id_dot);

/** -ROLL ( xn ... x2 x1 n -- x1 xn ... x2 )
 * the inverse of => ROLL
 */
extern P4_CODE (p4_dash_roll);

/** RANDOM ( n1 -- n2 )
 * returns random number with 0 <= n2 < n1)
 : RANDOM ?DUP IF _random SWAP MOD ELSE _random THEN ;
 */
extern P4_CODE (p4_random);

/** SRAND ( n -- )
 */
extern P4_CODE (p4_srand);

/** UNDER+ ( n1 x n2 -- n1+n2 x ) TF
 *     quicker than
 : UNDER+  ROT + SWAP ;
 */
extern P4_CODE (p4_plus_under);

/** "(UNDER+)" ( n1 n2 -- n1+n2 n2 )
 * quicker than
 : (UNDER+) TUCK + SWAP ; or : (UNDER+) DUP UNDER+ ;
 */
extern P4_CODE (p4_under_plus);

/** ((+TO)) ( val -- )
 * execution compiled by => +TO
 * adds the stack-val to the lvalue compiled
 */
extern P4_CODE (p4_plus_to_execution);

/** ((+TO.local)) ( val -- )
 * same as => ((+TO)) when the lvalue is a => LOCALS| value
 * <br> compiled by => +TO
 */
extern P4_CODE (p4_plus_to_local_execution);

/** +TO ( val [name] -- )
 * add the val to the named => VALUE or => LOCALS| value
 */
extern P4_CODE (p4_plus_to);

/** BUILD-ARRAY ( n1 n2 ... nX X --- n )
 * writes X, n1, ... nX into the dictionary - 
 * returns product n1 * n2 * ... * nX 
 */
extern P4_CODE (p4_build_array);

/** ACCESS-ARRAY ( i1 i2 ... iX addr1 --- addr2 n )
 * see => BUILD-ARRAY
 */
extern P4_CODE (p4_access_array);

/** SOURCE-LINE ( -- n )
 * if => SOURCE is from => EVALUATE (or => QUERY ) then
 * the result is 0 else the line-numbers start from 1 
 */
extern P4_CODE (p4_source_line);

/** SOURCE-NAME ( -- str-ptr str-len )
 * if => SOURCE is from => INCLUDE then the result is the filename,
 * otherwise a generic name for the SOURCE-ID is given.
 */
extern P4_CODE (p4_source_name);

/** TH'POCKET ( n -- addr u )
 * returns the specified pocket as a => S" string reference
 */
extern P4_CODE (p4_th_pocket);

/** POCKET-PAD ( -- addr )
 * Returns the next pocket.
 * A pocket has usually the size of a maxstring, see =>"ENVIRONMENT /STRING"
 * (but can be configured to be different, mostly when MAXPATH > /STRING )
 * Note that a pocket is a temporary and forth internal functions do
 * sometimes call => POCKET-PAD too, especially when building filenames
 * and getting a literal (but temporary) string from the keyboard.
 * Functions are not expected to hold references to this transient
 * area any longer than building a name and calling another word with it.

 * Usage of a pocket pad is a good way to make local temporary buffers
 * superfluous that are only used to construct a temporary string that 
 * usually gets swallowed by another function.
 depracated code:
   create temp-buffer 255 allot
   : make-temp ( str buf ) 
          temp-buffer place  " .tmp" count temp-buffer append 
          temp-buffer count make-file ;
 replace with this:
   : make-temp ( str buf )
        pocket-pad >r    
        r place  " .tmp" count r append
        r> count make-file
   ;
 */
extern P4_CODE (p4_pocket_pad);

/** WL-HASH ( c-addr n1 -- n2 )
 * calc hash-code for selection of thread
 * in a threaded-vocabulary
 */
extern P4_CODE (p4_wl_hash);

/** TOPMOST ( wid -- a-addr )
 * that last valid word in the specified vocabulary
 */
extern P4_CODE (p4_topmost);

/** LS.WORDS ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_words);

/** LS.PRIMITIVES ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_primitives);

/** LS.COLON-DEFS ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_cdefs);

/** LS.DOES-DEFS ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_ddefs);

/** LS.CONSTANTS ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_constants);

/** LS.VARIABLES ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_variables);

/** LS.VOCABULARIES ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_vocabularies);

/** LS.MARKERS ( -- )
 * see => WORDS
 */
extern P4_CODE (p4_ls_markers);

/** W@ ( addr -- w-val )
 * fetch a 2byte-val from address
 */
extern P4_CODE (p4_w_fetch);

/** W! ( w-val addr -- )
 * store a 2byte-val at addressed 2byte-value
 */
extern P4_CODE (p4_w_store);

/** W+! ( w-val addr -- )
 * add a 2byte-val to addressed 2byte-value
 */
extern P4_CODE (p4_w_plus_store);

/** TAB ( n -- )
 * jump to next column divisible by n 
 */
extern P4_CODE (p4_tab);

/** BACKSPACE ( -- )
 * reverse of => SPACE
 */
extern P4_CODE (p4_backspace);

/** ?STOP ( -- flag )
 * check for 'q' pressed
 * - see => ?CR
 */
extern P4_CODE (p4_Q_stop);

/** START?CR ( -- )
 * initialized for more-like effect
 * - see => ?CR
 */
extern P4_CODE (p4_start_Q_cr);

/** ?CR ( -- flag )
 * like => CR , stop 25 lines past => START?CR
 */
extern P4_CODE (p4_Q_cr);

/** CLOSE-ALL-FILES ( -- )
 */
extern P4_CODE (p4_close_all_files);

/** .MEMORY ( -- )
 */
extern P4_CODE (p4_dot_memory);

/** .STATUS ( -- )
 * display internal variables 
 : .STATUS .VERSION .CVERSION .MEMORY .SEARCHPATHS .DICTVARS .REGSUSED ;
 */
extern P4_CODE (p4_dot_status);

/** LOWER-CASE! ( val -- )
 * Call to enable lower-case symbols as input, supersedes the plain
 * variable => LOWER-CASE
 : LOWER-CASE! LOWER-CASE ! ;
 : LOWER-CASE! TO LOWER-CASE@ ;
 */
extern P4_CODE (p4_lower_case_store);

/** LOWER-CASE-FN! ( val -- )
 * Call to enable lower-case symbols as input, supersedes the plain
 * variable => LOWER-CASE-FN
 : LOWER-CASE-FN!    LOWER-CASE-FN ! ;
 : LOWER-CASE-FN! TO LOWER-CASE-FN@ ;
 */
extern P4_CODE (p4_lower_case_fn_store);

/** REDEFINED-MSG! ( val -- )
 * Call to enable warnings if creating symbols being in the => ORDER 
 * - supersedes the plain variable => REDEFINED-MSG
 : REDEFINED-MSG!    REDEFINED-MSG ! ;
 : REDEFINED-MSG! TO REDEFINED-MSG@ ;
 */
extern P4_CODE (p4_redefined_msg_store);

/** (EMIT) ( val -- )
 * like => EMIT and always to screen 
 * - the routine to be put into => *EMIT*
 */
extern P4_CODE (p4_paren_emit);

/** (EXPECT) ( . -- . )
 * like => EXPECT and always from screen
 * - the routine to be put into => *EXPECT*
 */
extern P4_CODE (p4_paren_expect);

/** (KEY) ( -- ... )
 * like => KEY and always from screen
 * - the routine to be put into => *KEY*
 */
extern P4_CODE (p4_paren_key);

/** (TYPE) ( val -- )
 * like => TYPE and always to screen 
 * - the routine to be put into => *TYPE*
 */
extern P4_CODE (p4_paren_type);

/** STANDARD-I/O ( -- )
 * initialize => *TYPE* , => *EMIT* , => *EXPECT* and => *KEY*
 * to point directly to the screen I/O routines, <br> 
 * namely => (TYPE) , => (EMIT) , => (EXPECT) , => (KEY) 
 */
extern P4_CODE (p4_standard_io);

/** ((EXECUTES)) ( n -- )
 * compiled by => EXECUTES
 */
extern P4_CODE (p4_executes_execution);

/** EXECUTES ( n [word] -- )
 * stores the execution token of following word into
 * the callback pointer for the specified function-key 
 */
extern P4_CODE (p4_executes);

/** HELP ( name -- )
 * will load the help module in the background and hand over the 
 * parsed name to => (HELP) to be resolved. If no => (HELP) word
 * can be loaded, nothing will happen.
 */
extern P4_CODE (p4_help);

/** EDIT-BLOCKFILE ( name -- )
 * will load the edit module in the background and look for a word
 * called => EDIT-BLOCK that could be used to edit the blockfile.
 * If no => EDIT-BLOCKFILE word can be loaded, nothing will happen.
 * Otherwise, => OPEN-BLOCKFILE is called followed by => 0 => EDIT-BLOCK
 * to start editing the file at the first block.
 */
extern P4_CODE (p4_edit_blockfile);

/** ARGC ( -- n )
 */
extern P4_CODE (p4_argc);

/** ARGV ( n -- addr u )
 */
extern P4_CODE (p4_argv);

/** EXPAND-FN ( addr1 u1 addr2 -- addr2 cnt2 )
 */
extern P4_CODE (p4_expand_fn);

/** ((LOAD")) ( -- ? )
 */
extern P4_CODE (p4_load_quote_execution);

/** LOAD"  ( [filename<">] -- ? ) obsolete 
 * load the specified file - this word can be compiled into a word-definition
 * obsolete! use => OPEN-BLOCKFILE name => LOAD
 */
extern P4_CODE (p4_load_quote);

/** SYSTEM ( addr u -- ret-val )
 * run a shell command  (note: embedded systems have no shell)
 */
extern P4_CODE (p4_system);

/** ((SYSTEM")) 
 * compiled by => SYSTEM" commandline"
 */
extern P4_CODE (p4_system_quote_execution);

/** SYSTEM" ( [commandline<">] -- ret-val ) obsolete
 * run a shell command (note:embedded systems have no shell)
 * obsolete! use => S" string" => SYSTEM
 */
extern P4_CODE (p4_system_quote);

/** RAISE ( n -- )
 * send a => SIGNAL to self
 */
extern P4_CODE (p4_raise);

/** SIGNAL ( xt1 n -- xt2 )
 * install signal handler
 * - return old signal handler
 */
extern P4_CODE (p4_signal);

/** CREATE: ( 'name' -- )
 * this creates a name with the => VARIABLE runtime.
 * Note that this is the FIG-implemenation of => CREATE whereas in
 * ANS-Forth mode we have a => CREATE identical to FIG-style =>"<BUILDS"
 : CREATE: BL WORD $HEADER DOVAR A, ;
 */
extern P4_CODE (p4_create_var);

/** BUFFER: ( size 'name' -- )
 * this creates a name with the => VARIABLE runtime and =>"ALLOT"s memory
 : BUFFER: BL WORD $HEADER DOVAR A, ALLOT ;
 */
extern P4_CODE (p4_buffer_var);

/** R'@ ( R: a b -- a R: a b )
 * fetch the next-under value from the returnstack.
 * used to interpret the returnstack to hold two => LOCALS| values.
 * ( =>'R@' / =>'2R@' / =>'R>DROP' / =>'R"@')
 */
extern P4_CODE (p4_r_tick_fetch);

extern P4_CODE (p4_r_tick_fetch_execution);

/** R'! ( x R: a b -- R: x b )
 * store the value into the next-under value in the returnstack.
 * used to interpret the returnstack to hold two => LOCALS| values.
 * see =>"R'@" for inverse operation
 */
extern P4_CODE (p4_r_tick_store);

extern P4_CODE (p4_r_tick_store_execution);

/** R"@ ( R: a b c -- a R: a b c )
 * fetch the second-under value from the returnstack.
 * used to interpret the returnstack to hold three => LOCALS| values.
 * see =>'R"!' for inverse operation ( =>"R'@" =>"R@" / =>"2R@" / =>"R>DROP" )
 */
extern P4_CODE (p4_r_quote_fetch);

extern P4_CODE (p4_r_quote_fetch_execution);

/** R"! ( x R: a b c -- R: x b c )
 * store the value into the second-under value in the returnstack.
 * used to interpret the returnstack to hold three => LOCALS| values.
 * see =>'R"@' for inverse operation
 */
extern P4_CODE (p4_r_quote_store);

extern P4_CODE (p4_r_quote_store_execution);

/** R! ( x R: a -- R: x )
 * store the value as the topmost value in the returnstack.
 * see =>"R@" for inverse operation ( =>"R'@" / =>'R"@' / =>'2R@' / =>'2R!')
 */
extern P4_CODE (p4_r_store);

extern P4_CODE (p4_r_store_execution);

/** 2R! ( x y R: a b -- R: x y )
 * store the value as the topmost value in the returnstack.
 * see =>"2R@" for inverse operation ( =>"R'@" / =>'R"@' / =>'2R@' / =>'2R!')
 */
extern P4_CODE (p4_two_r_store);

extern P4_CODE (p4_two_r_store_execution);

/** DUP>R ( val -- val )
 * shortcut, see => R>DROP
 * <br> note again that the following will fail:
 : DUP>R DUP >R ;
 */
extern P4_CODE (p4_dup_to_r);

extern P4_CODE (p4_dup_to_r_execution);

/** R>DROP ( -- )
 * shortcut (e.g. in CSI-Forth)
 * <br> note that the access to R is configuration dependent - only in
 * a traditional fig-forth each NEST will be one cell wide - in case that
 * there are no => LOCALS| of course. And remember, the word above reads
 * like the sequence => R> and => DROP but that is not quite true.
 : R>DROP R> DROP ; ( is bad - correct might be )  : R>DROP R> R> DROP >R ;
 */
extern P4_CODE (p4_r_from_drop);

extern P4_CODE (p4_r_from_drop_execution);

/** 2R>2DROP ( -- )
 * this is two times => R>DROP but a bit quicker.
 * it is however really quick compared to the sequence => 2R> and => 2DROP
 */
extern P4_CODE (p4_two_r_from_drop);

extern P4_CODE (p4_two_r_from_drop_execution);

/** CLEARSTACK ( -- )
 * reset the parameter stack to be empty
 : CLEARSTACK  S0 SP! ;
 */
extern P4_CODE (p4_clearstack);

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif
