<?php

include './settings.php';

class PageParser
{
	var $buf;		// CDATA buffer
	var $out;		// Output buffer
	var $page;		// Array containing filenames being used

	function PageParser()
	{
		$this->buf = '';
		$this->out = Array();
	}

	function openElement($p,$name,$attrs)
	{
		switch ($name)
		{
			case 'news':
				$this->out[] = "<u>News</u>\n<br>\n" .
				               '<table border="0" style="padding: 4px" cellspacing="0">' .
				               "\n";
				break;
			case 'item':
				$this->out[] = "\t<tr>\n";
				break;
			case 'date':
				$this->out[] = "\t\t<td class=\"d-dark\">\n";
				break;
			case 'title':
				$this->out[] = "\t\t<td class=\"d-cell\">\n";
				break;
			case 'content':
				$this->out[] = "\t\t\t<br>\n";
				break;
			default:
				// We're ignoring elements we don't recognize
		}
	}

	function closeElement($p,$name)
	{
		if (strlen($this->buf))
		{
			switch ($name)
			{
				case 'date':
					// TODO: A regexp to see if it's in YYYY-MM-DD format, and
					// optionally rework it to Month Day, Year format
					$this->out[] = "\t\t\t$this->buf\n";
					break;
				case 'title':
					$this->out[] = "\t\t\t<b>$this->buf</b>\n";
					break;
				case 'content':
					$this->out[] = $this->buf . "\n";
					break;
				default:
					// We're ignoring CDATA that isn't
					// in an element we care about
			}
			$this->buf = '';
		}

		switch ($name)
		{
			case 'news':
				$this->out[] = "</table>\n";
				break;
			case 'item':
				$this->out[] = "\t</tr>\n";
				break;
			case 'date':
				$this->out[] = "\t\t</td>\n";
				break;
			case 'title':
				break;
			case 'content':
				$this->out[] = "\t\t</td>\n";
				break;
			default:
				// We're ignoring elements we don't recognize
		}
	}

	function readCharacterData($p,$data)
	{
		$this->buf .= chop($data);
	}

	function readHeader()
	{
		if (isset($this->page['headerfile']) && is_file($this->page['headerfile']))
		{
			$arr = file($this->page['headerfile']);
			// array_merge seems to be a suspect of rearranging array keys.
			// Since I don't care enough to investigate now, we'll do it
			// by hand.  This way we know it's doing what we want.
			foreach ($arr as $line)
				$this->out[] = $line;
		}
	}

	function readFooter()
	{
		if (isset($this->page['footerfile']) && is_file($this->page['footerfile']))
		{
			$arr = file($this->page['footerfile']);
			foreach ($arr as $line)
				$this->out[] = $line;
		}
	}

	function setPage($page)
	{
		$this->page = $page;
	}
};

$pobj = new PageParser;
$p = xml_parser_create();

xml_parser_set_option($p,XML_OPTION_CASE_FOLDING,0);
xml_set_object($p,&$pobj);
xml_set_character_data_handler($p, 'readCharacterData');
xml_set_element_handler($p,'openElement','closeElement');

foreach ($pages as $page)
{
	$pobj->setPage($page);
	$pobj->readHeader();

	if (!$fp = @fopen($page['xmlfile'],'r'))
		die("Could not open XML data file {$page['xmlfile']}.  Exiting.");

	if (!$outfp = @fopen($page['outputfile'],'w'))
		die("Could not open output file {$page['outputfile']}.  Exiting.");

	while ($data = fread($fp, 4096))
	{
		if (!xml_parse($p, $data, feof($fp)))
			die(sprintf("XML error: %s at line %d\n",
			    xml_error_string(xml_get_error_code($p)),
			    xml_get_current_line_number($p)));
	}

	$pobj->readFooter();

	foreach ($pobj->out as $line)
		fwrite($outfp,$line);

	fclose($fp);
	fclose($outfp);
}

xml_parser_free($p);

?>
