--TEST--
maxdb_fetch_lengths
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
$link = maxdb_connect("localhost", "MONA", "RED", "DEMODB");

/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

$query = "SELECT * from hotel.customer WHERE cno = 3000";

if ($result = maxdb_query($link, $query)) {

   $row = maxdb_fetch_row($result);

   /* display column lengths */
   $lengths = maxdb_fetch_lengths($result);
   for ($i=0; $i < count($lengths); $i++) {
       printf("Field %2d has Length %2d\n", $i+1, $lengths[$i]);
   }
   maxdb_free_result($result);
}

/* close connection */
maxdb_close($link);
?>
--EXPECT--
Field  1 has Length  4
Field  2 has Length  3
Field  3 has Length  5
Field  4 has Length  6
Field  5 has Length  5
Field  6 has Length 21

