/*
 * News downloading shell util for PIMPPA
 *
 *
 * Uses: news.c (and indirectly suck, uudeview)
 *
 *
 */

#include <errno.h>
#include <time.h>
#include <ctype.h>
#include <dirent.h>
#include <getopt.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "pimppa.h"
#include "ftp.h"
#include "news.h"
	
int WaitA, WaitS;

MYSQL *src_db,*dst_db;

void usage(char *name)
{
	fprintf(stderr, "Usage: %s [options]\n\n"
			"-a <n>       Wait After n messages, def=%d\n"
			"-f <urlfile> Read (ftp-url, area) pairs from file, leech recursively\n" 
			"-g <pat>     Newsgroup name SQL pattern to match, def=all defined\n"
			"-H <host>    Specify NNTP host SQL pattern\n"
			"-i           Insert message subjects into database as file descs\n"
			"-l           Lenient article selection while leeching news\n"
			"-n           Nazi behaviour, try to skip all files which\n"
			"             do not have an assign pattern already defined.\n"
			"-k           Keyword hunt behaviour, accept only if subject\n"
			"             contains a key pattern defined in p_rules\n"
			"-q           Quiet operation (don't print newsleech BPS etc)\n"
			"-r           Restart newsgroup(s)\n"
			"-s           Sloppy download mode (take & accept everything)\n"
			"-v           Verbose output\n"
			"-w <secs>    Wait secs after [-a n] messages, def=%d\n",
		name,WaitA, WaitS);
}


int main(int argc, char *argv[])
{
	char groups[PATH_MAX];
	char server[256];
	char urlfile[PATH_MAX];
	int go=1;
	int options=0;
	int retval=0;
	char *serverptr;
	char *value;

	serverptr=NULL;
	server[0]=groups[0]=urlfile[0]=0;

	src_db=p_connect();
	if(!src_db)
		return(-1);

	value=p_getmisc(src_db, P_KEY_NEWSWAITAFTER);
	if(value)
		WaitA=atoi(value);
	else
		WaitA=atoi(P_NEWS_WAIT_AFTER);
	value=p_getmisc(src_db, P_KEY_NEWSWAITSECS);
	if(value)
		WaitS=atoi(value);
	else
		WaitS=atoi(P_NEWS_WAIT_SECS);

	while(go)
	{
		switch(getopt(argc, argv, "a:f:g:hH:iklnqrsvVw:"))
		{
			case 'a':
				WaitA=atoi(optarg);
				break;
			case 'f':
				strcpy(urlfile, optarg);
				break;
			case 'g':
				strcpy(groups, optarg);
				break;
			case 'H':
				strcpy(server, optarg);
				serverptr=server;
				break;
			case 'i':
				options|=OPT_INSERTSUBJECTS;
				break;
			case 'k':
			    options|=OPT_KEYNAZI;
				break;
			case 'l':
				options|=OPT_LENIENT;
				break;
			case 'n':
				options|=OPT_NAZI;
				break;
			case 'q':
				options|=OPT_QUIET;
				break;
			case 'r':
				options|=OPT_RESTART;
				break;
			case 's':
				options|=OPT_SLOPPY;
				break;
			case 'v':
				options|=OPT_VERBOSE;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				mysql_close(src_db);
				return(0);
				break;
			case 'w':
				WaitS=atoi(optarg);
				break;
			case -1:
				go=0;
				break;
			case 'h':
			default:
				usage(argv[0]);
				mysql_close(src_db);
				return(0);
				break;
		}
	}

	dst_db=p_connect();
	if(!dst_db)
	{
		mysql_close(src_db);
		return(-1);
	}

	if(urlfile[0])
	{
		retval=p_ftpleech(urlfile, options);
	
		mysql_close(src_db);
		mysql_close(dst_db);
		
		return(retval);
	}
	
	// Else newsleech
	
	retval=p_dlnews(serverptr, groups, options, WaitA, WaitS);

	mysql_close(src_db);
	mysql_close(dst_db);

	return(retval);
}

