// ------------------------------------------------------------------------- //
// $Id: clock.h,v 1.4 2003/04/01 10:29:08 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CLOCK_H_
#define _CLOCK_H_

//! Clock provides the time as a (float) number of seconds since start

#if defined WIN32 && (!defined __GNUC__)
typedef unsigned __int64 uint64;
# else
typedef unsigned long long int uint64;
#endif

class Clock {
public:
	Clock();
	~Clock();
	void  reset();
	float time();
	void  print();
	uint64 cycles();
private:
	void calibrate();
	uint64 time_zero;
	uint64 cycles_per_sec;
};

#endif /* _CLOCK_H_ */

// ------------------------------------------------------------------------- //
