// ------------------------------------------------------------------------- //
// $Id: refcount.h,v 1.7 2002/05/26 18:23:42 pandr Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _REFCOUNT_H_
#define _REFCOUNT_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include "common.h"

class Refcount
{
public:
	Refcount(bool auto_delete) : _ref(0), _delete(auto_delete) { };
	void incref() { _ref++; assert(_ref > 0); };
	void decref() { _ref--; assert(_ref >= 0); if (_delete && _ref == 0) delete this; }
	int refcount() const { return _ref; }
protected:
	virtual ~Refcount() {};
private:
	int  _ref;
	bool _delete;
};

template <class T> class Ref
{
public:
	// Creating a ref from nothing (is this safe?)
	Ref() : _obj(0)                      { }
	// Creating a ref from an object
	Ref(T* obj) : _obj(obj)              { if (_obj) _obj->incref(); }
	// Creating a ref from an ref
	Ref(const Ref &ref) : _obj(ref._obj) { if (_obj) _obj->incref(); }
	// Destrying a ref
	~Ref()                               { if (_obj) _obj->decref(); }
	// Assignment between refs
	Ref& operator=(const Ref& rhs)
	{
		// Careful now...
		if (rhs._obj) rhs._obj->incref();
		if (_obj) _obj->decref();
		_obj = rhs._obj;
		return *this;
	}
	// Make a ref look like a pointer
	T& operator*()  { return *_obj; }
	T* operator->() { return _obj; }
	operator bool() { return _obj != 0; }
private:
	T* _obj;
};


#endif /* _REFCOUNT_H_ */

// ------------------------------------------------------------------------- //
