/*
ClientDB.h
*/

#ifndef __CLIENTDB_H
#define __CLIENTDB_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <db1/db.h>           

#undef USE_REGEX
#define USE_REGEX

#ifdef USE_REGEX
#include<regex.h>
#endif

#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XSocket.h"
#include "XVector.h"

#define NUM_RECS_METADATA 7
#define DB_VERSION     "____VERSION____"
#define DB_NAME        "____NAME____"
#define DB_STRUCTURE   "____STRUCTURE____"
#define DB_PERMISSIONS "____PERMISSIONS____"
#define DB_LASTINT     "____LASTINT____"
#define DB_RECCOUNT    "____RECCOUNT____"
#define DB_MAXSIZE     "____MAXSIZE____"

#define CMAXFLAGS 10
typedef char TFlags [CMAXFLAGS + 1];
#define DB_FLAGRECORD_NAME    "__FLAGS__"
#define DB_FLAGRECORD_DEFAULT "----------"

#define DB_EXTENSION       "db"
#define DB_INDEX_EXTENSION "index"

enum TType { fRESERVED, fTEXT, fVARCHAR, fDATETIME, fURL, fINT, fREAL };
#define CMAXFIELDS 30
#define CMAXFIELDNAME 100
typedef char TFieldName [CMAXFIELDNAME + 1];
class TDBField
  {
  public:
    TFieldName fname, flabel, fdefault, fopt1, fopt2, fopt3, fopt4; 
    TType ftype;
    int fsequence, fmaxlength, fdisplaylength, findexlength;
    bool fcouldbenull;
  };
typedef XVector<TDBField> TMatField;

typedef struct 
  {
  int key;
  TBuffer uniqid, value;
  } TDBNodo, *PDBNodo;    
typedef XVector<TDBNodo> TDBNodoList;

typedef struct 
  {
  TBuffer dbname, dbstruct, dbpermissions, dbversion;
  int dblastint, dbreccount, dbmaxsize;
  TMatField *MatField;
  } TDBInfo;

#define CMAXUNIQID 20
typedef char TUniqId [CMAXUNIQID + 1];

enum TModeDB { fMODE_FULL, fMODE_SEARCH };

class ClientDB
  {
  private:
    DB *db, *dbindex;
    TDBNodoList dbnodolist; 
    TBuffer dbdir, dbfname, dbindexfname, ErrorMsg;
    int DefCreateMode, DefOpenMode; 
    enum DBTYPE DBType;
    enum TModeDB ModeDB;
    StringList SLSearch;
    TDBInfo dbinfo;
    bool obtainDBInfo (void);
    void displayDBStructure (void); 
    bool parseDBStructure (void);    
    bool parseDBPermissions (void);
    bool isRecordReserved (TUniqId uniqid);
    bool generaUniqID (TUniqId uniqid);
    bool isFieldName (TFieldName fieldname);
    bool isMainField (TFieldName fieldname);
    int getTotalNumRecords (void);
    bool incRecordCount (TUniqId uniqid);    
    bool delRecordCount (void);
    int deleteIDsFromIndex (StringList *SLIDItems);
    bool compactIndex (void);
    bool openIndex (void);
    bool closeIndex (void);
    bool putField_Text_ByID (TUniqId uniqid, TFieldName fieldname, char *data, int len);
    bool checkValidRecord (const char *envfile);
  public:
    ClientDB (const char *adbfname, const char *adbdir, bool ReadOnly);
    virtual ~ClientDB ();
    bool DBopen (void);
    bool DBclose (void);
    bool Sync (void);
    void displayDBInfo (XSocket *aXS);
    void displayDBStructure (XSocket *aXS);
    void displayDBPermissions (XSocket *aXS);
    const char *getErrorMsg (void);
    int getNumFields (void);    
    int getNumRecords (void);
    const char *getDBName (void);
    int getDBSize (void);
    int getFoundRecords (void);    
    bool isDBSearched (void);
    char *getUniqIDFromIndexPos (int pos, TUniqId uniqid);
    char *getField_Text_ByID (TUniqId uniqid, TFieldName fieldname, char *data, int *len);
    char *displayField_Text_ByID (TUniqId uniqid, TFieldName fieldname, TType fieldtype, char *data, int *len);
    int copyRecordsByID (StringList *SLUniqIDItems);
    int deleteRecordsByID (StringList *SLUniqIDItems);
    int markRecordsByID (StringList *SLUniqIDItems, int queflag, bool value);    
    int Expunge (void);
    bool pasteItems (StringList *SLPapeleraCopy, StringList *SLPapeleraCut);
    TType getTypeFromString (const char *stringtype);    
    const char *getStringFromType (TType atype);
    const TMatField *ClientDB::getMatField (void);    
    char *getDefaultValueField (TType atype, TBuffer adefault);    
    void getAllFieldNames (StringList *SLFieldNames);
    void getAllFieldLabels (StringList *SLFieldLabels);
    bool generaHTMLFormEditNewRecord (StringList *SLHTML);
    bool generaHTMLFormEditRecordByID (TUniqId uniqid, StringList *SLHTML);
    bool generaHTMLFormDisplayRecordByID (TUniqId uniqid, StringList *SLHTML);
    bool SaveRecordFromCGI (const char *envfile, char *recordid);
    bool generaHTMLIndexPage (const char *SortUrl, StringList *SLHTML);
    bool Sort (TFieldName fieldname);
    bool getFlagsById (TUniqId uniqid, TFlags flags);
    bool putFlagsById (TUniqId uniqid, TFlags flags);
    bool changeFlagById (TUniqId uniqid, int queflag, bool value);
    bool isFlagById (TUniqId uniqid, int queflag);
    bool Search (TFieldName fieldname, const char *whatsearch, StringList *SLRes);
    void deleteSearch (void);
    };

bool Match (const char *pc, const char *whatsearch);
void ProcessPattern (const char *whatsearch, TBuffer pattern);
bool getDBNameNoClass (const char *dbfilename, TBuffer dbname);
int getTotalDatabases (const char *dbdir, StringList *SLFilenames, StringList *SLNames);
bool creaDatabase (const char *user, const char *dbtemplate, const char *dbuserpath, const char *name, TBuffer sterror);
bool renameDatabase (const char *dbuserpath, const char *dbfn, const char *newname, TBuffer sterror);
bool deleteDatabase (const char *dbuserpath, const char *dbfn, TBuffer sterror);
bool dumpDatabase (const char *dbuserpath, const char *dbfn, TBuffer sterror, XSocket *aXS);
int getTotalFields (StringList *SLFields);
bool generaIndexFromDB (const char *dbfname, const char *dbindexfname, TBuffer strerr);

#endif

