
/*
InterDaemon.h
*/

#ifndef __INTERDAEMON_H
#define __INTERDAEMON_H

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>
#include <sys/wait.h>
#include <ctype.h>
#include <syslog.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "Config.h"
#include "Utils.h"
#include "XSocket.h"
#include "Import.h"
#include "HTMLBasic.h"
#include "Language.h"
#include "CCLIENT.h"
#include "SendMSG.h"
#include "UserOptions.h"
#include "Configuration.h"
#include "Addressbook.h"
#include "rutinas_db.h"
#include "PsTitle.h"
#include "ClientNNTP.h"
#include "Authentication.h"

//Services
#include "Service_Main.h"
#include "Service_Cclient.h"
#include "Service_PopPass.h"
#include "Service_ForwardMail.h"
#include "Service_Databases.h"
#include "Service_Finger.h"
#include "Service_FileBrowser.h"
#include "Service_SecVirtual.h"
#include "Service_UserAccounts.h"
#include "Service_Config.h"
#include "Service_Sieve.h"
#include "Service_Calendar.h"

int ChildLoop (int way);
void procsignals (int signal_type);
void *alarm_signal (void);
void initServer_beforeFork (int argc, char **argv, char **envp, int *cs);
void initServer_afterFork (int argc, char **argv, char **envp, int cs);
void SetHandlers (void);
void CheckServerCount (char *astlang);
void CheckParams (int cmd, char *connid, char *pw);
void CheckAllowServeralConns (void);
void ClearConn (void);
void AlarmInstall (void);
void doLocking (void);
void SwitchOnAlarm (int alarmtime);
void ExitServer (void);
void ErrorInLogin (void);
void setUserDirs (void);

#endif
                      


