#include <stdio.h>
#include <errno.h>
#include <sys/types.h>

#include <xcio.h>
#include "const.h"

struct ppxp_const_s PPxP_Name2Const[] = {
    { "XCMD_AUTO", XCMD_AUTO },
    { "XCMD_BYE", XCMD_BYE },
    { "XCMD_CONNECT", XCMD_CONNECT },
    { "XCMD_DISCONNECT", XCMD_DISCONNECT },
    { "XCMD_FILTER", XCMD_FILTER },
    { "XCMD_IPCONFIG", XCMD_IPCONFIG },
    { "XCMD_IPROUTE", XCMD_IPROUTE },
    { "XCMD_QUIT", XCMD_QUIT },
    { "XCMD_SAVE", XCMD_SAVE },
    { "XCMD_SET", XCMD_SET },
    { "XCMD_SOURCE", XCMD_SOURCE },
    { "XCMD_TERMINAL", XCMD_TERMINAL },
    { "XCMD_UNSET", XCMD_UNSET },
    { "XCMD_DOT", XCMD_DOT },
    { "XCMD_MAX", XCMD_MAX },
    { "CMD_FULLNAME", CMD_FULLNAME },
    { "CMD_SECURE", CMD_SECURE },
    { "PIST_NONE", PIST_NONE },
    { "PIST_DOWN", PIST_DOWN },
    { "PIST_RUN", PIST_RUN },
    { "PIST_UP", PIST_UP },
    { "PINFO_LCP", PINFO_LCP },
    { "PINFO_CCP", PINFO_CCP },
    { "PINFO_IPCP", PINFO_IPCP },
    { "PINFO_MAX", PINFO_MAX },
    { "XCBUFSIZ", XCBUFSIZ },
    { "CONSOLE_AUTOF", CONSOLE_AUTOF },
    { "CONSOLE_AUTOC", CONSOLE_AUTOC },
    { "CONSOLE_CURRENT", CONSOLE_CURRENT },
    { "PS_DEAD", PS_DEAD },
    { "PS_ESTABLISH", PS_ESTABLISH },
    { "PS_AUTHENTICATE", PS_AUTHENTICATE },
    { "PS_CALLBACK", PS_CALLBACK },
    { "PS_NETWORK", PS_NETWORK },
    { "PS_TERMINATE", PS_TERMINATE },
    { "XCIO_WAIT", XCIO_WAIT },
    { "XCIO_HELLO", XCIO_HELLO },
    { "XCIO_S_IN", XCIO_S_IN },
    { "XCIO_S_OUT", XCIO_S_OUT },
    { "XCIO_RETURN", XCIO_RETURN },
    { "XCIO_UP_INFO", XCIO_UP_INFO },
    { "XCIO_UP_ENVS", XCIO_UP_ENVS },
    { "XCIO_UP_AUTO", XCIO_UP_AUTO },
    { "XCIO_LOCK", XCIO_LOCK },
    { "XCIO_CONSOLES", XCIO_CONSOLES },
    { "XCIO_PWD_REQ", XCIO_PWD_REQ },
    { "XCIO_PWD_SET", XCIO_PWD_SET },
    { "XCIO_ENV_REQ", XCIO_ENV_REQ },
    { "XCIO_ENV_SET", XCIO_ENV_SET },
    { "XCIO_XCMD", XCIO_XCMD },
    { "XCIO_LAST", XCIO_LAST },
    { "XCIO_MESSAGE", XCIO_MESSAGE },
    { "XCIO_LISTUP", XCIO_LISTUP },
    { "XID_UPDATE", XID_UPDATE },
    { "XID_ANY", XID_ANY },
    { "LSTAT_PROMPT", LSTAT_PROMPT },
    { "LSTAT_NONE", LSTAT_NONE },
    { "LSTAT_TTY", LSTAT_TTY },
    { "LSTAT_CHAT", LSTAT_CHAT },
    { "LSTAT_PPP", LSTAT_PPP },
    { "LSTAT_NLINK", LSTAT_NLINK },
    { "LSTAT_DIAL", LSTAT_DIAL },
    { "MFLAG_AUTO", MFLAG_AUTO },
    { "NSTAT_IP", NSTAT_IP },
    { "NSTAT_IPX", NSTAT_IPX },
    { NULL, 0 }
};

static char *xcio_names[] = {
    "XCIO_WAIT",
    "XCIO_HELLO",
    "XCIO_S_IN",
    "XCIO_S_OUT",
    "XCIO_RETURN",
    "XCIO_UP_INFO",
    "XCIO_UP_ENVS",
    "XCIO_UP_AUTO",
    "XCIO_LOCK",
    "XCIO_CONSOLES",
    "XCIO_PWD_REQ",
    "XCIO_PWD_SET",
    "XCIO_ENV_REQ",
    "XCIO_ENV_SET",
    "XCIO_XCMD",
    "XCIO_MESSAGE",
    "XCIO_LISTUP",
};

char *
PPxP_XcioStr(int x)
{
    size_t n = x & ~XCIO_LAST;
    if(n > sizeof(xcio_names)/sizeof(xcio_names[0])){
	return(NULL);
    }else{
	return(xcio_names[n]);
    }
}
