/*****
*
* Copyright (C) 2000, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

struct pcap_pkthdr;


void capture_raw(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_clip(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_fddi(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_null(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_ppp(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_slip(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_ethernet(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);
void capture_data(packet_container_t *packet, unsigned char *p, unsigned int len);
void capture_sll(unsigned char *user, struct pcap_pkthdr *h, unsigned char *p);

packet_container_t *packet_new(unsigned char *p);

void packet_release(packet_container_t *packet);

void packet_lock(packet_container_t *packet);
