/***************************************************************************
                          configuration.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "prokyon.h"
#include "configuration.h"

#include "gui.h"
#include "configuration_dialog.h"

#include <qlistview.h>
#include <qtooltip.h>

Configuration::Configuration(): showtooltip(0) {
  settings = new QSettings();
  db_host     = settings->readEntry("/prokyon3/database/host", "localhost");
  db_database = settings->readEntry("/prokyon3/database/database", "prokyon");
  db_user     = settings->readEntry("/prokyon3/database/user", "prokyon");
  db_pass     = settings->readEntry("/prokyon3/database/pass", "prokyon");
  mp3dirs     = settings->readListEntry("/prokyon3/directories/mp3dirs");
  startuptip  = settings->readNumEntry("/prokyon3/startup/showtip", 1);
  readid3v2   = settings->readNumEntry("/prokyon3/general/readid3v2", 1);
  writeid3v2  = settings->readNumEntry("/prokyon3/general/writeid3v2", 1);
  autoconn    = settings->readNumEntry("/prokyon3/general/autoconnect", 0);
  autohide    = settings->readNumEntry("/prokyon3/general/autohiding", 1);
  avoidhdd    = settings->readNumEntry("/prokyon3/general/avoidHDDlisting", 0);
  avoidsmb    = settings->readNumEntry("/prokyon3/general/avoidSMBlisting", 0);
  avoidnfs    = settings->readNumEntry("/prokyon3/general/avoidNFSlisting", 0);
  allowguirestore = settings->readNumEntry("/prokyon3/general/allowguirestore", 1);
  playcmd     = settings->readEntry("/prokyon3/general/playcommand", "xmms");
  enqueuecmd  = settings->readEntry("/prokyon3/general/enqueuecommand", "xmms --enqueue");
  burnCDcmd  = settings->readEntry("/prokyon3/general/burnCDcommand", "prokburn");

  posx  = settings->readNumEntry("/prokyon3/GUIpos/posx", 10);
  posy  = settings->readNumEntry("/prokyon3/GUIpos/posy", 50);
  width  = settings->readNumEntry("/prokyon3/GUIpos/width", 800);
  height  = settings->readNumEntry("/prokyon3/GUIpos/height", 600 );

  setShowToolTip( settings->readNumEntry("/prokyon3/general/showtooltip", 1) );

  info_Length = settings->readNumEntry("/prokyon3/infolist/info_Length", 1 );
  info_Media = settings->readNumEntry("/prokyon3/infolist/info_Media", 0 );
  info_Bitrate = settings->readNumEntry("/prokyon3/infolist/info_Bitrate", 1 );
  info_Album = settings->readNumEntry("/prokyon3/infolist/info_Album", 1 );
  info_Comment = settings->readNumEntry("/prokyon3/infolist/info_Comment", 1 );
  info_Year = settings->readNumEntry("/prokyon3/infolist/info_Year", 1 );
  info_Genre = settings->readNumEntry("/prokyon3/infolist/info_Genre", 1 );
  info_Path = settings->readNumEntry("/prokyon3/infolist/info_Path", 0 );
  info_Filename = settings->readNumEntry("/prokyon3/infolist/info_Filename", 1 );
  info_radiostate = settings->readNumEntry("/prokyon3/infolist/info_radiostate", 2 );

  bool ok;
  info_columnwidth = settings->readListEntry("/prokyon3/infolist/columwidth", &ok);
  if (!ok) info_columnwidth.clear(); 
  info_columnmap = settings->readListEntry("/prokyon3/infolist/colummap", &ok);
  if (!ok) info_columnmap.clear(); 
  info_guisize = settings->readListEntry("/prokyon3/infolist/guisize", &ok);
  if (!ok) info_guisize.clear(); 
  info_guisizer = settings->readListEntry("/prokyon3/infolist/guisizer", &ok);
  if (!ok) info_guisizer.clear(); 
  info_guisizel = settings->readListEntry("/prokyon3/infolist/guisizel", &ok);
  if (!ok) info_guisizel.clear(); 
  info_guisizem = settings->readListEntry("/prokyon3/infolist/guisizem", &ok);
  if (!ok) info_guisizem.clear(); 

  setMaxWidthMode( settings->readNumEntry("/prokyon3/general/maxwidthmode", 1) );

  toggleleft = settings->readBoolEntry("/prokyon3/GUIpos/toggleleft", true );
  togglebottom = settings->readBoolEntry("/prokyon3/GUIpos/togglebottom", true );
  toggleright = settings->readBoolEntry("/prokyon3/GUIpos/toggleright", true );
}

Configuration::~Configuration(){
  settings->writeEntry("/prokyon3/database/host", db_host);
  settings->writeEntry("/prokyon3/database/database", db_database);
  settings->writeEntry("/prokyon3/database/user", db_user);
  settings->writeEntry("/prokyon3/database/pass", db_pass);
  settings->writeEntry("/prokyon3/directories/mp3dirs", mp3dirs);
  settings->writeEntry("/prokyon3/startup/showtip", 0);
  settings->writeEntry("/prokyon3/general/readid3v2", readid3v2);
  settings->writeEntry("/prokyon3/general/writeid3v2", writeid3v2);
  settings->writeEntry("/prokyon3/general/autoconnect", autoconn);
  settings->writeEntry("/prokyon3/general/autohiding", autohide);
  settings->writeEntry("/prokyon3/general/avoidHDDlisting", avoidhdd);
  settings->writeEntry("/prokyon3/general/avoidSMBlisting", avoidsmb);
  settings->writeEntry("/prokyon3/general/avoidNFSlisting", avoidnfs);
  settings->writeEntry("/prokyon3/general/allowguirestore", allowguirestore);
  settings->writeEntry("/prokyon3/general/playcommand", playcmd);
  settings->writeEntry("/prokyon3/general/enqueuecommand", enqueuecmd);
  settings->writeEntry("/prokyon3/general/burnCDcommand", burnCDcmd);

  settings->writeEntry("/prokyon3/GUIpos/posx", posx );
  settings->writeEntry("/prokyon3/GUIpos/posy", posy );
  settings->writeEntry("/prokyon3/GUIpos/width", width );
  settings->writeEntry("/prokyon3/GUIpos/height", height );

  settings->writeEntry("/prokyon3/general/showtooltip", showtooltip);

  settings->writeEntry("/prokyon3/infolist/info_Length", (int)gui->getListing()->readInfo_lengthCheck());
  settings->writeEntry("/prokyon3/infolist/info_Media", (int)gui->getListing()->readInfo_mediaCheck());
  settings->writeEntry("/prokyon3/infolist/info_Bitrate", (int)gui->getListing()->readInfo_bitrateCheck());
  settings->writeEntry("/prokyon3/infolist/info_Album", (int)gui->getListing()->readInfo_albumCheck());
  settings->writeEntry("/prokyon3/infolist/info_Comment", (int)gui->getListing()->readInfo_commentCheck());
  settings->writeEntry("/prokyon3/infolist/info_Year", (int)gui->getListing()->readInfo_yearCheck());
  settings->writeEntry("/prokyon3/infolist/info_Genre", (int)gui->getListing()->readInfo_genreCheck());
  settings->writeEntry("/prokyon3/infolist/info_Path", (int)gui->getListing()->readInfo_pathCheck());
  settings->writeEntry("/prokyon3/infolist/info_Filename", (int)gui->getListing()->readInfo_filenameCheck());
  settings->writeEntry("/prokyon3/infolist/info_radiostate", gui->getListing()->readInfo_radiostate());
  settings->writeEntry("/prokyon3/infolist/columwidth", gui->getListing()->readColumnWidth());
  settings->writeEntry("/prokyon3/infolist/colummap", gui->getListing()->readColumnMap());

  settings->writeEntry("/prokyon3/infolist/guisize", info_guisize);
  settings->writeEntry("/prokyon3/infolist/guisizer", info_guisizer);
  settings->writeEntry("/prokyon3/infolist/guisizel", info_guisizel);
  settings->writeEntry("/prokyon3/infolist/guisizem", info_guisizem);

  settings->writeEntry("/prokyon3/general/maxwidthmode", maxwidthmode);

  settings->writeEntry("/prokyon3/GUIpos/toggleleft", toggleleft );
  settings->writeEntry("/prokyon3/GUIpos/togglebottom", togglebottom );
  settings->writeEntry("/prokyon3/GUIpos/toggleright", toggleright );

  delete settings;
}
	
void Configuration::showConfigurationDialog() {
    Configuration_Dialog *dlg = new Configuration_Dialog(gui);
    int result = dlg->exec();
    if(result == QDialog::Accepted) {
	db_host = dlg->db_host_line->text();
	db_database = dlg->db_database_line->text();
	db_user = dlg->db_user_line->text();
	db_pass = dlg->db_pass_line->text();
	playcmd = dlg->play_line->text();
	enqueuecmd = dlg->enqueue_line->text();
	burnCDcmd = dlg->burnCD_line->text();
	readid3v2 = dlg->readv2check->isChecked() ? 1 : 0;
	writeid3v2 = dlg->writev2check->isChecked() ? 1 : 0;
	autoconn = dlg->autocheck->isChecked() ? 1 : 0;
	autohide = dlg->hidecheck->isChecked() ? 1 : 0;
	avoidhdd = dlg->hddcheck->isChecked() ? 1 : 0;
	avoidsmb = dlg->smbcheck->isChecked() ? 1 : 0;
	avoidnfs = dlg->nfscheck->isChecked() ? 1 : 0;
	allowguirestore =  dlg->guirestore->isChecked() ? 1 : 0;
	setShowToolTip( dlg->showtooltip->isChecked() ? 1 : 0 );
	setMaxWidthMode( dlg->maxwidthmode->isChecked() ? 1 : 0 );
	mp3dirs.clear();
	QListViewItem *curr = dlg->hddlist->firstChild();
	while(curr) {
	    mp3dirs.append(curr->text(0));
	    curr = curr->nextSibling();
	}
    }
}

void Configuration::setShowToolTip( int _tooltip) {
    showtooltip = _tooltip;
    QToolTip::setGloballyEnabled( _tooltip );
}

QValueList<int> Configuration::listString2Int( QStringList qs) {
  QValueList<int> qi;
  QStringList::Iterator it = qs.begin();
  while( it != qs.end() ) {
    qi << (*it).toInt() ;
    ++it;
  }
  return qi;
}

QStringList Configuration::listInt2String( QValueList<int> qi) {
  QStringList qs;
  QValueList<int>::Iterator it = qi.begin();
  while( it != qi.end() ) {
    qs << QString::number(*it) ;
    ++it;
  }
  return qs;
}

QValueList<int> Configuration::getinfo_guisize() {
  return listString2Int( info_guisize );
}  

QValueList<int> Configuration::getinfo_guisizer() {
  return listString2Int( info_guisizer );
}  

QValueList<int> Configuration::getinfo_guisizel() {
  return listString2Int( info_guisizel );
}  

QValueList<int> Configuration::getinfo_guisizem() {
  return listString2Int( info_guisizem );
}  

void  Configuration::setinfo_guisize( QValueList<int> qi) {
  info_guisize = listInt2String( qi );
}

void  Configuration::setinfo_guisizer( QValueList<int> qi) {
  info_guisizer = listInt2String( qi );
}

void  Configuration::setinfo_guisizel( QValueList<int> qi) {
  info_guisizel = listInt2String( qi );
}

void  Configuration::setinfo_guisizem( QValueList<int> qi) {
  info_guisizem = listInt2String( qi );
}


