/***************************************************************************
                          gui_listing.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gui_listing.h"

#include "gui.h"
#include "datadispatcher.h"
#include "configuration.h"
#include "jobmanager.h"
#include "job_deletetrackphysically.h"

#include "lvi_track.h"
#include "job_modifyplaylist_tracks.h"

#include <qlayout.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <qtooltip.h>

#include <stdlib.h>

// ##############################################
// # initialize listing gui
// ##############################################
GUI_Listing::GUI_Listing(QWidget *parent, const char *name )
  : QFrame(parent, name)
{
  QVBoxLayout *blay = new QVBoxLayout(this);
  
  tabbar = new QTabWidget(this);
  
  selectionframe = new QFrame(this);
  QVBoxLayout *selblay = new QVBoxLayout(selectionframe);
  
  // radiobuttons for selecting sources
  QFrame *hframe = new QFrame(selectionframe);
  QHBoxLayout *hlay = new QHBoxLayout(hframe);
	
  selbox = new QButtonGroup(1, Qt::Horizontal, _("Sources"), hframe);
  QFrame *selframe = new QFrame(selbox);
  QGridLayout *selgrid = new QGridLayout(selframe, 3, 1);
  QRadioButton *hddradio = new QRadioButton(_("Only Available Tracks"), selframe);
  selgrid->addWidget(hddradio, 0, 0);
  QRadioButton *cdromradio = new QRadioButton(_("Only NOT Available Tracks"), selframe);
  selgrid->addWidget(cdromradio, 1, 0);
  QRadioButton *bothradio = new QRadioButton(_("All Tracks"), selframe);
  selgrid->addWidget(bothradio, 2, 0);
  selbox->insert(hddradio, 0);
  selbox->insert(cdromradio, 1);
  selbox->insert(bothradio, 2);
  connect(selbox, SIGNAL(clicked(int)), SLOT(slot_changeRadio(int)));
  
  hlay->addWidget(selbox);
  
  // checkboxes for additional informations
  QGroupBox *infobox = new QGroupBox(1, Qt::Horizontal, _("Additional Information"), hframe);
  QFrame *infoframe = new QFrame(infobox);
  QGridLayout *infogrid = new QGridLayout(infoframe, 3, 3);
  
  info_lengthcheck = new QCheckBox(_("Length"), infoframe);
  infogrid->addWidget(info_lengthcheck, 0, 0);
  info_bitratecheck = new QCheckBox(_("Bitrate"), infoframe);
  infogrid->addWidget(info_bitratecheck, 0, 1);
  info_yearcheck = new QCheckBox(_("Year"), infoframe);
  infogrid->addWidget(info_yearcheck, 0, 2);
  info_genrecheck = new QCheckBox(_("Genre"), infoframe);
  infogrid->addWidget(info_genrecheck, 1, 0);
  info_albumcheck = new QCheckBox(_("Album"), infoframe);
  infogrid->addWidget(info_albumcheck, 1, 1);	
  info_commentcheck = new QCheckBox(_("Comment"), infoframe);
  infogrid->addWidget(info_commentcheck, 1, 2);
  info_pathcheck = new QCheckBox(_("Path"), infoframe);
  infogrid->addWidget(info_pathcheck, 2, 0);	
  info_filenamecheck = new QCheckBox("Filename", infoframe);
  infogrid->addWidget(info_filenamecheck, 2, 1);
  info_mediacheck = new QCheckBox(_("Medium"), infoframe);
  infogrid->addWidget(info_mediacheck, 2, 2);
  
  connect(info_lengthcheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Length(int)));
  connect(info_bitratecheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Bitrate(int)));
  connect(info_yearcheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Year(int)));
  connect(info_genrecheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Genre(int)));
  connect(info_albumcheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Album(int)));
  connect(info_commentcheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Comment(int)));
  connect(info_pathcheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Path(int)));
  connect(info_filenamecheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Filename(int)));
  connect(info_mediacheck, SIGNAL(stateChanged(int)), this, SLOT(slot_Media(int)));

  hlay->addWidget(infobox, 1);
  
  // the selection buttons
  QFrame *butframe = new QFrame(selectionframe);
  QGridLayout *butlay = new QGridLayout(butframe, 1, 7);
  
  button_All = new QPushButton(_("Select All"), butframe);
  butlay->addWidget(button_All, 0, 1);
  button_None = new QPushButton(_("Select None"), butframe);
  butlay->addWidget(button_None, 0, 3);
  button_Invert = new QPushButton(_("Invert Selection"), butframe);
  butlay->addWidget(button_Invert, 0, 5);
  
  connect(button_All, SIGNAL(clicked()), this, SLOT(slot_selectionAll()));
  connect(button_None, SIGNAL(clicked()), this, SLOT(slot_selectionNone()));
  connect(button_Invert, SIGNAL(clicked()), this, SLOT(slot_selectionInvert()));
  
  selblay->addWidget(hframe);
  selblay->addWidget(butframe, 1);
  
  // tab search
  searcher = new GUI_Searcher();
  
  trackframe = new QFrame();
  trackframe->setFixedHeight(1);
	
  tabbar->addTab(trackframe, _("Tracks"));

//========================================================================================
//  tabbar->adjustSize();
//  tabbarMinSize = tabbar->height() - 1;
//  trackframe->setFixedHeight(0);

//  tabbar->addTab(selectionframe, _("Selection"));
//  tabbar->addTab(searcher, _("Search"));

//  tabbar->adjustSize();
//  tabbarMaxSize = tabbar->height();
//  tabbar->setFixedHeight(tabbarMinSize);
//----------------------------------------------------------------------------------------
// ^^^ <-- adding of tabs 'Selection' and 'Search', sizing moved to polish() method [HoSa]
//========================================================================================
  
  connect(tabbar, SIGNAL(currentChanged(QWidget*)), this, SLOT(slot_tabChanged(QWidget*)));
  
  // the listing widget
  listing = new ExtendedListView(this);
  char* temps = _( "Multiselect and right click to play titles,\nadd them to a playlist, or edit tags.\nYou can also drag and drop tracks to xmms." ); 
  QToolTip::add( listing, temps);
  QToolTip::add( listing->viewport(), temps);
  listing->addColumn("", -1);
  listing->addColumn(_("Medium"), 100);
  listing->addColumn(_("Artist"), 120);
  listing->addColumn(_("Title"), 160);
  listing->addColumn(_("Length"), -1);
  listing->setColumnAlignment(4, Qt::AlignRight);
  listing->addColumn(_("Bitrate"), -1);
  listing->setColumnAlignment(5, Qt::AlignRight);
  listing->addColumn(_("Album"), 160);
  listing->addColumn(_("Comment"), 160);
  listing->addColumn(_("Year"), -1);
  listing->setColumnAlignment(8, Qt::AlignCenter);
  listing->addColumn(_("Genre"), 60);
  listing->addColumn(_("Path"), 200);
  listing->addColumn(_("Filename"), 200);
  
  listing->setItemMargin(0);
  
  listing->setAllColumnsShowFocus(true);
  listing->setSelectionMode(QListView::Extended);
  
  connect(listing, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)),
	  this, SLOT(slot_contextMenu(QListViewItem*, const QPoint&, int)));

  connect(listing, SIGNAL(selectionChanged()), this, SLOT(slot_selectionChanged()));
  connect(listing, SIGNAL(currentChanged(QListViewItem*)), this, SLOT(slot_currentChanged(QListViewItem*)));
  connect(listing, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slot_doubleClicked(QListViewItem*)));
  
  connect(listing->header(), SIGNAL(clicked(int)), this, SLOT(slot_selectionChanged2(int)));
  
  blay->addWidget(tabbar);
  blay->addWidget(listing, 1);
  
  for(int i = 0; i < 12; i++) widthes[i] = listing->columnWidth(i);
  
  // set default states
  info_lengthcheck->setChecked( config->readInfo_Length() );
  info_mediacheck->setChecked( config->readInfo_Media() );
  info_bitratecheck->setChecked( config->readInfo_Bitrate() );
  info_albumcheck->setChecked( config->readInfo_Album() );
  info_commentcheck->setChecked( config->readInfo_Comment() );
  info_yearcheck->setChecked( config->readInfo_Year() );
  info_genrecheck->setChecked( config->readInfo_Genre() );
  info_pathcheck->setChecked( config->readInfo_Path() );
  info_filenamecheck->setChecked( config->readInfo_Filename() );
  
  slot_Length( config->readInfo_Length() );
  slot_Media( config->readInfo_Media() );
  slot_Bitrate( config->readInfo_Bitrate() );
  slot_Album( config->readInfo_Album() );
  slot_Comment( config->readInfo_Comment() );
  slot_Year( config->readInfo_Year() );
  slot_Genre( config->readInfo_Genre() );
  slot_Path( config->readInfo_Path() );
  slot_Filename( config->readInfo_Filename() );
  
  radioState = config->readinfo_radiostate();
  slot_changeRadio( radioState );
  switch( radioState ) {
  case 0 : hddradio->setChecked(true);
    break;
  case 1 : cdromradio->setChecked(true);
    break;
  default : bothradio->setChecked(true);
  }

  if ( !config->getMaxWidthMode() ) {
    QStringList qs = config->getinfo_columnwidth();
    int loop = 0;
    for ( QStringList::Iterator it = qs.begin(); it != qs.end(); ++it ) {
      listing->header()->resizeSection( loop, (*it).toInt());
      ++loop;
    }
  }
  if ( config->getAllowGuiRestore() ) {
    QStringList qs = config->getinfo_columnmap();
    int loop = 0;
    for ( QStringList::Iterator it = qs.begin(); it != qs.end(); ++it ) {
      listing->header()->moveSection(loop,(*it).toInt());
      ++loop;
    }
  }

  listing->triggerUpdate();

  editmode = false;

  resetSorting();
}

void GUI_Listing::polish()
{
  QFrame::polish();
  tabbarMinSize = tabbar->minimumSizeHint().height();

  /* add tabs 'Selection' and 'Search' */
  /*-----------------------------------*/
  tabbar->addTab(selectionframe, _("Selection"));
  tabbar->addTab(searcher, _("Search"));
    
  /* determine maximum size of tabbar */
  /*----------------------------------*/
  tabbarMaxSize = tabbar->minimumSizeHint().height();
    
  /* set tabbar size for tab 'Tracks' */
  /*----------------------------------*/
  tabbar->setFixedHeight(tabbarMinSize);
}

void GUI_Listing::slot_tabChanged(QWidget *widget) {
	if(widget != trackframe) tabbar->setFixedHeight(tabbarMaxSize);
	else tabbar->setFixedHeight(tabbarMinSize);
}

// ##############################################
// # callbacks for the checkboxes
// ##############################################
void GUI_Listing::slot_Media(int state)    { toggleColumn(1, state); }
void GUI_Listing::slot_Length(int state)   { toggleColumn(4, state); }
void GUI_Listing::slot_Bitrate(int state)  { toggleColumn(5, state); }
void GUI_Listing::slot_Album(int state)    { toggleColumn(6, state); }
void GUI_Listing::slot_Comment(int state)  { toggleColumn(7, state); }
void GUI_Listing::slot_Year(int state)     { toggleColumn(8, state); }
void GUI_Listing::slot_Genre(int state)    { toggleColumn(9, state); }
void GUI_Listing::slot_Path(int state)     { toggleColumn(10, state);}
void GUI_Listing::slot_Filename(int state) { toggleColumn(11, state);}

// ##############################################
// # callbacks for the buttons
// ##############################################
void GUI_Listing::slot_selectionAll()    { listing->selectAll(true);  }
void GUI_Listing::slot_selectionNone()   { listing->selectAll(false); }
void GUI_Listing::slot_selectionInvert() { listing->invertSelection();}

// ##############################################
// # callback for selection
// ##############################################
void GUI_Listing::slot_selectionChanged()     {
  gui->getTagListing()->notifySelectionChanged();
}

void GUI_Listing::slot_currentChanged(QListViewItem *lvi) {
    gui->getTagListing()->notifyCurrentChanged(lvi);
}

void GUI_Listing::slot_doubleClicked(QListViewItem *lvi) {
  slot_playWithXMMS();
}

void GUI_Listing::slot_selectionChanged2(int c) {
  if(c == lastsort) sortlist[lastsort] *= -1;
  else sortlist[lastsort = c] = ++sortcount;
  if(!editmode) gui->getTagListing()->notifySelectionChanged();
  else gui->getTagListing()->notifySortingInEditModeChanged();
}

// ##############################################
// # callback for context menu
// ##############################################
void GUI_Listing::slot_contextMenu(QListViewItem *lvi, const QPoint &p, int)
{
  if(!lvi || !lvi->isSelectable()) return;
  listing->setCurrentItem(lvi);
  listing->setSelected(lvi, true);

  if(editmode) return;

  QPopupMenu *menu = new QPopupMenu(this);
//-  menu->insertTitle("Track Menu");

  LVI_Track *item = static_cast<LVI_Track*>(lvi);

//   if(item->getType() != MEDIUM_HARDDISK) {
//     if(!item->getIsRequested()) menu->insertItem("Request Track", this, SLOT(slot_requestTrack()), 0, 1);
//     else menu->insertItem("Delete Track Requestion", this, SLOT(slot_unrequestTrack()), 0, 1);
//     if(busyMap[item->getMedium()]) menu->disableItem(1);
//   }

  if(item->getIsAvailable()) {
    menu->insertItem(QPixmap(PROKYON_HOME + "/images/action_xmms.png"), _("PLAY track(s)"), this, SLOT(slot_playWithXMMS()), 0, 2);
    menu->insertItem(QPixmap(PROKYON_HOME + "/images/action_xmms.png"), _("ENQUEUE track(s)"), this, SLOT(slot_enqueueInXMMS()), 0, 3);
  }
//    menu->insertItem("append track(s) to current", this, SLOT(slot_addToCurrent()), 0, 5);
    if(gui->getPlaylisting()->getDisplayedPlaylistID() > 0) menu->insertItem(QPixmap(PROKYON_HOME + "/images/lvi_playlist.png"), _("append track(s) to selected playlist"), this, SLOT(slot_addToPlaylist()), 0, 6);
  if(item->getIsAvailable() && item->getType() != MEDIUM_CDROM) {
    menu->insertSeparator();
    menu->insertItem(QPixmap(PROKYON_HOME + "/images/action_remove.png"), _("Delete Track Physically"), this, SLOT(slot_deleteTrack()), 0, 4);
    if(busyMap.contains(item->getMedium()) && busyMap[item->getMedium()]) menu->setItemEnabled(4, false);
  }

  menu->exec(p, 0);
}

void GUI_Listing::slot_deleteTrack()
{
  LVI_Track *item = static_cast<LVI_Track*>(listing->currentItem());

  TRACK *track = new TRACK();
  track->id     = item->getOriginalTrack()->id;
  track->artist = item->getOriginalTrack()->artist;
  track->path   = item->getOriginalTrack()->path;
  track->filename = item->getOriginalTrack()->filename;
  track->medium = item->getOriginalTrack()->medium;
  //  track->isRequested = item->getOriginalTrack()->isRequested;

  jobman->addJob(new Job_DeleteTrackPhysically(track));
}

// ##############################################
// # callback for context menu items
// ##############################################
QString GUI_Listing::adjustString(QString s)
{
  for(unsigned i=0; i<s.length(); i++) {
    if(s[i] == '\"' || s[i] == '\\') s.insert(i++, '\\');
  }
  return s;
}

void GUI_Listing::slot_playWithXMMS() {
  QString command;
  QString tmpCmd;
  
  command.sprintf("%s", config->getPlayCmd().stripWhiteSpace().latin1() );
  
  for (QListViewItem *item = listing->firstChild(); item != 0; item = item->nextSibling())
  {
     if (item->isSelected() && dynamic_cast<LVI_Track*>(item)->getIsAvailable())
        command.append( tmpCmd.sprintf(" \"%s\"", (const char*)adjustString(QString(item->text(10) + "/" + item->text(11)).stripWhiteSpace().utf8())) );
  }
  command.append(" &");
  //  qWarning ( "system: %s", command.latin1() );
  system(command.latin1());
}

void GUI_Listing::slot_enqueueInXMMS() {
  QString command;
  QString tmpCmd;
  
  command.sprintf("%s", config->getEnqueueCmd().stripWhiteSpace().latin1() );
  
  for (QListViewItem *item = listing->firstChild(); item != 0; item = item->nextSibling())
  {
     if (item->isSelected() && dynamic_cast<LVI_Track*>(item)->getIsAvailable())
  	     command.append( tmpCmd.sprintf(" \"%s\"", (const char*)adjustString(QString(item->text(10) + "/" + item->text(11)).stripWhiteSpace().utf8())) );
  }
  command.append(" &");
//	cout << command << endl;
  system(command.latin1());
}

void GUI_Listing::slot_addToCurrent() {
  QList<TRACK> *templist;
  templist = new QList<TRACK>;
  for(QListViewItem *item = listing->firstChild(); item != 0; item = item->nextSibling()) {
    if(item->isSelected() && dynamic_cast<LVI_Track*>(item)->getIsAvailable())
      templist->append(dynamic_cast<LVI_Track*>(item)->getOriginalTrack());
  }

  jobman->addJob(new Job_ModifyPlaylist_Tracks(APPEND_PLAYLIST_TRACK, templist, 0));
}

void GUI_Listing::slot_addToPlaylist() {
  int ID;
  if((ID = gui->getPlaylisting()->getDisplayedPlaylistID()) < 0)
    return;

  QList<TRACK> *templist;
  templist = new QList<TRACK>;
  for(QListViewItem *item = listing->firstChild(); item != 0; item = item->nextSibling()) {
    if(item->isSelected() )
      templist->append(dynamic_cast<LVI_Track*>(item)->getOriginalTrack());
  }

  jobman->addJob(new Job_ModifyPlaylist_Tracks(APPEND_PLAYLIST_TRACK, templist, ID));
}

// ##############################################
// # callback for the radiobuttons
// ##############################################
void GUI_Listing::slot_changeRadio(int id)
{
  if(id == radioState) return;
  
  for(LVI_Track *item = listAll.first(); item != 0; item = listAll.next()) if(item->getIsShowed()) { listing->takeItem(item); item->setIsShowed(false); }

  for(LVI_Track *item = listAll.first(); item != 0; item = listAll.next()) {
    if((id == 0 && item->getIsAvailable())
       || (id == 1 && !item->getIsAvailable())
       || (id == 2))
      {
	listing->insertItem(item);
	item->setIsShowed(true);
      }
  }
  
  radioState = id;
  
  // restore sorting;
  sort();
  
  if(listing->childCount() != 0) listing->setSelected(listing->firstChild(), true);
  slot_selectionChanged();
}
  
// ##############################################
// # show or hide columns
// ##############################################
void GUI_Listing::toggleColumn(int column, int state)
{
  // hide column
  if(state == 0) {
    widthes[column] = listing->columnWidth(column);
    listing->setColumnText(column, "");

    listing->header()->resizeSection(column, 0);
    listing->triggerUpdate();
    // ^^^ you need this instead of listing->setColumnWidth(column, 0) ==> BUG?! in Qt

    listing->setColumnWidthMode(column, QListView::Manual);
    listing->header()->setClickEnabled(false, column);
    listing->header()->setResizeEnabled(false, column);
  }
  // show column
  if(state == 2) {

    listing->header()->resizeSection(column, widthes[column]);
    listing->triggerUpdate();
    // ^^^ you need this instead of listing->setColumnWidth(column, widthes[column]) ==> BUG?! in Qt
    
    if(column == 1)       listing->setColumnText(1, _("Medium"));
    else if(column == 4)  listing->setColumnText(4, _("Length"));
    else if(column == 5)  listing->setColumnText(5, _("Bitrate"));
    else if(column == 6)  listing->setColumnText(6, _("Album"));
    else if(column == 7)  listing->setColumnText(7, _("Comment"));
    else if(column == 8)  listing->setColumnText(8, _("Year"));
    else if(column == 9)  listing->setColumnText(9, _("Genre"));
    else if(column == 10) listing->setColumnText(10, _("Path"));
    else if(column == 11) listing->setColumnText(11, _("Filename"));
    
    if ( config->getMaxWidthMode() ) 
	       listing->setColumnWidthMode(column, QListView::Maximum);
    else
      listing->setColumnWidthMode(column, QListView::Manual);
    listing->header()->setClickEnabled(true, column);
    listing->header()->setResizeEnabled(true, column);
  }
  
  // adjust width for scrollingbar
  int width = 0;
  for(int i=0; i<= 11; i++) width += listing->header()->sectionSize(i);
  listing->resizeContents(width, listing->contentsHeight());
}

void GUI_Listing::notifyMediumBusy(int id, bool status) {
  busyMap[id] = status;
}

void GUI_Listing::notifyMediumAvailabilityChanged(int id, QString path, bool state)
{
  mapAvail[id] = state;
  if(state == true) mapPath[id] = path;

  for(LVI_Track *item = listAll.first(); item != 0; item = listAll.next()) if(item->getMedium() == id) {
    if(state == true && item->getType() != MEDIUM_HARDDISK) { item->applyPath(path); }
    item->setAvailability(state);
    if(!editmode) {
      int c=0;
      if((radioState == 0 || radioState == 2) && item->getIsAvailable() && !item->getIsShowed()) { listing->insertItem(item); item->setIsShowed(true); c++; }
      if((radioState == 1) && item->getIsAvailable() && item->getIsShowed()) { listing->takeItem(item); item->setIsShowed(false); c++; }
      if((radioState == 1 || radioState == 2) && !item->getIsAvailable() && !item->getIsShowed()) { listing->insertItem(item); item->setIsShowed(true); c++; }
      if((radioState == 0) && !item->getIsAvailable() && item->getIsShowed()) { listing->takeItem(item); item->setIsShowed(false); c++; }
      if(c > 0) {
	// restore sorting;
	sort();
	
	if(listing->childCount() != 0) listing->setSelected(listing->firstChild(), true);
	slot_selectionChanged();
      }
    }
  }
 if(editmode) gui->getTagListing()->notifySelectionChanged();
}

void GUI_Listing::notifyNewMediumBasis(QList<MEDIUM> *list)
{
  for(MEDIUM *medium = list->first(); medium != 0; medium = list->next()) notifyNewMedium(medium);
}

void GUI_Listing::notifyNewTrackListing(QList<TRACK> *list)
{
  if(editmode) return;
  
  // clear old data
  listing->clear();        // DEBUG ??? delete every single LVI ???
  listAll.clear();

  if(list != 0) for(TRACK *entry = list->first(); entry != 0; entry = list->next()) {
    LVI_Track *item = new LVI_Track(listing, entry);
    item->applyMedium(mapType[entry->medium], mapLabel[entry->medium]);
    if(mapAvail[entry->medium] && item->getType() != MEDIUM_HARDDISK) item->applyPath(mapPath[entry->medium]);
    item->setAvailability(mapAvail[entry->medium]);
     
    listAll.append(item);
    if(radioState == 0 && !item->getIsAvailable()) { listing->takeItem(item); item->setIsShowed(false); }
    if(radioState == 1 && item->getIsAvailable()) { listing->takeItem(item); item->setIsShowed(false); }
  }
  
  // restore sorting;
  sort();
  
  if(listing->childCount() != 0) listing->setSelected(listing->firstChild(), true);
    if(listing->childCount() != 0) listing->setCurrentItem(listing->firstChild());
  slot_selectionChanged();
}

void GUI_Listing::notifyNewMedium(MEDIUM *medium)
{
  mapLabel[medium->id] = medium->label;
  mapType[medium->id] = medium->type;
  mapAvail[medium->id] = (medium->type == MEDIUM_HARDDISK ? true : false);
}

void GUI_Listing::notifyMediumRemoved(int id)
{
  mapLabel.remove(id);
  mapType.remove(id);
  mapAvail.remove(id);
}

void GUI_Listing::notifyFilenameHasChanged(int id, QString filename) {
  for(LVI_Track *item = listAll.first(); item != 0; item = listAll.next())
    if(item->getOriginalTrack()->id == id) item->setNewFilename(filename);
}

void GUI_Listing::setEditMode(bool state)
{
  if ( verbose == 4 ) qWarning( "GUI_Listing::setEditMode(state=%s) starts", state ? "true" : "false");
  editmode = state;

  if (editmode) { // save previous tooltip
    oldtip = QToolTip::textFor( listing, QPoint(0,0));
    QToolTip::remove( listing );
    QToolTip::remove( listing->viewport() );
    char* temps = _( "Select one track to edit.\nAll modifications will be flagged,\nand need to be saved" );
    QToolTip::add( listing, temps );
    QToolTip::add( listing->viewport(), temps );
  } else { // restore previous tooltip
    QToolTip::remove( listing );
    QToolTip::remove( listing->viewport() );
    QToolTip::add( listing, oldtip);
    QToolTip::add( listing->viewport(), oldtip);
  }

  
  button_All->setEnabled(!editmode);
  button_None->setEnabled(!editmode);
  button_Invert->setEnabled(!editmode);
  selbox->setEnabled(!editmode);
  searcher->setConnectionState(!editmode);

  if(editmode) datadispatcher->eventAddReadWriteLock();
  else datadispatcher->eventRemoveReadWriteLock();

  if(editmode) {
    for(LVI_Track *item = listAll.first(); item != 0; item = listAll.next())
      if(item->getIsShowed() && !listing->isSelected(item)) { listing->takeItem(item); item->setIsShowed(false); }
    listing->selectAll(false);

    // listing->setSelectionMode(QListView::Extended)  multi selection work in progress... 
    listing->setSelectionMode(QListView::Single);
    
    if(listing->childCount() != 0) listing->setSelected(listing->firstChild(), true);
    QToolTip::add(this, _("Select to modify tag or file name"));
  } else {
    listing->setSelectionMode(QListView::Extended);
    listing->selectAll(true);
    for(LVI_Track *item = listAll.first(); item != 0; item = listAll.next()) {
      if((radioState == 0 || radioState == 2) && item->getIsAvailable() && !item->getIsShowed()) { listing->insertItem(item); item->setIsShowed(true); }
      if((radioState == 1) && item->getIsAvailable() && item->getIsShowed()) { listing->takeItem(item); item->setIsShowed(false); }
      if((radioState == 1 || radioState == 2) && !item->getIsAvailable() && !item->getIsShowed()) { listing->insertItem(item); item->setIsShowed(true); }
      if((radioState == 0) && !item->getIsAvailable() && item->getIsShowed()) { listing->takeItem(item); item->setIsShowed(false); }
    }
    // restore sorting;
    sort();
    QToolTip::add(this, _("Select and right click to play titles\nor to add them to a playlist"));
 }
  if ( verbose == 4 ) qWarning( "GUI_Listing::setEditMode() ends");
}

void GUI_Listing::resetSorting()
{
  for(int i=0; i<12; i++) sortlist[i] = 0;
  sortlist[2] = 2;
  sortlist[3] = 1;

  sortcount = 2;
  lastsort = 2;
}

void GUI_Listing::sort()
{
  int min = 0, actmax, actindex;

  do {
    actmax = sortcount;
    for(int i=0; i<12; i++) if(abs(sortlist[i]) > min && abs(sortlist[i]) <= actmax) { actindex = i; actmax = abs(sortlist[i]); }
    listing->setSorting(actindex, (abs(sortlist[actindex]) > 0));
    listing->sort();
    min = actmax;
  } while(actmax != sortcount);
}


void GUI_Listing::setConnectionState(bool state)
{
  searcher->setConnectionState(state);
  if(state == false) clear();
  if(state == false) editmode = false;
  isConnected = state;

}

QStringList GUI_Listing::readColumnWidth()
{
  QStringList qs;
  for ( int i=0; i<listing->columns(); i++ ) {
    qs += QString::number(listing->columnWidth(i));
   }
  return qs;
}

QStringList GUI_Listing::readColumnMap()
{
  QStringList qs;
  for ( int i=0; i<listing->columns(); i++ ) {
    qs += QString::number(listing->header()->mapToIndex(i));
  }
  return qs;
}

void GUI_Listing::clear()
{
  notifyNewTrackListing(0);
}

GUI_Listing::~GUI_Listing() {}
