/***************************************************************************
                          jobmanager.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JOBMANAGER_H
#define JOBMANAGER_H

#include "jobbase.h"

#include <qthread.h>
#include <qptrlist.h>
#include <qmap.h>

class JobManager {
public: 
	JobManager();
	
	void addJob(JobBase *job);	

	void jobDone(JobBase *job);

	void incrJobCounter();
	void decrJobCounter();
				
	void lock()		{ mutex.lock(); }
	void unlock()	{ mutex.unlock(); }
	
	~JobManager();

private:
	void deleteFinishedJobs();
	
	bool	job_connect_isRunning;
	bool	job_disconnect_isRunning;
	bool	job_query_isRunning;
	bool	job_modify_isRunning;
    bool    job_generate_isRunning;
	
	QMap<int, bool> job_synchronize_isRunning;

	int		jobCounter;
	
	QMutex	mutex;

	QList<JobBase> jobList;
};

#endif
