#ifndef F_SYM_NAM_H_INCLUDED
#define F_SYM_NAM_H_INCLUDED /* allow multiple inclusions */

/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: f_sym_name.h,v 1.5 2004/01/09 20:29:28 type2 Exp $ */

/*
********************************************************************************
**
**                          PROSPECT PROJECT
**                       F_SYM_NAME DEFINITIONS
**
********************************************************************************
*/

#include <sys/stat.h>
#include <stdio.h>
#include <elf.h>
#include <libelf/libelf.h>

/* f_sym_name structures */
typedef struct elf_hit_tbl64
{
        Elf64_Sym  *elf_ht_ls;
} elf_hit_tbl_64_t, *Pelf_hit_tbl_64_t;

#define cElf64HT_SZ   ((size_t)sizeof(elf_hit_tbl_64_t))

typedef struct elf_hit_tbl32
{
        Elf32_Sym  *elf_ht_ls;
} elf_hit_tbl_32_t, *Pelf_hit_tbl_32_t;

#define cElf32HT_SZ   ((size_t)sizeof(elf_hit_tbl_32_t))


/* Symbol Table Structure */
typedef struct  _syms_key
{       
        int              sk_fd;         /* fd of file                        */
        char            *sk_Path;       /* Path to open file in case closed  */
        ino_t            sk_Inum;       /* Inode of Open'ed file             */
        dev_t            sk_Dev;        /* Dev of Open'ed file               */
        unsigned int     sk_ElfFlag;    /* Are these 64-bit ELF or SOM ?     */
        int              sk_isElf32;    /* Are these 32-bit ELF or 64 ?      */
        unsigned int     sk_sym_count;  /* Number of symbols in table        */
        unsigned int     sk_exec_magic; /* executable PA magic number        */

        unsigned long    sk_exec_tmem;  /* Offset of text in memory          */
        unsigned long    sk_exec_tfile; /* Location of text in file          */
        unsigned long    sk_exec_dmem;  /* Offset of data in memory          */

        void            *sk_ht_tbl;   /* Internal table used for bsearch'ing  */
        void            *sk_lesyms;   /* System dependent ld symbol table     */

        char            *sk_strings;  /* Symbol string table                  */
        struct  fs      *sk_Pfs;      /* pointer to super block buffer        */
        struct  dinode  *sk_Pdinode;  /* Inode of current file                */
        int              sk_isDynamic;/* Is this the DYNSYM table?            */
        int              sk_isShlib;  /* Is this a shared library?            */
        int              sk_isReloc;  /* Is this image relocatable?           */
} syms_key_t;


typedef struct  _syms_attrb
{
        unsigned long    sa_value;      /* Numb  Value of symbol */
        char            *sa_name;       /* Ascii Name  of symbol */
        char            *sa_type;       /* Ascii Type  of symbol */
        char            *sa_scope;      /* Ascii Scope of symbol */
} syms_attrb_t;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Open up and allocate memory for symbol table search */
int f_sym_name_list(syms_key_t *, char *);

/* Return pointer to symbol information for passed "value" */
void *f_sym_name(syms_key_t *, char *);

/* Return pointer to Global symbol information for passed "value" */
void *f_sym_name_global(syms_key_t *, char *);

/* Symbol information for passed pointer */
void f_sym_attrb(syms_key_t *, void *, syms_attrb_t *);
void f_sym_attrb_next(syms_key_t *, void *, syms_attrb_t *);

/*  Free the table, I.E. a close from the above open */
void f_sym_name_free(syms_key_t *);

/* print out a symbol table entry */
void elf_print_sym_entry(void *, syms_key_t *pSk);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* F_SYM_NAM_H_INCLUDED */
