/* *************************************************************************
  Module:        lexgui.h
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Header file for pup.

  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** */
#include <zlib.h>
#ifndef PUP_INCLUDED
#define PUP_INCLUDED

#define TITLE "Printer Utility Program"
#define VERSION "v1.1"
#define CURYEAR "2000" 
#define NUMPAGE 3        /* ttl no. of top notebook pages */
#define NUMBUT 16        /* ttl no. of buttons in all the top notebook pages */
#define NUMCLOCKS 4      /* timers used by io_struct in query process */
#define QUERY_TIMEOUT 20 /* number of seconds to wait until query gives up. */
#define JMAX 100         /* str len allocated for each choice[] in choices_str*/
#define NF 3             /* number of fset[] in grpch_struct */
#define MAXLINELENGTH 255

enum color_enum {
  WHITE, BLACK, RED, GREEN, YELLOW, BEIGE, BROWN1, BROWN2, BROWN3, BROWN4, GREY
};
enum colorsection_enum {
  FG, BG, LIGHT, DARK, MID, TEXT, BASE
};
enum mode_enum {
  NORMAL, ACTIVE, PRELIGHT, SELECTED, INSENSITIVE
};
enum uname_enum {
  USYSNAME, UNODENAME, URELEASE, UVERSION, UMACHINE
};

/*------------------- Decoding and Uncompressing ----------------------*/
/* Used in ptp.c */

#define UBUFSIZE 1024  /* must be > 60 */
#define MAX_U_LINELENGTH 100

typedef struct { /* see ptp.c for description of inout_struct */
  FILE *out;
  unsigned char ebuf[2 * UBUFSIZE];/* encoded, deflated thing in */
  unsigned char in_buf[UBUFSIZE];  /* decoded, deflated thing in */
  unsigned char out_buf[UBUFSIZE]; /* inflated thing out */
  z_stream z;
  int in_buf_len;
} inout_struct;

/*-------------------------------- Misc -------------------------------*/
typedef struct {
  GtkWidget *msglabel;
  GtkWidget *expbutton;
  GtkWidget *h_msgbox;
  GtkWidget *explain_dialog;
  gint explain;
  gint freeze;
  gint timer;
  gint timecount;
} msgbox_struct;

typedef struct {
  msgbox_struct *msgboxptr;
  gint butnum;
} mbb_struct;

typedef struct {
  GtkWidget *frame;
  GtkWidget *align;
  GtkWidget *hbox;
  GtkWidget *pbox;
} framebox_struct;

typedef struct {
  /* The following is initialized with related info from $HOME/.puprc 
     Also see note at end of read_prefs() */
  gchar outfile[MAXLINELENGTH]; /* Output listed in prefs window */ 
  gchar printer[MAXLINELENGTH]; /* Currently selected printer */

  /* array index corresponding to a name in printer_name[] and a set
     of variables for this printer in *pv[]. Set to currently selected
     printer. */
  gint index;
 
  /* Family of printers that share PJL commands, eg Lexmark or HP. Set to
     family corresponding to currently selected printer. */
  gint family;

  /* Inhibit setting the sensitivity to TRUE of a top notebook's table 
     or button. Used to inhibit something when it is not applicable to
     the selected printer. */
  gint t_inhibit[NUMPAGE]; /* Pages can be seen listed in make_notebook() */ 
  gint b_inhibit[NUMBUT];  /* Buttons can be seen listed in make_nbtable() */

} prefs_struct;

/*--------------------- Regular Scrolled Window ------------------------*/
typedef struct {
  GtkWidget *text;/* Text box. Set to NULL for a scrolled window. */
  gint tba;/*Hand scroll mode; 0 = active, 1 = text select or no hand scroll*/
  GtkAdjustment *hadj;
  GtkAdjustment *vadj;
  gint prevx;
  gint prevy;
} aj_struct;

typedef struct {
  gint *tba_ptr;
  GtkWidget *widget;
  GdkCursor *cursor;
} cur_struct;

typedef struct {
  /* Tabs show parent-child relationship */
  aj_struct aj;
  GtkWidget *topwin;             /* top scrolled-win window */
    GtkWidget *topvbox;
      GtkWidget *tophbox;
        GtkWidget *sc_win;
          GtkWidget *sc_fixedcon;
            GtkWidget *sc_vbox;    /* Put stuff to scroll in this box */
  gint info_only_flag;
} sw_struct;

/*------------------------------ Top Window ---------------------------*/
typedef struct {
  GtkWidget *vbox[NUMPAGE];
  GtkWidget *table[NUMPAGE];
  GtkWidget *button[NUMBUT];
  GtkWidget *blabel[NUMBUT];
} bt_struct;

typedef struct {
/* Tabs show parent-child relationship */
  GtkWidget *topwindow;
    GtkWidget *vbox_top;
      GtkWidget *prefmenu; /* vbox_top > menu bar > menu > prefmenu */
      GtkWidget *frame;
        GtkWidget *vbox_main;
          GtkWidget *entry;
          GtkWidget *printerlabel;
          GtkWidget *notebook;
            bt_struct bt;     /* Settings, Printouts, Cartridge Main. pages */
          msgbox_struct msgbox;
  gint activebut;
  gint entry_state;
  sw_struct infowin;
  GtkWidget *aboutwin;
  prefs_struct prefs;
  gint pflag;
} topwin_struct;

typedef struct {
  topwin_struct *topptr;
  gint butnum;
} curbut_struct;

/*----------------------------- Task Window ---------------------------*/
typedef struct{
  /* Tabs show parent-child relationship */
  topwin_struct *top;      /* Ref to Top Window */
  GtkWidget *tasktop;      /* The task window top */
    GtkWidget *vbox_top;
    msgbox_struct msgbox; 
    GtkWidget *dialog;
} task_struct;

/*-------------------- Scrolled Choices Windows ------------------------*/
typedef struct {
  GSList *group;
  gchar name[JMAX];
  GtkWidget **ac_ptr;   /* ref to ac_button in dc_struct */
  GtkWidget **fc_ptr;   /* ref to fc_button in dc_struct */
  msgbox_struct *msgbox_ptr; /* set to msgbox_ptr in dc_struct */
  gchar current[JMAX];
  gint choicetype;      /* 0 = enumerated, 1 = range */
  gint numchoices;      /* Number of choices for this group */
#ifdef NOTUSED
  gint sonly;           /* flag for "set only" variable (can't make default) */
#endif

  /* The choice is one of two possible types: */
  /*--- For enumerated choicetype: ---*/
  gint numchoices_alloc;
  GtkWidget **rbutton;  /* need to malloc this */
  GtkWidget *nochangebutton; /* for non dynamic only (fixed settings) */
  gchar (*choice)[JMAX];/* need to malloc this */
  gchar new[JMAX];      /* new value when choice is enumerated */

  /*--- For range choicetype: --------*/
  GtkWidget *check;
  GtkObject *adjustment;/* new value extracted from this when choice is range */
  GtkWidget *scale;
  gint rtype;           /* 0 = gint, 1 = gfloat */
  gfloat fset[NF];       /* [0] = min, [1] = max, [2] = current */

  gint changed;         /* 0 = no change (so ignore new values), 1 = changed */
} grpch_struct;

typedef struct {
  topwin_struct *top;   /* Ref to Top Window */
  sw_struct sw;
  GtkWidget *dc_vbox;
  GtkWidget *ac_button; /* The Apply Changes button */
  GtkWidget *fc_button; /* The Forget Changes button */
  GtkWidget *rf_button; /* The Reset Factory Defaults button */

  /* Each heading with its choices gets a grpch_struct */
  gint gcount;          /* current number of grpch_struct (groups of choices) */
  gint gr_alloc_count;  /* number of grpch_struct allocated */
  grpch_struct *gr;     /* need to malloc this */

  msgbox_struct *msgbox_ptr; /* ref to msgbox in io_struct */
  GtkWidget *dialog;    /* dialog for reset factory defaults & pop_set_note() */
  sw_struct help;
  FILE *fp;             /* Output for apply choices */
  gint numtochange;     /* Total number of changes based on user selections */ 
  gint numchanged;      /* Counter for changes in progress. Max = numtochange */
  gint ad_count;        /* Counter for groups of choices. Max = gcount */ 
  gint fixq;            /* for non dynamic mode (fixed, output only) */
  gint fixinit;         /* init flag for non dynamic mode */
} dc_struct;

/*---------------------------- Query Data -----------------------------*/
typedef struct {
  msgbox_struct msgbox;
  gint clock[NUMCLOCKS];
  gint fd;
  gint count;
  gint start_read;
  gint terminate;
  gint timeout_count;
  gint busy;
  gint j;                  /* current string length of query */
  gint qlength;            /* string length allocated for query */
  gchar *query;            /* need to malloc this */
  /*--- The following determines  which commands to send.
     0 = query, 1 = get status, 2 = kill job, 3 = query for dynamic set ---*/
  gint command;

  /*--- For tx_struct; set to NULL when coming from dc_struct  ---*/
  aj_struct *aj_ptr; /* Address of aj in tx_struct; set in make_tx_win() */ 

  /*--- For dc_struct; set to NULL when coming from tx_struct. ---*/
  dc_struct *dc_ptr; /* Address set in set_dynamic_defs() */
} io_struct;

/*--------------------- Scrolled Text Query Window --------------------*/
typedef struct {
  /* Tabs show parent-child relationship */
  topwin_struct *top;     /* Ref to Top Window */
  aj_struct aj;
  GtkWidget *topwin;      /* top scrolled-text window */
    GtkWidget *topvbox;
      GtkWidget *hbox;
        GtkWidget *f0;    /* Fixed con for tb0 */
          GtkWidget *tb0; /* Hand scroll mode button */
        GtkWidget *f1;    /* Fixed con for tb1 */
          GtkWidget *tb1; /* Text select mode button */
  GtkStyle *inactive_style;
  GtkStyle *active_style;
  io_struct io;
} tx_struct;

/* ========================= Function Prototypes =========================== */
/*--- lexgui.c ------------------------------------------------------------- */
char *get_uinfo(gint u);
char *get_default_dev(void);
gint deleteW(GtkWidget *widget, GdkEventAny *gevent, gpointer data);
void destroyW(GtkWidget *widget, GdkEventAny *gevent, gpointer gdata);
void cleanTaskWin(task_struct *task);
gint deleteTWX(GtkWidget *widget, GdkEventAny *gevent, task_struct *task);
void deleteTW(GtkWidget *widget, task_struct *task);
gint close_iwindowX(GtkWidget *widget, GdkEventAny *gevent, GtkWidget **win);
void close_iwindow(GtkWidget *widget, GtkWidget **data);
void make_menu(topwin_struct *top);
void put_title(GtkWidget **vbox);
void init_msgbox(msgbox_struct *msgbox);
void init_inhibit(prefs_struct *prefs);
void init_prefs(prefs_struct *prefs);
void init_top(topwin_struct *top);
void init_task(topwin_struct *top, task_struct *task);
void init_io(io_struct *io, int btdt);
void init_texwin(topwin_struct *top, tx_struct *tw, gint btdt);
void init_dc(topwin_struct *top, dc_struct *dc, gint btdt);

/*--- errors.c ------------------------------------------------------------- */
void explain_CB(GtkWidget *widget, msgbox_struct *msgbox);
void pop_pref_note(gint mnum);

/*--- lexroutines.c -------------------------------------------------------- */
int stat_output(char *filename);
void set_sensitize(topwin_struct *top, int s);
void blank(GtkWidget *box);
gint gtk_msg_timer(msgbox_struct *msgbox);
void clear_message(msgbox_struct *msgbox);
void make_separator(GtkWidget *box);
void close_ibutton(GtkWidget **ibox, GtkWidget **itopwin);
void make_framebox(framebox_struct *fb, GtkWidget **box, gint width,
                   gint height, gchar *title);
void about_event(topwin_struct *top);
void make_pix_label_box(GtkWidget **vsbox, 
                        GtkWidget **p_box, GtkWidget **l_box);
GtkWidget *make_pix_box(void);
GtkWidget *make_label_box(char *imessage, gint font, gint width);
GtkWidget *make_underlinedlabel_box(char *imessage, gint font);
void put_info(GtkWidget *vsbox, GtkWidget **pixbox);
void infow_event(topwin_struct *top);
void set_tool_color(GtkTooltips **tooltips);
void put_msg(msgbox_struct *msgbox, char *mess, int lcolor, int explain);
int open_output(topwin_struct *top);
int open_pipe(msgbox_struct *msgbox);
void catch_alarm(int sig);
int open_output_dev(msgbox_struct *msgbox);
void closedev(void);
int opendev(msgbox_struct *msgbox, int ex);
void reset_top(topwin_struct *top, int now);
void setactivebut_CB(GtkWidget *widget, curbut_struct *b);
void put_mstring(GtkWidget **table, char *m_str, int top, int btm);
void make_messageBox(GtkWidget **vbox, msgbox_struct *msgbox);
void entry_callback(GtkWidget *widget, topwin_struct *top);
void make_entry(topwin_struct *top);

/*--- lexcalls.c ----------------------------------------------------------- */
int myputs(char *s, int count, FILE *fp, char *prog, msgbox_struct *msgbox);
void park_cartridges(msgbox_struct *msgbox);
void print_menu(msgbox_struct *msgbox);
void clean_nozzles(msgbox_struct *msgbox);
void reset_ink_gauge(int ink, msgbox_struct *msgbox);
void print_alignment(msgbox_struct *msgbox);
void send_alignment(int selection[4], msgbox_struct *msgbox);
void moveto_install(msgbox_struct *msgbox);
void send_types(int ltype, int rtype, msgbox_struct *msgbox);

/*--- lexgaugepop.c -------------------------------------------------------- */
void close_twbutton(tx_struct *tw);
void close_dcbutton(io_struct *io);
void close_tbutton(task_struct *task);
void popup_window(task_struct *task, char *title);
void clear_msgbox(msgbox_struct *m);
void gauge_CB(GtkWidget *widget, mbb_struct *mb);
void rgauges_window(int alreadyopen, topwin_struct *top);

/*--- lexalignpop.c -------------------------------------------------------- */
gint gtk_align_timer(gpointer data);
void clear_align_message(void);
void scale_CB(GtkAdjustment *adj, gint *indx);
void align_CB(GtkWidget *w, msgbox_struct *m);
void sendalign_CB(GtkWidget *w, msgbox_struct *m);
void make_scale(GtkWidget *hbox, int init_setting, int min, int max, int *indx);
GtkWidget *make_button(GtkWidget *box, char *label_str); 
void align_window(int alreadyopen, topwin_struct *top);

/*--- lexincar.c  ---------------------------------------------------------- */
gint gtk_inst_timer(gpointer data);
void clear_inst_message(void);
void accept_type_CB(GtkWidget *widget, msgbox_struct *m);
void left_CB(GtkWidget *widget, gint *cartype);
void right_CB(GtkWidget *widget, gint *cartype);
void install_CB(GtkWidget *w, msgbox_struct *m);
void park_CB(GtkWidget *w, msgbox_struct *m);
void ic_window(int alreadyopen, topwin_struct *top);

/*--- lexhand.c ------------------------------------------------------------ */
void create_bitmap_and_mask_from_xpm (GdkBitmap **bitmap,
                                      GdkBitmap **mask, gchar **xpm);
GdkCursor* create_hand_cursor(void);
GdkCursor* create_hand_g_cursor(void);
GdkCursor* create_thumb_cursor(void);
GtkWidget *CreateWidgetFromXpm (GtkWidget *window, gchar **xpm_data);

/*--- nbpages.c ------------------------------------------------------------ */
void make_notebook(topwin_struct *top);
void make_nbtable(topwin_struct *top, gint page, gint bstart, gint bend);
void button_CB(GtkWidget *widget, topwin_struct *top);

/*--- settings.c ----------------------------------------------------------- */
gint close_io(io_struct *io);
void remove_timers(io_struct *io);
void cleanTextWin(tx_struct *tw);
void cleanScrolledDCWin(io_struct *io);
gint deleteSTWX(GtkWidget *widget, GdkEventAny *gevent, tx_struct *tw);
void deleteSTW(GtkWidget *widget, tx_struct *tw);
gint deleteDCX(GtkWidget *widget, GdkEventAny *gevent, io_struct *io);
void deleteDC(GtkWidget *widget, io_struct *io);
gint rswinX(GtkWidget *widget, GdkEventAny *gevent, task_struct *t);
void rswin(GtkWidget *widget, task_struct *t);
void donotshow_CB(GtkWidget *widget, int *state);
void pop_set_note(task_struct *task, io_struct *io);
void put_query_message(msgbox_struct *msgbox, gchar *wait_message);
gint qqtimer(io_struct *io);
void qqtimer_call(io_struct *io);
gint qtimer(io_struct *io);
void qtimer_call(io_struct *io);
void send_get(tx_struct *tw);
gint check_busy(io_struct *io);
void send_get_build(io_struct *io);
void qp_CB(GtkWidget *widget, tx_struct *tw);
void pstat_CB(GtkWidget *widget, tx_struct *pstat);
void k_CB(GtkWidget *widget, tx_struct *pstat);
void buildlist_CB(GtkWidget *widget, io_struct *io);
void applychanges_CB(GtkWidget *widget, io_struct *io);
gint forgetchanges(dc_struct *dc);
void forgetchanges_CB(GtkWidget *widget, dc_struct *dc);
gint rcan_CBX(GtkWidget *widget, GdkEventAny *gevent, io_struct *io);
void rcan_CB(GtkWidget *widget, io_struct *io);
void rok_CB(GtkWidget *widget, io_struct *io);
void resetfactory_CB(GtkWidget *widget, io_struct *io);
void helplist_CB(GtkWidget *widget, dc_struct *dc);
void pr_settings_CB(GtkWidget *widget, io_struct *io);
void query_printer(topwin_struct *top);
void printer_defaults(io_struct *io);
void set_dynamic_defs(topwin_struct *top);
void set_fixed_defs(int alreadyopen, topwin_struct *top);
void printer_status(topwin_struct *top);

/*-- proutines.c ----------------------------------------------------------- */
char *chopSpace(char *string, int last);
int flush_dev(msgbox_struct *msgbox);
void clear_junk(void);
void put_text(io_struct *io);
void report_alloc_err(io_struct *io, gint messagenum);
gint rtimer(io_struct *io);
void rtimer_call(io_struct *io);
void get_settings(io_struct *io);

/*-- pcommands.c ----------------------------------------------------------- */
void uel(FILE *fp);
void cr(FILE *fp);
void print_PS_fonts(topwin_struct *top, msgbox_struct *msgbox);
void print_PCL_fonts(topwin_struct *top, msgbox_struct *msgbox);
void print_menu1(topwin_struct *top, msgbox_struct *msgbox);
void print_demo(topwin_struct *top, msgbox_struct *msgbox);
int send_commands(io_struct *io);
void reset_factory(io_struct *io);
gint adtimer(io_struct *io);
void adtimer_call(io_struct *io);
void apply_defaults(io_struct *io);

/*--- ptp.c ---------------------------------------------------------------- */
int check_err(int err, char *msg, msgbox_struct *msgbox);
int inflate_init(inout_struct *inout, msgbox_struct *msgbox);
void inflate_end(inout_struct *inout, msgbox_struct *msgbox);
int call_inflate(inout_struct *inout, msgbox_struct *msgbox);
int read_base64_header(char *uuestr, msgbox_struct *msgbox);
void read_base64(int index, char *uuestr, inout_struct *inout,
                 msgbox_struct *msgbox);
void uue_inflate(FILE *fpp, char *uuestr, msgbox_struct *msgbox);
void print_test_page(msgbox_struct *msgbox);
void print_ttf_page(msgbox_struct *msgbox);

/*--- lexwidgets.c --------------------------------------------------------- */
void hand_CB(GtkWidget *widget, GdkEventMotion *event, aj_struct *sws);
void mousepress_CB(GtkWidget *widget, GdkEventButton *event, cur_struct *c);
void sc_win_setup(GtkWidget **topwin, GtkWidget **topvbox,
                  char *title, int width, int height);
void make_sc_win(sw_struct *swptr, char *title, int width, int height);
void show_sc_win(sw_struct *swptr);
void mode_CB(GtkWidget *widget, tx_struct *tx);
void mode_b_CB(GtkWidget *widget, cur_struct *c);
void make_tx_win(tx_struct *txptr, char *title, int width, int height);

/*--- attributes.c --------------------------------------------------------- */
GdkColor get_color(int color);
void set_color(GtkWidget **w, int color, int section, int mode); 
void set_font(GtkWidget **w, int font_num);
GtkWidget *create_nbpix(GtkWidget **topwin, int p);
GtkWidget *create_pix(GtkWidget **topwin, int p);

/*--- build_choices.c ------------------------------------------------------ */
gint allocate_group(dc_struct *dc);
gint set_group(dc_struct *dc, gchar *sptr1, gchar *sptr2);
void set_current(dc_struct *dc, gchar *sptr1, gchar *sptr2);
#ifdef NOTUSED
gint setonly(gchar *choice);
#endif
gint skipit(gchar *choice);
gint parse_heading(dc_struct *dc, gchar *choice);
gint allocate_choices(dc_struct *dc);
void parse_choice(dc_struct *dc, gchar *choice, gint j);
gint process_h_c(dc_struct *dc, gchar *choice, gint check);
gint parse_query(io_struct *io);
void choice_CB(GtkWidget *widget, grpch_struct *gr);
void choice_scale_CB(GtkAdjustment *adj, grpch_struct *gr);
void choice_scale_check_CB(GtkWidget *widget, grpch_struct *gr);
void clear_choices(dc_struct *dc);
void build_choice_widgets(dc_struct *dc);
void build_choices(io_struct *io);

/*--- fixed.c -------------------------------------------------------------- */
void init_printer_name(prefs_struct *prefs);
void set_query_fixed(topwin_struct *top, io_struct *fio);
void get_family_command_str(gchar **ptr, gchar *cstring);
gchar *get_family_command(gint command, gint family, msgbox_struct *msgbox);
void set_printer_family(prefs_struct *prefs);
void set_sensitize_b(topwin_struct *top);
void set_inhibit(topwin_struct *top);
void set_printer_index(topwin_struct *top);
gint check_printer_name(gchar *name);
void combo_CB(GtkWidget *widget, topwin_struct *top);
void read_prefs(topwin_struct *top);
void prefsave_CB(GtkWidget *widget, task_struct *prf);
void prefentry_callback(GtkWidget *widget, topwin_struct *top);
void pref_event(topwin_struct *top);

#endif
