

DC="http://purl.org/dc/elements/1.1/"

import ResourceTypes
from Ft.Server import SCHEMA_NSS
from Ft.Rdf import RDF_MS_BASE
g_rdfResourceTypes = {ResourceTypes.ResourceType.CONTAINER: "%s#container" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.GROUP: "%s#group" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.USER: "%s#user" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.RAW_FILE: "%s#rawfile" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.URI_REFERENCE_FILE: "%s#urireferencefile" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.XML_DOCUMENT: "%s#xmldocument" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION: "%s#xpathdocumentdefinition" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION: "%s#xsltdocumentdefinition" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.XSLT_DOCUMENT: "%s#xsltdocument" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT: "%s#schematrondocument" % SCHEMA_NSS, 
                      ResourceTypes.ResourceType.RDF_DOCUMENT: "%s#rdfdocument" % SCHEMA_NSS, 
                      ResourceTypes.ResourceType.DOCUMENT_DEFINITION : "%s#documentdefinition" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.COMMAND : "%s#command" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.SERVER : "%s#server" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.ALIAS : "%s#alias" % SCHEMA_NSS,
                      ResourceTypes.ResourceType.META_DATA : "%s#meta_data" % SCHEMA_NSS,
                     }
    
g_resourceTypeFromRdf = {}
for name,value in g_rdfResourceTypes.items():
    g_resourceTypeFromRdf[value] = name


TYPE = SCHEMA_NSS + '#type'

SYSTEM_SOURCE_URI = SCHEMA_NSS + '#system'

TIME_TO_LIVE = SCHEMA_NSS + "#time_to_live"
RUN_ON_STROBE = SCHEMA_NSS + "#run_on_strobe"

CREATION_DATE = SCHEMA_NSS + "#creation_date"
MODIFIED_DATE = SCHEMA_NSS + "#modified_date"
OWNER = SCHEMA_NSS + "#owner"
GROUP_MEMBER = g_rdfResourceTypes[ResourceTypes.ResourceType.GROUP] + '.member'
GROUP_NAME = g_rdfResourceTypes[ResourceTypes.ResourceType.GROUP] + '.name'

USER_NAME = g_rdfResourceTypes[ResourceTypes.ResourceType.USER] + '.name'
CONTAINER_CHILD = g_rdfResourceTypes[ResourceTypes.ResourceType.CONTAINER] + '.child'
IMT = g_rdfResourceTypes[ResourceTypes.ResourceType.RAW_FILE] + '.imt'
CONTENT_SIZE = g_rdfResourceTypes[ResourceTypes.ResourceType.RAW_FILE] + '.size'
DOCDEF = g_rdfResourceTypes[ResourceTypes.ResourceType.XML_DOCUMENT] + '.document_definition'

BASE_DOCDEF = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.base_docdef'

NULL_DOCDEF = g_rdfResourceTypes[ResourceTypes.ResourceType.XML_DOCUMENT] + '.null_document_definition'


NO_VALIDATION = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.no_validation'
SCHEMATRON_VALIDATION = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.schematron_validation'
DTD_VALIDATION = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.dtd_validation'
XML_VALIDATION_TYPE = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.validation_type'


FULL_TEXT_INDEX = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.full_text_index'
XSLT_EXT_MODULE = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.xslt_extension_module'
ENFORCE_RDF_SCHEMA = g_rdfResourceTypes[ResourceTypes.ResourceType.DOCUMENT_DEFINITION] + '.enforce_rdf_schema'


STYLESHEET_DEPENDENCY = g_rdfResourceTypes[ResourceTypes.ResourceType.XSLT_DOCUMENT] + '.dependency'


COMMAND_NAME = g_rdfResourceTypes[ResourceTypes.ResourceType.COMMAND] + '.name'
COMMAND_FULL_NAME = g_rdfResourceTypes[ResourceTypes.ResourceType.COMMAND] + '.full_name'
COMMAND_SUBCOMMAND = g_rdfResourceTypes[ResourceTypes.ResourceType.COMMAND] + '.subcommand'

SERVER_NAME = g_rdfResourceTypes[ResourceTypes.ResourceType.SERVER] + '.name'
SERVER_HANDLER  = g_rdfResourceTypes[ResourceTypes.ResourceType.SERVER] + '.handler'
SERVER_RUNNING = g_rdfResourceTypes[ResourceTypes.ResourceType.SERVER] + '.running'

ALIAS_REFERENCE = g_rdfResourceTypes[ResourceTypes.ResourceType.ALIAS] + '.reference'

URI_REFERENCE_LOCATION = g_rdfResourceTypes[ResourceTypes.ResourceType.URI_REFERENCE_FILE] + '.location'


