<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--
File:  front.xslt

Description:

    This file creates the main view of the GuestBook Demo application.
    It uses frdf:complete to get a list of all guests in the system,
    then creates a table from them. It also creates a form that the
    user can use to enter new guest data. The form is submitted to
    newGuest.xslt.

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:param name="fres:uri-path"/>
  <xsl:output method="html"/>
  <xsl:template match="/">
    <html>
      <head>
        <TITLE>Sample Guest Book application</TITLE>
        <link rel="STYLESHEET" type="text/css" href="/GuestBook/gb-netscape.css"/>
        <script language="JavaScript1.2" type="text/javascript">
          <xsl:comment>
        if (document.all) document.createStyleSheet("gb-ie.css");

      function submitForm(form, action){
        document.main.action= action;
        document.main.submit();
      }

      function confirmRecordDelete( name ){
        if( !confirm('Are you sure you want to delete this ' + escape(name) + '?')){
          return false;
        }
        else {
          document.main.actionToDo.value = 'delete';
          document.main.submit();
        }
      }

        function validateQty(){
          if( document.main.qty.value &gt; 0 ){
              document.main.actionToDo.value = 'add';
              document.main.submit();
          }
          else {
                  alert('Quantity must be greater than zero!');
                  return false;
          }
      }

        </xsl:comment>
        </script>
      </head>

      <body class="normal">
        <table class="normal" cellspacing="0" width="100%" cellpadding="5">
          <tr height="40" align="center">
            <td class="logo" colspan="2">Guest Book</td>
          </tr>
          <tr class="cellBlue">
            <td class="menu" colspan="2" align="left">Guests in the system</td>
          </tr>
          <tr>
            <td>
              <table border="1" width="100%" cellpadding="2" bgcolor="#FFFFFF" bordercolorlight="#C0C0C0" class="normal">
                <tr class="cellGray">
                  <td class="blackTitle" align="center">Name</td>
                  <td class="blackTitle" align="center">Email Address</td>
                  <td class="blackTitle" align="center">Description</td>
                </tr>
                <xsl:variable name="guest-list" select="frdf:complete(frdf:any(), '&rdf;type', 'http://4Suite.org/guest')"/>
                <xsl:choose>
                  <xsl:when test="$guest-list/Subject">
                    <xsl:apply-templates select="$guest-list/Subject"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <tr>
                      <td align="center" colspan="3">No Guest Registered</td>
                    </tr>
                  </xsl:otherwise>
                </xsl:choose>
              </table>
            </td>
          </tr>
        </table>

        <p>Would you like to be registered as a guest on the system?</p>
        <p>Simply enter in some basic information and press Register.</p>

        <form action="{$fres:uri-path}" method="POST">
          <table width="100%" cellpadding="5" class="normal">
            <tr>
              <td class="blackTitle" width="25%">Name: </td>
              <td>
                <input type="text" name="name" size="35"/>
              </td>
            </tr>
            <tr>
              <td class="blackTitle" width="25%">Email Address: </td>
              <td>
                <input type="text" name="email" size="35"/>
              </td>
            </tr>
            <tr>
              <td class="blackTitle" width="25%">Brief Description: </td>
              <td>
                <input type="text" name="description" size="35"/>
              </td>
            </tr>
            <tr>
              <td colspan="2" align="left">
                <input type="submit" VALUE="Register"/>
              </td>
            </tr>
          </table>
          <input type="hidden" name="xslt" VALUE="newGuest.xslt"/>
        </form>
        <hr/>
        <p>If you'd like to know how this works behind the scenes, read the <a href="tech.doc?xslt=/ftss/data/sdocbook_html.xslt">tech tour</a>.</p>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="Subject">
    <xsl:variable name="name" select='frdf:complete(.,"&dc;title",frdf:any())/Object'/>
    <xsl:variable name="description" select='frdf:complete(.,"&dc;description",frdf:any())/Object'/>
    <xsl:variable name="email" select='frdf:complete(.,"http://4Suite.org/guest#Email",frdf:any())/Object'/>
    <tr>
      <td>
        <xsl:value-of select="$name"/>
      </td>
      <td>
        <a href="mailto:{$email}">
          <xsl:value-of select="$email"/>
        </a>
      </td>
      <td>
        <xsl:value-of select="$description"/>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
