#!/usr/bin/env python 
""" bank05: The single Random Customer"""
from SimPy.Simulation  import *
from random import expovariate, seed               

class Customer(Process):
    """ Customer arrives at a random time,
        looks around  and then leaves
    """
        
    def visit(self,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        yield hold,self,timeInBank
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():
    seed(99999)                                  
    initialize()
    c=Customer(name="Klaus")
    t = expovariate(1.0/5.0)                     
    activate(c,c.visit(timeInBank=10.0),delay=t) 
    simulate(until=100.0)

model()
