#ifndef VISUAL_PYRAMID_H
#define VISUAL_PYRAMID_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "prim.h"

namespace visual {

class pyramid : public Primitive
{
 private:
	double width;
	double height;

 public:
	pyramid()
		: width(1.0), height(1.0) {}
	inline double get_width() const { return width; }
	inline double get_length() const { return axis.mag(); }
	inline double get_height() const { return height; }
	inline vector get_size() { return getScale(); }

	void set_width( const double& w);
	void set_length( const double& l);
	void set_height( const double& h);
	void set_size( const vector& v);
	inline void set_size_t( boost::python::object t) { set_size( vector(t)); }

	virtual vector getScale();
	virtual void glRender( rView& view);

};


} // !namespace visual

#endif // !VISUAL_PYRAMID_H
