#include "playlistviewitem.h"
#include <iostream>

playlistViewItem::playlistViewItem(QListView *parent, unsigned int id, unsigned int time, QString a, QString b = QString::null, QString c = QString::null, QString d = QString::null, QString e = QString::null, QString f = QString::null, QString g = QString::null, QString h = QString::null)
	: QListViewItem(parent, a, b, c, d, e, f, g, h), m_id(id), m_time(time), m_bold(false)
{
	
}

playlistViewItem::~playlistViewItem()
{

}

unsigned int playlistViewItem::getid() const
{
	return m_id;
}

QString playlistViewItem::key(int column, bool ascending) const
{
	QString temp;
    switch (column)
    {
    case 0:
        temp.sprintf("%9d", m_id);
        break;
    case 1:
        // temp = m_info.m_title.c_str();
        return QListViewItem::key(column, ascending);
	case 2:
        temp.sprintf("%9d", m_time / 1000);
        break;
    case 3:
        return QListViewItem::key(column, ascending);
    
    }
    return temp;           
}

void playlistViewItem::paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
	// cout << "Reimplemented paintCell called" << endl;
	// p->setFont( QFont("Times", 10, QFont::Bold) );
	QFont fnt(p->font());
	if (m_bold)
		fnt.setBold(true);
	else
		fnt.setBold(false);
	p->setFont(	fnt );
	QListViewItem::paintCell(p, cg, column, width, align);
}

bool playlistViewItem::isBold() const
{
	return m_bold;
}

void playlistViewItem::setBold(bool value)
{
	m_bold = value;
}
