/*
 * main.cpp
 * $Id: main.cpp,v 1.4 2001/11/20 16:23:48 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Test program to demonstrate how a derived viewer
//                can be used with a self written Renderer


/** documentation stuff

  @author Michael Meissner

  @version 0.0 //see cvs docu

*/


// Qt
///////
#include <qapplication.h>
#include <qstring.h>
#include <qgl.h>
#include <qmenubar.h>       // only for the menu
#include <qpopupmenu.h>     // only for the menu


// System
///////////
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


// Own
////////
#include "QGLExaminerViewer.h"
#include "CInterpolationRenderer.h"
#include "CBoundingBox3D.h"


//////////////////////////////////
//////////////////////////////////
//                              //
//                              //
//           M A I N            //
//                              //
//                              //
//////////////////////////////////
//////////////////////////////////
int main(int argc, char *argv[])
{
QGLExaminerViewer *pViewer;
CInterpolationRenderer *pRenderer;


   // start Qt stuff
   ///////////////////
   QApplication::setColorSpec( QApplication::CustomColor );
   QApplication app(argc,argv);

   // generate new viewer
   ////////////////////////
   QGLFormat f;
   QGLFormat::setDefaultFormat(f);
   f.setStereo(TRUE);
   pViewer = new QGLExaminerViewer(CCamera(0.0, 0.0, -25.0, 
                                           0.0, 0.0, 0.0, 
			   	           0.0, 1.0, 0.0,
				           CBoundingBox3D(-4.0,-4.0,-4.0,4.0,4.0,4.0)),
                           NULL, "viewer", NULL, 0, true, f);   // fullviewer
   Q_CHECK_PTR(pViewer);

   pViewer->allowStereoSimulation(TRUE);

   // generate new renderer
   //////////////////////////
   pRenderer = new CInterpolationRenderer(pViewer);
   Q_CHECK_PTR(pRenderer);
 
   // Connect signals of viewer with slots of renderer
   /////////////////////////////////////////////////////
   QObject::connect(pViewer, SIGNAL(sigInitGL()), 
                    pRenderer, SLOT(sltInitializeGL()));
   QObject::connect(pViewer, SIGNAL(sigResizeGL(int,int)), 
                    pRenderer, SLOT(sltResizeGL(int,int)));
   QObject::connect(pViewer, SIGNAL(sigRedrawGL()), 
                    pRenderer, SLOT(sltPaintGL()));




   QObject::connect(pViewer, SIGNAL(sigSelected(QMouseEvent *)), 
                    pRenderer, SLOT(sltManageSelection(QMouseEvent *)));
   QObject::connect(pViewer, SIGNAL(sigRenderModeChanged()), 
                    pRenderer, SLOT(sltResetSelection()));
   QObject::connect(pViewer, SIGNAL(sigReleased(QMouseEvent *)), 
                    pRenderer, SLOT(sltManageRelease(QMouseEvent *)));
   QObject::connect(pViewer, SIGNAL(sigMoved(QMouseEvent *)), 
                    pRenderer, SLOT(sltManageMove(QMouseEvent *)));
 
   // Launch viewer
   //////////////////
   app.setMainWidget(pViewer);
   pViewer->resize(450,420);
   pViewer->show();
   
   int nRet = app.exec();

   delete pRenderer;
   delete pViewer;

   return nRet;
}
