/*
 * CameraPathPlayer.cpp
 *
 * Copyright (C) 2001 Michael Meissner, Alexander Buck
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

/*
  [tw] 2001/04/29 initial version
*/


// System
///////////
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

// Qt
///////
#include <qapplication.h>
#include <qstring.h>
#include <qgl.h>
#include <qmenubar.h>       // only for the menu
#include <qpopupmenu.h>     // only for the menu

// QGLViewer
//////////////
#include <QGLExaminerViewer.h>
#include <CP3D.h>

// Own
////////
#include "CPlayerRenderer.h"
#include "CBoundingBox3D.h"
#include "QCameraPathPlayer.h"



//////////////////////////////////
//////////////////////////////////
//                              //
//                              //
//           M A I N            //
//                              //
//                              //
//////////////////////////////////
//////////////////////////////////
int main(int argc, char *argv[])
{
   // start Qt stuff
   ///////////////////
   QApplication::setColorSpec(QApplication::CustomColor);
   QApplication app(argc,argv);
  
   QGLFormat f;
   QGLFormat::setDefaultFormat(f);

   QGLExaminerViewer *pViewer = new QGLExaminerViewer(CCamera(0.0, 0.0, -25.0, 
                                                              0.0, 0.0, 0.0, 
                                                              0.0, 1.0, 0.0,
                                                      CBoundingBox3D(-4.0,-4.0,-4.0,
                                                                     4.0,4.0,4.0)),
                                                      NULL, "viewer", NULL, 0, true, f);   // fullviewer
   Q_CHECK_PTR(pViewer);

   QCameraPathPlayer *pPlayer = new QCameraPathPlayer(pViewer);
   Q_CHECK_PTR(pPlayer);
   pPlayer->show();

				   
   // generate new renderer
   //////////////////////////
   CPlayerRenderer *pRenderer = new CPlayerRenderer(pViewer);
   Q_CHECK_PTR(pRenderer);
    
   // Connect signals of pPlayer with slots of renderer
   /////////////////////////////////////////////////////
   QObject::connect(pViewer, SIGNAL(sigInitGL()), 
                    pRenderer, SLOT(sltInitializeGL()));
   QObject::connect(pViewer, SIGNAL(sigResizeGL(int,int)), 
                    pRenderer, SLOT(sltResizeGL(int,int)));
   QObject::connect(pViewer, SIGNAL(sigRedrawGL()), 
                    pRenderer, SLOT(sltPaintGL()));

   // Launch pPlayer
   //////////////////
   app.setMainWidget(pViewer);
   pViewer->resize(450, 420);
   pViewer->show();
    
   int nRet = app.exec();
    
   delete pRenderer;
   delete pPlayer;
   delete pViewer;
    
   return nRet;
}
