/*
 * QIconOptions.h
 *
 * Copyright (C) 2001 Thomas Woerner, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */



#ifndef _QICONOPTIONS_H
#define _QICONOPTIONS_H


// Qt
///////
#include <qdialog.h>
#include <qlineedit.h>


/** Simple GUI to manage the render size of cameras.
  *
  * @author Thomas Woerner, Michael Meissner
  *
  * [tw] 2001/05/19 initial version
  */
class QIconOptions : public QDialog
{ 
   Q_OBJECT

   public:

      /** Constructs new options GUI. */
      QIconOptions(QWidget* parent=0, const char* name=0, 
                   bool modal=FALSE, WFlags fl=0);

      /** Destructs (default). */
      ~QIconOptions() {}

      /** Returns arrow size. */
      double getArrowSize();

      /** Returns frustum size. */
      double getFrustumSize();

   signals:

      void sigArrowChanged(double);
      void sigFrustumChanged(double);

   public slots:

      /** slot for arrow size. */
      void sltArrowSize(const QString &qText) {
	emit(sigArrowChanged(qText.toDouble()));
      };

      /** slot for frustum size. */
      void sltFrustumSize(const QString &qText) {
	emit(sigFrustumChanged(qText.toDouble()));
      };

   protected:

      QLineEdit *m_pArrowSize;
      QLineEdit *m_pFrustumSize;
};


#endif /* QICONOPTIONS_H */
