/*
 * QSceneTreeNode.h
 * $Id: QSceneTreeNode.h,v 1.13 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 2001 Richard Guenther
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Definition of the QSceneTreeNode class 
//  Purpose     :
//

#ifndef __QSCENETREENODE_H
#define __QSCENETREENODE_H

#include <qevent.h>

#include "CMat4D.h"
#include "CBoundingBox3D.h"
#include "CTree.h"
#include "GLDrawable.h"


/** Base class of a scene tree node.
  *
  * @author Richard Guenther
  */
class QSceneTreeNode : public CTreeNode {
public:
  /** Default constructor. */
  QSceneTreeNode()
    : CTreeNode(),
      m_pTransformation(NULL),
      m_ViewingMode(normal) {};
  /** Destructor. */
  ~QSceneTreeNode();

  /** Returns the transformation matrix. */
  const CMat4D *getTransformation() const { return m_pTransformation; };
  /** Resets the transformation matrix. */
  void resetTransformation();
  /** Sets the transformation matrix. */
  void applyTransformation(const CMat4D&);

  /** Returns the bounding box of the (sub) tree
    * with this node as root. */
  virtual CBoundingBox3D getBoundingBox() const;

  /** Different viewing modes to handle different rendering. */
  enum ViewingMode { hidden, disabled, normal, highlighted, boxed };
  /** Returns the viewing mode. */
  ViewingMode getViewingMode() const { return m_ViewingMode; };
  /** Sets the viewing mode. */
  virtual void setViewingMode(ViewingMode mode) { m_ViewingMode = mode; };

  /** Call this method to request an update to the renderer. */
  virtual void requestUpdate() {
    ((QSceneTreeNode *)getParent())->requestUpdate();
  };

protected:
   CMat4D *m_pTransformation;
   ViewingMode m_ViewingMode;
};


/** This is a base class of a scene tree node which
  * can handle Qt events. */
class QSceneTreeDrawable : public QSceneTreeNode, public GLDrawable {
public:
  /** Default constructor. */
  QSceneTreeDrawable() : QSceneTreeNode() {};
  /** Destructor. */
  ~QSceneTreeDrawable(){};

  /** Method to handle Qt events. */
  virtual bool event(const QEvent *) { return false; };
};



#endif
