# QTads project file.  Run it through qmake to produce a Makefile.
#
# This file has been created by hand, but it seems Qt Designer can cope
# very well with it.
#
# Command line variables:
#
#   BUILD         - Must be either "release" (the default) or "debug".
#   BIN_INSTALL   - Executable installation directory.
#   DOC_INSTALL   - Documentation installation directory.
#   DATA_INSTALL  - Installation directory for various data files.
#   CFLAGS        - C optimization flags.
#   CXXFLAGS      - C++ optimization flags.
#
# Example:
#
#   qmake BIN_INSTALL=/usr/bin DOC_INSTALL=/usr/doc DATA_INSTALL=/usr/share
#   CFLAGS=-O3 CXXFLAGS=-O2
#
# When building the debug-version,
#
#   qmake BUILD=debug
#
# the optimization flags are ignored.

# Uncomment this if your system doesn't have type definitions for
# ushort, uint and ulong.  You will need to uncomment this if
# compilation fails with a message that looks like this:
# "ushort undeclared".
#
# Note: I never saw a system that needs this defined.
#
#DEFINES += OS_NO_TYPES_DEFINED

# Subdirectory to install the documentation.
#
QTADSDOCDIR = qtads-1.3a

CONFIG += qt thread

# Where to find the portable Tads sources.
#
T2DIR = tads2
T3DIR = tads3

# An empty BUILD variable implies a release-build.
#
isEmpty(BUILD) {
	BUILD = release
} else:!count(BUILD, 1) {
	error("Too many values for BUILD.")
}

# Determine which version of QTads to build; release or debug.
#
contains(BUILD, release) {
	CONFIG += release warn_off
	DEFINES += QT_NO_CHECK QT_NO_DEBUG RUNFAST
}
contains(BUILD, debug) {
	CONFIG += debug warn_on
	DEFINES += T3_DEBUG DEBUG
	message("** Debug-version.")
	message("** Optimization flags don't apply!")
	message("")
}
!contains(BUILD, release):!contains(BUILD, debug) {
	error(BUILD must be either "release" or "debug".)
}

# Detect which Qt library to use; default is the threaded version.
#
!exists($$(QTDIR)/lib/libqt-mt.*) {
	exists($$(QTDIR)/lib/libqt.*) {
		CONFIG -= thread
		message("Multi-threaded Qt library not found.")
		message("Will use the single-threaded version.")
		message("")
	} else {
		message("Qt library not found; compilation may fail!")
		message("Check your QTDIR environment variable!")
		message("")
	}
}

# Warn if no translation files for the Qt library can be found.
#
!exists($$(QTDIR)/translations/qt_*) {
	message("Unable to find the translation files for the Qt library.")
	message("Make sure that the QTDIR env. variable points to the")
	message("right directory and that the translation files reside")
	message("inside the translations/ subdirectory of the Qt")
	message("directory.")
	message("")
}

# If no install directories where specified, use the defaults.
#
isEmpty(DOC_INSTALL):DOC_INSTALL = /usr/local/share/doc
isEmpty(BIN_INSTALL):BIN_INSTALL = /usr/local/bin
isEmpty(DATA_INSTALL):DATA_INSTALL = /usr/local/share

# Translations of QTads itself.  Right now, I only translated it to
# German ("de").
#
# Note that English is always built-in; no translation file is needed.
#
TRANSLATIONS = qtads_de.ts

# Some macros to be defined at the compiler's command line.  They are
# needed by the portable Tads sources, except for `QT_CLEAN_NAMESPACE',
# which is needed by the Qt headers in order to avoid some
# identifier-clashes.
#
DEFINES += \
	TROLLTECH_QT \
	_M_IX86 \
	VMGLOB_VARS \
	\
	QT_CLEAN_NAMESPACE

# Directories used by qmake during the build process.
#
VPATH += forms src
INCLUDEPATH += forms src $${T2DIR} $${T3DIR}
DEPENDPATH += forms src $${T2DIR} $${T3DIR}
OBJECTS_DIR = obj
MOC_DIR = tmp
UI_DIR = tmp

# Which files make up the documentation for QTads (they will be
# installed when doing a "make install").
#
documentation.files = \
	AUTHORS \
	BUGS \
	COPYING \
	CREDITS \
	INSTALL \
	NEWS \
	README \
	SOURCE_README \
	TIPS \
	TODO

# These are the translation files for QTads in their compiled form.
# They will be installed with "make install".
#
i18n.files = qtads_de.qm

# The Tads 2 character mapping files.  They will be installed with
# "make install".
#
charmaps.files = charmaps/*.tcp

# Extra files to include in the distribution tarball ("make dist").  By
# default, only the used source files would get included.
#
DISTFILES += \
	$${T2DIR}/LICENSE.TXT \
	$${T2DIR}/tadsver.htm \
	$${T2DIR}/portnote.txt \
	$${T3DIR}/LICENSE.TXT \
	$${T3DIR}/README.TXT \
	$${T3DIR}/portnote.htm \
	$$documentation.files \
	$$i18n.files \
	$$charmaps.files

# Files to be processed by the user interface compiler (uic).
#
FORMS += \
	forms/confdialog.ui \
	forms/about.ui \
	forms/qtadsmainwindow.ui \
	forms/shortcuts.ui

# QTads headers.
#
HEADERS += \
	src/install_dirs.h \
	src/config.h \
	src/missing.h \
	src/qtadssettings.h \
	src/qtadsdialog.h \
	src/qtadstypes.h \
	src/qtadsstatusline.h \
	src/qtadsgamewindow.h \
	src/qtadsio.h \
	src/osqt.h \
	src/qtadsvmhostifc.h \
	src/qtadscvmmainclientconsole.h \
	src/qtadstimedisplay.h

# QTads sources.
#
SOURCES = \
	src/install_dirs.cc \
	src/oemqt.c \
	src/missing.cc \
	src/qtadssettings.cc \
	src/qtadsdialog.cc \
	src/qtadsstatusline.cc \
	src/qtadsgamewindow.cc \
	src/qtadsio.cc \
	src/osqt.cc \
	src/osqt3.cc \
	src/qtadsvmhostifc.cc \
	src/main.cc

# Portable Tads headers.  We simply include every header from the Tads
# directories.  It's sub-optimal, but the safest solution.

# Tads 2 headers.
#
HEADERS += $${T2DIR}/*.h

# Tads 3 headers.
#
HEADERS += $${T3DIR}/*.h

# Portable Tads sources.  Only sources needed by the runtime are
# included in the build.  Compiler and debugger sources are omitted.
# Unlike headers, we always know which are needed.

# Tads 2 sources.
#
SOURCES += \
	$${T2DIR}/argize.c \
	$${T2DIR}/ler.c \
	$${T2DIR}/mcm.c \
	$${T2DIR}/mcs.c \
	$${T2DIR}/mch.c \
	$${T2DIR}/obj.c \
	$${T2DIR}/cmd.c \
	$${T2DIR}/errmsg.c \
	$${T2DIR}/dummy.c \
	$${T2DIR}/fioxor.c \
	$${T2DIR}/oserr.c \
	$${T2DIR}/runstat.c \
	$${T2DIR}/fio.c \
	$${T2DIR}/getstr.c \
	$${T2DIR}/cmap.c \
	$${T2DIR}/askf_os.c \
	$${T2DIR}/indlg_os.c \
	$${T2DIR}/osifc.c \
	$${T2DIR}/dat.c \
	$${T2DIR}/lst.c \
	$${T2DIR}/run.c \
	$${T2DIR}/out.c \
	$${T2DIR}/voc.c \
	$${T2DIR}/bif.c \
	$${T2DIR}/suprun.c \
	$${T2DIR}/regex.c \
	$${T2DIR}/vocab.c \
	$${T2DIR}/execmd.c \
	$${T2DIR}/ply.c \
	$${T2DIR}/qas.c \
	$${T2DIR}/trd.c \
	$${T2DIR}/dbgtr.c \
	$${T2DIR}/linfdum.c \
	$${T2DIR}/osrestad.c \
	$${T2DIR}/bifgdum.c \
	$${T2DIR}/output.c

# Tads3 sources.
#
SOURCES += \
	$${T3DIR}/vmmain.cpp \
	$${T3DIR}/std.cpp \
	$${T3DIR}/charmap.cpp \
	$${T3DIR}/resload.cpp \
	$${T3DIR}/resldexe.cpp \
	$${T3DIR}/vminit.cpp \
	$${T3DIR}/vmini_nd.cpp \
	$${T3DIR}/vmconsol.cpp \
	$${T3DIR}/vmconnom.cpp \
	$${T3DIR}/vmconhmp.cpp \
	$${T3DIR}/vminitim.cpp \
	$${T3DIR}/vmcfgmem.cpp \
	$${T3DIR}/vmobj.cpp \
	$${T3DIR}/vmundo.cpp \
	$${T3DIR}/vmtobj.cpp \
	$${T3DIR}/vmpat.cpp \
	$${T3DIR}/vmstrcmp.cpp \
	$${T3DIR}/vmdict.cpp \
	$${T3DIR}/vmgram.cpp \
	$${T3DIR}/vmstr.cpp \
	$${T3DIR}/vmcoll.cpp \
	$${T3DIR}/vmiter.cpp \
	$${T3DIR}/vmlst.cpp \
	$${T3DIR}/vmsort.cpp \
	$${T3DIR}/vmsortv.cpp \
	$${T3DIR}/vmbignum.cpp \
	$${T3DIR}/vmvec.cpp \
	$${T3DIR}/vmintcls.cpp \
	$${T3DIR}/vmanonfn.cpp \
	$${T3DIR}/vmlookup.cpp \
	$${T3DIR}/vmbytarr.cpp \
	$${T3DIR}/vmcset.cpp \
	$${T3DIR}/vmfilobj.cpp \
	$${T3DIR}/vmstack.cpp \
	$${T3DIR}/vmerr.cpp \
	$${T3DIR}/vmerrmsg.cpp \
	$${T3DIR}/vmpool.cpp \
	$${T3DIR}/vmpoolim.cpp \
	$${T3DIR}/vmtype.cpp \
	$${T3DIR}/vmtypedh.cpp \
	$${T3DIR}/utf8.cpp \
	$${T3DIR}/vmglob.cpp \
	$${T3DIR}/vmrun.cpp \
	$${T3DIR}/vmfunc.cpp \
	$${T3DIR}/vmmeta.cpp \
	$${T3DIR}/vmsa.cpp \
	$${T3DIR}/vmbif.cpp \
	$${T3DIR}/vmbifl.cpp \
	$${T3DIR}/vmimage.cpp \
	$${T3DIR}/vmimg_nd.cpp \
	$${T3DIR}/vmrunsym.cpp \
	$${T3DIR}/vmsrcf.cpp \
	$${T3DIR}/vmfile.cpp \
	$${T3DIR}/vmbiftad.cpp \
	$${T3DIR}/vmbiftio.cpp \
	$${T3DIR}/askf_os3.cpp \
	$${T3DIR}/indlg_os3.cpp \
	$${T3DIR}/vmsave.cpp \
	$${T3DIR}/vmbift3.cpp \
	$${T3DIR}/vmbt3_nd.cpp \
	$${T3DIR}/vmosc.cpp \
	$${T3DIR}/vmregex.cpp \
	$${T3DIR}/vmhosttx.cpp \
	$${T3DIR}/vmhash.cpp \
	$${T3DIR}/vmmcreg.cpp \
	$${T3DIR}/vmbifreg.cpp \
	$${T3DIR}/vmcrc.cpp \
	$${T3DIR}/derived/vmuni_cs.cpp

# Set up the optimization switches for C++.
#
isEmpty(CXXFLAGS) {
	ENV_CXXFLAGS = $$(CXXFLAGS)
	!isEmpty(ENV_CXXFLAGS) {
		QMAKE_CXXFLAGS_RELEASE = $$(CXXFLAGS)
	}
} else {
	QMAKE_CXXFLAGS_RELEASE = $$CXXFLAGS
}

# Set up the optimization switches for C.
#
isEmpty(CFLAGS) {
	ENV_CFLAGS = $$(CFLAGS)
	!isEmpty(ENV_CFLAGS) {
		QMAKE_CFLAGS_RELEASE = $$(CFLAGS)
	}
} else {
	QMAKE_CFLAGS_RELEASE = $$CFLAGS
}

# Set up the installation paths.
#
documentation.path = $${DOC_INSTALL}/$${QTADSDOCDIR}
target.path = $${BIN_INSTALL}
i18n.path = $${DATA_INSTALL}/qtads/i18n
charmaps.path = $${DATA_INSTALL}/qtads/charmaps
INSTALLS += documentation target i18n charmaps

# Create header files that contain the installation directories.
#
unix:system(echo '"$$i18n.path"' > src/i18n_inst_dir.h)
unix:system(echo '"$$documentation.path"' > src/doc_inst_dir.h)
unix:system(echo '"$$charmaps.path"' > src/charmap_inst_dir.h)

# If not compiling the debug version, tell the user what optimization
# switches will be used.
#
!debug:message("C compiler optimization flags:")
!debug:message($$QMAKE_CFLAGS_RELEASE)
!debug:message("")
!debug:message("C++ compiler optimization flags:")
!debug:message($$QMAKE_CXXFLAGS_RELEASE)
!debug:message("")

# Tell the user where the various parts of the application will be
# installed.
#
message("The documentation will be installed in:")
message($$DOC_INSTALL)
message("")
message("The executable will be installed in:")
message($$BIN_INSTALL)
message("")
message("Additional data files will be installed in:")
message($$DATA_INSTALL)
message("")
message("You can change the compiler optimization flags as well")
message("as the installation directories by passing arguments")
message("to qmake. Refer to the INSTALL file on how to do this.")
