#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../music.h"
#include "../game_config.h"
#include "../fonts.h"
#include "../game_data.h"
#include "../race_opengl.h"
#include "menu_gfx.h"
#include "pause_menu.h"

PauseMenu::PauseMenu(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(0, 0, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		btn_back(    CL_Rect(400 - 160, 270, 400 + 160, 270 + 30), "Back To Game",   this, style ),
		btn_skip(    CL_Rect(400 - 160, 300, 400 + 160, 300 + 30), "Skip Track",     this, style ),
		btn_abandon( CL_Rect(400 - 160, 330, 400 + 160, 330 + 30), "Abandon Season", this, style )
{
	slots.connect( sig_paint(), this, &PauseMenu::on_paint );

	slots.connect( btn_back.sig_clicked(),    this, &PauseMenu::on_back );
	slots.connect( btn_skip.sig_clicked(),    this, &PauseMenu::on_skip );
	slots.connect( btn_abandon.sig_clicked(), this, &PauseMenu::on_abandon );
}

PauseMenu::~PauseMenu()
{
}

void PauseMenu::on_paint()
{
	MenuGfx::bg->put_screen(0,0);

	Music::update();
	Fonts::menu_small->print_right( 800-10, 600-25, "PAUSED" );
}

void PauseMenu::on_back()
{
	quit();
}

void PauseMenu::on_skip()
{
	GameData::cars_in_goal = Config::num_cars;
	quit();
}

void PauseMenu::on_abandon()
{
	Config::abandon_season = true;
	quit();
}
