#include "animation.h"
#include "allegro.h"
#include <vector>

Animation::Animation( int x, int y ):
posx( x ),
posy( y ) {
	current = pics.begin();
	sent = NULL;
}


void Animation::add( BITMAP * who ) {

	pics.push_back( who );
	current = pics.begin();
	if ( sent )
		destroy_bitmap( sent );
	sent = who;

}


BITMAP * Animation::show() {
	return sent;
}


void Animation::clear() {

	if ( sent ) destroy_bitmap( sent );
	sent = NULL;
	return;

	if ( pics.empty() ) return;

	for ( current = pics.begin(); current != pics.end(); ) {

		BITMAP * temp = *current;
		current = pics.erase( current );
		destroy_bitmap( temp );

	}
	current = pics.begin();

}


void Animation::Next( BITMAP * work ) {

	if ( sent != NULL )
		draw_sprite( work, sent, posx, posy );
	return;

	if ( pics.empty() ) return;
	if ( current == pics.end() ) current = pics.begin();
	draw_sprite( work, *current, posx, posy );
	current++;

}


void Animation::changePos( int x, int y ) {
	posx = x;
	posy = y;
}


Animation::~Animation() {

	if ( sent )
		destroy_bitmap( sent );
	return;
	for ( current = pics.begin(); current != pics.end(); ) {

		BITMAP * temp = *current;
		current = pics.erase( current );
		destroy_bitmap( temp );

	}

}
