#include "defs.h"
#include <stdlib.h>
#include <stdio.h>
#include "explode.h"
#include "allegro.h"
#include "rfont.h"
#include "explode.h"

#include "strings.h"
#include <string.h>

double tcos[360];
double tsine[360];
double rsine[360];
double ttan[360];

DATAFILE * global_data;
DATAFILE * global_snd;

RFont * raptor_font;

int screen_x = 640*3/2;
int screen_y = 480;

int * e_color;
float sound_vol;
float music_vol;

volatile int speed_counter = 0;

unsigned char getByte( unsigned char q, int byte ) {
	return ( q & ( 1 << byte ) ) >> byte;
}


void YIELD() {
	#ifdef UNIX
	struct timeval tv;
	tv.tv_sec = 0;
	tv.tv_usec = 1;
	select( 0, NULL, NULL, NULL, &tv );
	#else
	//sleep(1);
	yield_timeslice();
	#endif
}


unsigned char setByte( unsigned char n, int byte, unsigned char p ) {
	unsigned char final = 0;
	for ( int q = 15; q >= 0; q-- ) {
		unsigned char z = getByte( n, q );
		if ( q == byte )
			z = p;
		final = final << 1 | z;
	}
	return final;
}


void bitscramble( char & q ) {

	q = setByte( q, 5, getByte(q,5)^1 );
	q = setByte( q, 9, getByte(q,9)^1 );

}


void scramble( char * scram, const int m ) {

	for ( int q = 0; q < m && q+2 < m; q += 3 ) {
		char t = scram[q];
		scram[q] = scram[q+2];
		scram[q+2] = t;
	}
	for ( int q = 0; q < m; q++ )
		bitscramble( scram[q] );

}


int rnd( int q ) {

	/*
	#ifdef UNIX

	return random() % q;

	#else

	return (int)( q * ( (double)rand() / ( (double)RAND_MAX + 1.0 ) ) );
	#endif
	*/
	return (int)( q * ( (double)rand() / ( (double)RAND_MAX + 1.0 ) ) );

}


int addcol( int c1, int c2 ) {

	int r1, g1, b1;
	int r2, g2, b2;
	r1 = getr( c1 );
	g1 = getg( c1 );
	b1 = getb( c1 );

	r2 = getr( c2 );
	g2 = getg( c2 );
	b2 = getb( c2 );

	r1 += r2;
	g1 += g2;
	b1 += b2;
	if ( r1 > 255 ) r1 = 255;
	if ( g1 > 255 ) g1 = 255;
	if ( b1 > 255 ) b1 = 255;

	printf("C1 = %d. C2 = %d. New color = %d\n", c1, c2, makecol(r1,g1,b1) );

	return makecol(r1,g1,b1);

}


void blend_palette( int * pal, int mp, int sc, int ec ) {

	int sc_r = getr( sc );
	int sc_g = getg( sc );
	int sc_b = getb( sc );

	int ec_r = getr( ec );
	int ec_g = getg( ec );
	int ec_b = getb( ec );

	for ( int q = 0; q < mp; q++ ) {
		float j = (float)( q ) / (float)( mp );
		int f_r = (int)( 0.5 + (float)( sc_r ) + (float)( ec_r-sc_r ) * j );
		int f_g = (int)( 0.5 + (float)( sc_g ) + (float)( ec_g-sc_g ) * j );
		int f_b = (int)( 0.5 + (float)( sc_b ) + (float)( ec_b-sc_b ) * j );
		pal[q] = makecol( f_r, f_g, f_b );
	}

}						  // end blend_palette


int pcount( char ** p, const int m ) {

	int total = 0;
	for ( int q = 0; q < m; q++ )
		if ( p[q] != NULL )
			total++;
	return total;
}


int readnum( FILE * fv, int num ) {

	int final = 0;
	//char temp;
	char * buf = new char[ num ];

	fread( buf, sizeof( char ), num, fv );
	for ( int q = num-1; q >= 0; q-- )
		final = final | buf[q];
	delete[] buf;
	return final;

}


void explColor() {

	e_color = new int[ MAX_E_COLOR ];
	blend_palette( e_color, 60, makecol(0,0,0), makecol(240,100,0) );
	blend_palette( e_color+60, 20, makecol(240,100,0), makecol(240,220,0) );
	blend_palette( e_color+60+20, 20, makecol(240,220,0), makecol(254,254,254) );

}


char * data_file( char * file_name ) {

	//char * file_place = new char[ 6 ];
	char file_place[ 30 ];
	//file_place = strdup( "data" );
	sprintf( file_place, "data" );
	put_backslash( file_place );
	char * final = append( file_place, file_name );
	//delete[] file_place;
	return final;

}


void MakeExplosion( ExplosionClass ** expl, int M_EX, int x, int y ) {
	/*
	int q = 0;
	while ( q < M_EX && expl[q] != NULL )
		q++;
	if ( q >= M_EX )
		return;
	*/
	double a = (double)( rnd( 45 ) + 15 ) / -10.0;
	ExplosionClass * w_expl = new ExplosionClass(x,y,0,a,rnd(6)+3);
	addExplode( expl, M_EX, w_expl );
	//expl[q] = new ExplosionClass( x, y, 0, a, rnd( 6 ) + 3 );
}


/*
void MakeSlimExplosion( ExplosionClass ** expl, int M_EX, int x, int y ){

	int q = 0;
	while ( q < M_EX && expl[q] != NULL )
		q++;
	if ( q >= M_EX )
		return;
	//double a = (double)( rnd( 45 ) + 15 ) / -10.0;
	expl[q] = new ExplosionSlim( x, y );

}
*/

void draw_mask( BITMAP * dest, BITMAP * source, int _x, int _y ){
	int mask = makecol(255,0,255);
	for ( int x = 0; x < source->w; x++ )
		for ( int y = 0; y < source->h; y++ )
			if ( getpixel( source,x,y ) == mask )
				putpixel( dest, x+_x, y+_y, mask );
}

void play_sound( DATAFILE * snd, int m, int vol ) {
	play_sample( (SAMPLE *)snd[m].dat, (int)(vol*sound_vol), 128, 1000, false );
}


void play_sound( SAMPLE * snd, int vol ) {
	play_sample( snd, (int)(vol*sound_vol), 128, 1000, false );
}
