#include "hull.h"
#include "hull_animation.h"
#include "allegro.h"
#include "defs.h"

HullAnimation::HullAnimation( BITMAP ** animations, int _max_animation, BITMAP ** shadows, int _life, int _strength, int num_guns, int level, int _drawing_plane, bool _trans, ECollide * ec ):
HullObject( NULL, _life, _strength, num_guns, level, _drawing_plane, _trans, ec ) {

	pics = animations;
	max_animation = _max_animation;
	animation = 0;

	own_shadow = false;
	if ( shadows == NULL ){
		pics_shadow = new BITMAP*[ max_animation ];
		for ( int q = 0; q < max_animation; q++ ){
			pics_shadow[q] = create_bitmap( pics[q]->w, pics[q]->h );
			int m = 22;
			clear_to_color( pics_shadow[q], makecol(m,m,m) );
			draw_mask( pics_shadow[q], pics[q], 0, 0 );
		}
		own_shadow = true;
	} else pics_shadow = shadows;

}

BITMAP * HullAnimation::getShadow(){
	return pics_shadow[ animation ];
}

void HullAnimation::Draw( BITMAP * who, int x, int y ) {
	
	Bitmap = pics[ animation ];
	HullObject::Draw( who, x, y );
	
	if ( ++animation >= max_animation ) animation = 0;

}


/*
void HullAnimation::Shadow( BITMAP * who, int x, int y ) {
	Bitmap = pics[ animation ];
	HullObject::Shadow( who, x, y );
}
*/


HullAnimation::~HullAnimation() {
	delete[] pics;
	if ( own_shadow ){
		for ( int q = 0; q < max_animation; q++ )
			destroy_bitmap( pics_shadow[q] );
		delete[] pics_shadow;
	}
	Shadow_Bitmap = NULL;
}
