// 
// $Id: qaregexp.hpp,v 1.9 2000/06/12 10:54:18 amos Exp $
//
// Definition of QaRegExp class
//
// Jan Borsodi <amos@abn.hibu.no>
// Created on: <14-Jul-1999 19:14:57 amos>
//

#ifndef QAREGEXP_HPP
#define QAREGEXP_HPP

#include "qaregexpmatch.hpp"
#include <qstring.h>
#include <qstringlist.h>
#include <regex.h>

class QaRegExp
{
public:
    QaRegExp( const QString &r, bool c = true, bool newline = true );
    QaRegExp( const QaRegExp &r );
    virtual ~QaRegExp();

    bool caseSensitive() const;
    bool handleNewline() const;

    void setCaseSensitive( bool s );
    void setHandleNewline( bool h );

    bool match( const QString &s, int sub = 0 );
    int matchMultiple( const QString &s, int sub = 0 );
    QString matchString( int sub = 0 );
    QStringList matchStrings();
    int matchBeginning( int sub = 0 ) const;
    int matchEnd( int sub = 0 ) const;
    const QaRegExpMatch &matches() const;
    int split( const QString &s );
    int subCount() const;
    void setExpression( const QString &r );

    QaRegExp &operator =( const QaRegExp &r );

private:
    void compileRegExp();
    void setSubReg( bool b );

private:
    QString RegString;
    QString String;
    int Flags;
    bool Case;
    bool NewLine;
    bool Subs;
    bool Alloced;
    regex_t RegComp;
    int NumSub;
    QaRegExpMatch Matches;
};


#endif // QAREGEXP_HPP
