/* common.h - Common definitions.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __COMMON_H__
#define __COMMON_H__

#ifndef MIN
#define MIN(a,b)	( ((a)<(b)) ? (a):(b) )
#endif

#ifndef MAX
#define MAX(a,b)	( ((a)>(b)) ? (a):(b) )
#endif

#define SWAP(a,b)	({ typeof(a) t = a; a = b; b = t; })

#ifndef min
#define min(a,b)	({ typeof(a) c = a; typeof(b) d = b; MIN(c,d); })
#endif

#ifndef max
#define max(a,b)	({ typeof(a) c = a; typeof(b) d = b; MAX(c,d); })
#endif

#define RETURN_IF_DIFFERENT(i1,i2) \
	{ \
		typeof(i1) a = i1; \
		typeof(i2) b = i2; \
		if (a != b) \
			return a-b; \
	}

#endif
