# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Dir", "Object", "class")
aClass.addFragment(Paragraph.new("Objects of class <code>Dir</code> are directory streams representing directories in the underlying file system. They provide a variety of ways to list directories and their contents. See also <code>File</code>, page 305.\n"))
aClass.addFragment(Paragraph.new("The directory used in these examples contains the two regular files (<code>config.h</code> and <code>main.rb</code>), the parent directory (<code>..</code>), and the directory itself (<code>.</code>).\n"))
m0002 = MethodDesc.new("[]", "class", "Dir[ <i>aString</i> ] -> <i>anArray</i>")
m0002.addFragment(Paragraph.new("Returns <i>anArray</i> of filenames found by expanding the pattern given in <i>aString</i>. Note that this pattern is not a regexp (it's closer to a shell glob) and may contain the following metacharacters:\n"))
m0002.addFragment(Verbatim.new("Dir[\"config.?\"]       \#=> [\"config.h\"]\nDir[\"*.[a-z][a-z]\"]   \#=> [\"main.rb\"]\nDir[\"*.[^r]*\"]        \#=> [\"config.h\"]\nDir[\"*.{rb,h}\"]       \#=> [\"main.rb\", \"config.h\"]\nDir[\"*\"]              \#=> [\"config.h\", \"main.rb\"]\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("chdir", "class", "Dir.chdir( <i>[</i> <i>aString</i><i>]</i> ) -> 0")
m0003.addFragment(Paragraph.new("Changes the current working directory of the process to the given string. When called without an argument, changes the directory to the value of the environment variable <code>HOME</code>, or <code>LOGDIR</code>. Raises a <code>SystemCallError</code> (probably <code>Errno::ENOENT</code>) if the target directory does not exist.\n"))
m0003.addFragment(Verbatim.new("Dir.chdir(\"/var/spool/mail\")   \#=> 0\nDir.pwd                        \#=> \"/var/spool/mail\"\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("chroot", "class", "Dir.chroot( <i>aString</i> ) -> 0")
m0004.addFragment(Paragraph.new("Changes this process's idea of the file system root. Only a privileged process may make this call. Not available on all platforms. On Unix systems, see <code>chroot(2)</code> for more information.\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("delete", "class", "Dir.delete( <i>aString</i> ) -> 0")
m0005.addFragment(Paragraph.new("Deletes the named directory. Raises a subclass of <code>SystemCallError</code> if the directory isn't empty.\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("entries", "class", "Dir.entries( <i>aString</i> ) -> <i>anArray</i>")
m0006.addFragment(Paragraph.new("Returns an array containing all of the filenames in the given directory. Will raise a <code>SystemCallError</code> if the named directory doesn't exist.\n"))
m0006.addFragment(Verbatim.new("Dir.entries(\"testdir\")   \#=> [\".\", \"..\", \"config.h\", \"main.rb\"]\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("foreach", "class", "Dir.foreach( <i>aString</i> ) {| filename | block } <p></p> -> <code>nil</code>")
m0007.addFragment(Paragraph.new("Calls the block once for each entry in the named directory, passing the filename of each entry as a parameter to the block.\n"))
m0007.addFragment(Verbatim.new("Dir.foreach(\"testdir\") {|x| puts(\"Got \" + x) }"))
m0007.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0007.addFragment(Verbatim.new("Got .\nGot ..\nGot config.h\nGot main.rb"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("getwd", "class", "Dir.getwd -> <i>aString</i>")
m0008.addFragment(Paragraph.new("Returns the path to the current working directory of this process as a string.\n"))
m0008.addFragment(Verbatim.new("Dir.chdir(\"/tmp\")   \#=> 0\nDir.getwd           \#=> \"/tmp\"\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("glob", "class", "Dir.glob( <i>aString</i> ) -> <i>anArray</i>")
m0009.addFragment(Paragraph.new("Synonym for <code>Dir::[]</code>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("mkdir", "class", "Dir.mkdir( <i>aString</i> <i>[</i>, <i>anInteger</i><i>]</i> ) -> 0")
m0010.addFragment(Paragraph.new("Makes a new directory named by <i>aString</i>, with permissions specified by the optional parameter <i>anInteger</i>. The permissions may be modified by the value of <code>File::umask</code>, and are ignored on NT. Raises a <code>SystemCallError</code> if the directory cannot be created. See also the discussion of permissions on page 305.\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("new", "class", "Dir.new( <i>aString</i> ) -> <i>aDir</i>")
m0011.addFragment(Paragraph.new("Returns a new directory object for the named directory.\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("open", "class", "Dir.open( <i>aString</i> ) -> <i>aDir</i><br></br>Dir.open( <i>aString</i> ) {| aDir | block } -> <code>nil</code>")
m0012.addFragment(Paragraph.new("With no block, <code>open</code> is a synonym for <code>Dir::new</code>. If a block is present, it is passed <i>aDir</i> as a parameter. The directory is closed at the end of the block, and <code>Dir::open</code> returns <code>nil</code>.\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("pwd", "class", "Dir.pwd -> <i>aString</i>")
m0013.addFragment(Paragraph.new("Synonym for <code>Dir::getwd</code>.\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("rmdir", "class", "Dir.rmdir( <i>aString</i> ) -> <code>true</code>")
m0014.addFragment(Paragraph.new("Synonym for <code>Dir::delete</code>.\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("unlink", "class", "Dir.unlink( <i>aString</i> ) -> <code>true</code>")
m0015.addFragment(Paragraph.new("Synonym for <code>Dir::delete</code>.\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("close", "instance", "<em>dir</em>.close -> <code>nil</code>")
m0016.addFragment(Paragraph.new("Closes the directory stream. Any further attempts to access <em>dir</em> will raise an <code>IOError</code>.\n"))
m0016.addFragment(Verbatim.new("d = Dir.new(\"testdir\")\nd.close   \#=> nil\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("each", "instance", "<em>dir</em>.each {| | block } <p></p> -> <em>dir</em>")
m0017.addFragment(Paragraph.new("Calls the block once for each entry in this directory, passing the filename of each entry as a parameter to the block.\n"))
m0017.addFragment(Verbatim.new("d = Dir.new(\"testdir\")\nd.each  {|x| puts (\"Got \" + x) }"))
m0017.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0017.addFragment(Verbatim.new("Got .\nGot ..\nGot config.h\nGot main.rb"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("read", "instance", "<em>dir</em>.read -> <i>aString</i> or <code>nil</code>")
m0018.addFragment(Paragraph.new("Reads the next entry from <em>dir</em> and returns it as a string. Returns <code>nil</code> at the end of the stream.\n"))
m0018.addFragment(Verbatim.new("d = Dir.new(\"testdir\")\nd.read   \#=> \".\"\nd.read   \#=> \"..\"\nd.read   \#=> \"config.h\"\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("rewind", "instance", "<em>dir</em>.rewind -> <em>dir</em>")
m0019.addFragment(Paragraph.new("Repositions <em>dir</em> to the first entry.\n"))
m0019.addFragment(Verbatim.new("d = Dir.new(\"testdir\")\nd.read     \#=> \".\"\nd.rewind   \#=> \#<Dir:0x4018d784>\nd.read     \#=> \".\"\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("seek", "instance", "<em>dir</em>.seek( <i>anInteger</i> ) -> <em>dir</em>")
m0020.addFragment(Paragraph.new("Seeks to a particular location in <em>dir</em>. <i>anInteger</i> must be a value returned by <code>Dir\#tell</code>.\n"))
m0020.addFragment(Verbatim.new("d = Dir.new(\"testdir\")\nd.read      \#=> \".\"\ni = d.tell\nd.read      \#=> \"..\"\nd.seek(i)   \#=> \#<Dir:0x4018d5b8>\nd.read      \#=> \"..\"\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("tell", "instance", "<em>dir</em>.tell -> <i>anInteger</i>")
m0021.addFragment(Paragraph.new("Returns the current position in <em>dir</em>. See also <code>Dir\#seek</code>.\n"))
m0021.addFragment(Verbatim.new("d = Dir.new(\"testdir\")\nd.tell   \#=> 0\nd.read   \#=> \".\"\nd.tell   \#=> 12\n"))
aClass.addMethod(m0021)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
