# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("FileTest", "", "module")
aClass.addFragment(Paragraph.new("<code>FileTest</code> implements file test operations similar to those used in <code>File::Stat</code>.\n"))
m0002 = MethodDesc.new("blockdev?", "instance", "FileTest.blockdev?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0002.addFragment(Paragraph.new("Returns <code>true</code> if the named file is a block device, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0002.addFragment(Verbatim.new("FileTest.blockdev?( \"testfile\" )   \#=> false\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("chardev?", "instance", "FileTest.chardev?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0003.addFragment(Paragraph.new("Returns <code>true</code> if the named file is a character device, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0003.addFragment(Verbatim.new("FileTest.chardev?( \"/dev/tty\" )   \#=> true\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("directory?", "instance", "FileTest.directory?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0004.addFragment(Paragraph.new("Returns <code>true</code> if this named file is a directory, <code>false</code> otherwise.\n"))
m0004.addFragment(Verbatim.new("FileTest.directory?( \".\" )   \#=> true\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("executable?", "instance", "FileTest.executable?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0005.addFragment(Paragraph.new("Returns <code>true</code> if the named file is executable. The tests are made using the effective owner of the process.\n"))
m0005.addFragment(Verbatim.new("FileTest.executable?( \"testfile\" )   \#=> false\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("executable_real?", "instance", "FileTest.executable_real?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0006.addFragment(Paragraph.new("Same as <code>FileTest\#executable?</code>, but tests using the real owner of the process.\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("exist?", "instance", "FileTest.exist? ( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0007.addFragment(Paragraph.new("Returns <code>true</code> if the named file exists.\n"))
m0007.addFragment(Verbatim.new("FileTest.exist?( \"testfile\" )   \#=> true\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("exists?", "instance", "FileTest.exists? ( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0008.addFragment(Paragraph.new("Synonym for <code>FileTest::exist?</code>.\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("file?", "instance", "FileTest.file?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0009.addFragment(Paragraph.new("Returns <code>true</code> if the named file is a regular file (not a device file, pipe, socket, etc.).\n"))
m0009.addFragment(Verbatim.new("FileTest.file?( \"testfile\" )   \#=> true\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("grpowned?", "instance", "FileTest.grpowned?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0010.addFragment(Paragraph.new("Returns <code>true</code> if the effective group id of the process is the same as the group id of the named file. On Windows NT, returns <code>false</code>.\n"))
m0010.addFragment(Verbatim.new("FileTest.grpowned?( \"/etc/passwd\" )   \#=> false\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("owned?", "instance", "FileTest.owned?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0011.addFragment(Paragraph.new("Returns <code>true</code> if the effective user id of the process is the same as the owner of the named file.\n"))
m0011.addFragment(Verbatim.new("FileTest.owned?( \"/etc/passwd\" )   \#=> false\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("pipe?", "instance", "FileTest.pipe?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0012.addFragment(Paragraph.new("Returns <code>true</code> if the operating system supports pipes and the named file is a pipe, <code>false</code> otherwise.\n"))
m0012.addFragment(Verbatim.new("FileTest.pipe?( \"testfile\" )   \#=> false\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("readable?", "instance", "FileTest.readable?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0013.addFragment(Paragraph.new("Returns <code>true</code> if the named file is readable by the effective user id of this process.\n"))
m0013.addFragment(Verbatim.new("FileTest.readable?( \"testfile\" )   \#=> true\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("readable_real?", "instance", "FileTest.readable_real?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0014.addFragment(Paragraph.new("Returns <code>true</code> if the named file is readable by the real user id of this process.\n"))
m0014.addFragment(Verbatim.new("FileTest.readable_real?( \"testfile\" )   \#=> true\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("setgid?", "instance", "FileTest.setgid?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0015.addFragment(Paragraph.new("Returns <code>true</code> if the named file's set-group-id permission bit is set, and <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0015.addFragment(Verbatim.new("FileTest.setgid?( \"/usr/sbin/lpc\" )   \#=> true\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("setuid?", "instance", "FileTest.setuid?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0016.addFragment(Paragraph.new("Returns <code>true</code> if the named file's set-user-id permission bit is set, and <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0016.addFragment(Verbatim.new("FileTest.setuid?( \"/bin/su\" )   \#=> true\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("size", "instance", "FileTest.size( <i>aString</i> ) -> <i>anInteger</i>")
m0017.addFragment(Paragraph.new("Returns the size of the named file in bytes.\n"))
m0017.addFragment(Verbatim.new("FileTest.size( \"testfile\" )   \#=> 66\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("size?", "instance", "FileTest.size?( <i>aString</i> ) -> <i>aFixnum</i> or <code>nil</code>")
m0018.addFragment(Paragraph.new("Returns <code>nil</code> if the named file is of zero length; otherwise, returns a nonzero <i>aFixnum</i>.\n"))
m0018.addFragment(Verbatim.new("FileTest.size?( \"testfile\" )    \#=> 66\nFileTest.size?( \"/dev/zero\" )   \#=> nil\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("socket?", "instance", "FileTest.socket?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0019.addFragment(Paragraph.new("Returns <code>true</code> if the named file is a socket, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("sticky?", "instance", "FileTest.sticky?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0020.addFragment(Paragraph.new("Returns <code>true</code> if the named file has its sticky bit set, <code>false</code> if it doesn't or if the operating system doesn't support this feature.\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("symlink?", "instance", "FileTest.symlink?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0021.addFragment(Paragraph.new("Returns <code>true</code> if the named file is a symbolic link, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("writable?", "instance", "FileTest.writable?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0022.addFragment(Paragraph.new("Returns <code>true</code> if the named file is writable by the effective user id of this process.\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("writable_real?", "instance", "FileTest.writable_real?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0023.addFragment(Paragraph.new("Returns <code>true</code> if the named file is writable by the real user id of this process.\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("zero?", "instance", "FileTest.zero?( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0024.addFragment(Paragraph.new("Returns <code>true</code> if the named file is of zero length, <code>false</code> otherwise.\n"))
aClass.addMethod(m0024)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
