/*
 *  name-dialog.c        -
 *
 *  Created: 20011222
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: name-dialog.c,v 1.35 2002/03/19 23:07:54 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <name-dialog.h>

#include <intl.h>
#include <common.h>

/* Funkcja obsugujca wcinicie przycisku "OK" okienka dialogowego. */
static void ok_button_clicked(GtkButton *button, contact_data *data)
{
    gpointer entry;
    gboolean modified = FALSE;
    gchar *text;

    g_assert(data != NULL);

    /* Przepisywanie danych z elementw okna dialogowego do struktury danych kontaktu i
       sprawdzanie czy dane zostay zmodyfikowane, a jeeli tak - ustawianie flagi modified. */
    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "prefix_name");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->prefix_name) != 0)
    {
        strcpy(data->prefix_name, text);
	modified = TRUE;
    }
       
    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "first_name");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->first_name) != 0)
    {
        strcpy(data->first_name, text);
	modified = TRUE;
    }

    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "middle_name");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->middle_name) != 0)
    {
        strcpy(data->middle_name, text);
	modified = TRUE;
    }

    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "last_name");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->last_name) != 0)
    {
        strcpy(data->last_name, text);
	modified = TRUE;
    }

    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "sufix_name");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->sufix_name) != 0)
    {
        strcpy(data->sufix_name, text);
	modified = TRUE;
    }

    /* Zamyka okienko dialogowe. */
    gtk_widget_destroy(data->sub_dialog);
    data->sub_dialog = NULL;

    if (modified)
    {
        /* Przepisanie penego imienia i nazwiska do pola edycji imienia i nazwiska okienka
	   kontaktw. */
        create_full_name(data);
    
        /* Utworzenie nowej listy wyboru w polu "Zapisz jako". */
        create_save_as_list(data);

        /* Przepisywanie flagi modified do flagi modified struktury danych kontaktu, jeeli
	   ta nie jest jeszcze ustawiona. */
        data->modified = TRUE;
	data->global_modified = TRUE;
    }
}

/* Funkcja tworzca okno dialogowe edycji imienia i nazwiska.

   Struktura okna:
   
     GtkDialog (name_dialog)
      +- GtkVBox (dialog_vbox)
      |   +- GtkFrame (frame)                                    "Szczegy"
      |       +- GtkFixed (fixed)
      |           +- GtkLabel
      |           +- GtkCombo                                       "Prefix"
      |           |   +- GtkEntry ("prefix_name")
      |           +- GtkLabel
      |           +- GtkEntry ("first_name")                          "Imi"
      |           +- GtkLabel
      |           +- GtkEntry ("middle_name")                  "Drugie imi"
      |           +- GtkLabel
      |           +- GtkEntry ("last_name")                       "Nazwisko"
      |           +- GtkLabel
      |           +- GtkCombo                                        "Sufix"
      |               +- GtkEntry ("sufix_name")
      +- GtkHBox (dialog_action_area)
          +- GtkHButtonBox (hbuttonbox)
	      +- GtkButton                                              "OK"
	      +- GtkButton                                          "Anuluj"

   Klucze zwizane z okienkiem edycji imienia i nazwiska:
   
     prefix_name - wskanik do pola edycji pola wyboru "Prefiks"
     first_name  - wskanik do pola edycji "Imi"
     middle_name - wskanik do pola edycji "Drugie imi"
     last_name   - wskanik do pola edycji "Nazwisko"
     sufix_name  - wskanik do pola edycji pola wyboru "Sufiks"

*/
void create_name_dialog(contact_data *data)
{
    GtkWidget *name_dialog;
    GtkWidget *dialog_vbox;
    GtkWidget *frame;
    GtkWidget *fixed;
    GtkWidget *label;
    GtkWidget *combo;
    GtkWidget *entry;
    GtkWidget *dialog_action_area;
    GtkWidget *hbuttonbox;
    GtkWidget *button;
    
    GList *combo_items = NULL;
    
    /* Utworzenie okienka dialogowego. */
    name_dialog = gtk_dialog_new();
    data->sub_dialog = name_dialog;

    /* Przypisanie funkcji obsugi sygnaw do okienka dialogowego. */
    gtk_signal_connect(GTK_OBJECT(name_dialog), "delete_event",
                       GTK_SIGNAL_FUNC(dialog_delete), name_dialog);
    gtk_signal_connect(GTK_OBJECT(name_dialog), "key_press_event",
                       GTK_SIGNAL_FUNC(dialog_key_press), name_dialog);
    
    /* Ustalenie tytuu i rozmiarw okna. */
    gtk_window_set_title(GTK_WINDOW(name_dialog), _("Full Name"));
    gtk_widget_set_usize(GTK_WIDGET(name_dialog), 282, 256);
    
        /* Obszar wntrza okna dialogowego. */
	dialog_vbox = GTK_DIALOG(name_dialog)->vbox;
	gtk_widget_show(dialog_vbox);
	
	    /* Ramka "Szczegy". */
	    frame = gtk_frame_new(_("Details"));
	    gtk_widget_show(frame);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_vbox), frame, TRUE, TRUE, 0);
	
	    gtk_container_set_border_width(GTK_CONTAINER(frame), 6);
	    gtk_frame_set_label_align(GTK_FRAME(frame), 0.05, 0.5);
	    
	        /* Wntrze ramki. */
		fixed = gtk_fixed_new();
		gtk_widget_show(fixed);
		
	        gtk_container_add(GTK_CONTAINER(frame), fixed);
		
		/* Etykieta "Prefix". */
		label = gtk_label_new(_("Prefix:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 8, 8);
		gtk_widget_set_uposition(label, 8, 8);
		gtk_widget_set_usize(label, 80, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Pole wyboru "Prefix". */
		combo = gtk_combo_new();
		gtk_widget_show(combo);
		
		gtk_fixed_put(GTK_FIXED(fixed), combo, 96, 8);
		gtk_widget_set_uposition(combo, 96, 8);
		gtk_widget_set_usize(combo, 96, 24);
		gtk_combo_set_value_in_list(GTK_COMBO(combo), TRUE, TRUE);
		
		    /* Ustalenie listy pola wyboru. */
		    combo_items = g_list_append(combo_items, (gpointer)"");
		    combo_items = g_list_append(combo_items, (gpointer)_("Mr"));
		    combo_items = g_list_append(combo_items, (gpointer)_("Mrs"));
		    combo_items = g_list_append(combo_items, (gpointer)_("dr"));
		    
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), combo_items);
		
		    g_list_free(combo_items);
		
		    /* Pole edycji pola wyboru "Prefix:". */
		    entry = GTK_COMBO(combo)->entry;
		    gtk_widget_show(entry);
		    
		    gtk_object_set_data(GTK_OBJECT(name_dialog), "prefix_name", entry);
		    
		    gtk_entry_set_max_length(GTK_ENTRY(entry), MAX_PREFIX_NAME);
		    gtk_entry_set_text(GTK_ENTRY(entry), data->prefix_name);
		    
		/* Etykieta "Imi:". */
		label = gtk_label_new(_("First:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 8, 40);
		gtk_widget_set_uposition(label, 8, 40);
		gtk_widget_set_usize(label, 80, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Pole edycji "Imi:". */
		entry = gtk_entry_new_with_max_length(MAX_FIRST_NAME);
		gtk_widget_show(entry);
		
		gtk_object_set_data(GTK_OBJECT(name_dialog), "first_name", entry);
		
		gtk_fixed_put(GTK_FIXED(fixed), entry, 96, 40);
		gtk_widget_set_uposition(entry, 96, 40);
		gtk_widget_set_usize(entry, 160, 24);
		gtk_entry_set_text(GTK_ENTRY(entry),data->first_name);
		gtk_widget_grab_focus(entry);
		
		/* Etykieta "Drugie imi". */
		label = gtk_label_new(_("Middle:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 8, 72);
		gtk_widget_set_uposition(label, 8, 72);
		gtk_widget_set_usize(label, 80, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Pole edycji "Drugie imi." */
		entry = gtk_entry_new_with_max_length(MAX_MIDDLE_NAME);
		gtk_widget_show(entry);
		
		gtk_object_set_data(GTK_OBJECT(name_dialog), "middle_name", entry);
		
		gtk_fixed_put(GTK_FIXED(fixed), entry, 96, 72);
		gtk_widget_set_uposition(entry, 96, 72);
		gtk_widget_set_usize(entry, 160, 24);
		gtk_entry_set_text(GTK_ENTRY(entry), data->middle_name);
		
		/* Etykieta "Nazwisko:". */
		label = gtk_label_new(_("Last:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 8, 104);
		gtk_widget_set_uposition(label, 8, 104);
		gtk_widget_set_usize(label, 80, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Pole edycji "Nazwisko:". */
		entry = gtk_entry_new_with_max_length(MAX_LAST_NAME);
		gtk_widget_show(entry);
		
		gtk_object_set_data(GTK_OBJECT(name_dialog), "last_name", entry);
		
		gtk_fixed_put(GTK_FIXED(fixed), entry, 96, 104);
		gtk_widget_set_uposition(entry, 96, 104);
		gtk_widget_set_usize(entry, 160, 24);
		gtk_entry_set_text(GTK_ENTRY(entry), data->last_name);
		
		/* Etykieta "Sufix:". */
		label = gtk_label_new(_("Sufix:"));
		gtk_widget_show(label);
		
		gtk_fixed_put(GTK_FIXED(fixed), label, 8, 136);
		gtk_widget_set_uposition(label, 8, 136);
		gtk_widget_set_usize(label, 80, 24);
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		
		/* Pole wyboru "Sufix:". */
		combo = gtk_combo_new();
		gtk_widget_show(combo);
		
		gtk_fixed_put(GTK_FIXED(fixed), combo, 96, 136);
		gtk_widget_set_uposition(combo, 96, 136);
		gtk_widget_set_usize(combo, 72, 24);
		gtk_combo_set_value_in_list(GTK_COMBO(combo), TRUE, TRUE);
		
		    /* Ustalenie listy pola wyboru. */
		    combo_items = NULL;
		    combo_items = g_list_append(combo_items, (gpointer)"");
		    combo_items = g_list_append(combo_items, (gpointer)"I");
		    combo_items = g_list_append(combo_items, (gpointer)"II");
		    combo_items = g_list_append(combo_items, (gpointer)"III");
		    combo_items = g_list_append(combo_items, (gpointer)_("jr"));
		    combo_items = g_list_append(combo_items, (gpointer)_("sr"));
		    
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), combo_items);
		
		    g_list_free(combo_items);
		
		    /* Pole edycji pola wyboru "Sufix:". */
		    entry = GTK_COMBO(combo)->entry;
		    gtk_widget_show(entry);
		    
		    gtk_object_set_data(GTK_OBJECT(name_dialog), "sufix_name", entry);
		    
		    gtk_entry_set_max_length(GTK_ENTRY(entry), MAX_SUFIX_NAME);
		    gtk_entry_set_text(GTK_ENTRY(entry), data->sufix_name);
		
        /* Obszar przyciskw okienka dialogowego. */
	dialog_action_area = GTK_DIALOG(name_dialog)->action_area;
	gtk_widget_show(dialog_action_area);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area), 10);
	
	    /* Listwa przyciskw. */
	    hbuttonbox = gtk_hbutton_box_new();
	    gtk_widget_show(hbuttonbox);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_action_area), hbuttonbox, TRUE, TRUE, 0);
			       
	    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
	    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 10);
	    
	        /* Przycisk "OK". */
		button = gtk_button_new_with_label(_("OK"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(ok_button_clicked), data);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		
		/* Przycisk "Anuluj". */
		button = gtk_button_new_with_label(_("Cancel"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(dialog_delete), name_dialog);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    
    /* Wywietlenie okienka dialogowego. */
    gtk_widget_show(name_dialog);
    
    /* Ustalenie modalnoci okienka. */
    gtk_window_set_modal(GTK_WINDOW(name_dialog), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(name_dialog), GTK_WINDOW(data->contact_window));
}
