/*
 * robstreamif.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file 
  * Implements the RoboTour Stream Interface, which can be used to 
  * control RoboTour from programs written in other programming languages
  * (like Java or Delphi).
  */

#ifndef __RT_STREAMIF__
#define __RT_STREAMIF__

#include "robfrontend.h"
#include "robbase.h"
#include "robmanage.h"

#include <rtstring.h>
#include <rtcollect.h>

namespace rt{

enum StreamifMode {
	sifModeOld,
	sifModeRT3
};

enum StreamifDispType {
	sifDispNone = 0,
	sifDispRunningBankOwner,
	sifDispGeneration,
	sifDispNumBanks,
	sifDispRunningBank
};

// simple array for command listings
struct SifSimpleStringArray {
	int length;
	char* strs[20];
};

// fwd declare
class StreamSimSupervisor;
class StreamTourDisplayer;

class StreamInterface : public FrontendPlugin  
{
public:
	StreamInterface(Frontend* parent);
	virtual ~StreamInterface();

	virtual FpInterpretePos getInterpretePos();
	virtual String getName();
	virtual String getHelpText();
	virtual bool interpreteParams(const Array<String>& params, Array<bool>& used);
	virtual void fillOptions(SimOptions& options);

	// reads a command or parameter
	String read();
	// writes a result or status message
	void write(const String&);
	// writes a simple array
	void writeArray(SifSimpleStringArray*);

private:
	Array<String>* curLine;
	int curPos;
	StreamifMode mode;
	Frontend::FightType fightType;
	Vector<int> curBotNums;

	static SifSimpleStringArray setupCommands;
	static SifSimpleStringArray ttypeOptions;
	static SifSimpleStringArray modeOptions;

	friend class StreamSimSupervisor;
	friend class StreamTourDisplayer;
};

class StreamSimSupervisor : public SimSupervisor {

public:
	StreamSimSupervisor(StreamInterface* parent);
	virtual ~StreamSimSupervisor();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);
	virtual void exitSim(Simulation* const sim, const GameState& simResult);

private:
	StreamInterface* parent;
	StreamifDispType dispType;
	unsigned long step;
	SimSupervisor::GameState retState;

	static SifSimpleStringArray runCommands;
	static SifSimpleStringArray displayOptions;
};

class StreamTourDisplayer : public TourDisplayer {

public:
	StreamTourDisplayer(StreamInterface* parent);
	virtual ~StreamTourDisplayer();

	virtual void init(const TourInitInfo&);
	virtual TourStatusType update(const Array<TourResult>& status);
	virtual void exit(TourStatusType exitType, const Array<TourResult>& result);

private:
	StreamInterface* parent;
};

class StreamErrorHandler : public ErrorHandler {
public:
	StreamErrorHandler(StreamInterface* parent);
	virtual ~StreamErrorHandler();

	virtual void handleBotError(const Bot* affectedBot, ExecReturnType type) const;
	virtual void handleLoadError(const String& affectedFile, const String& message) const;
	virtual void handleSystemError(int num, const String& message) const;

private:
	StreamInterface* parent;
};



} // namespace

#endif 
