/*
 * robstrings.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file robstrings.h
  * Includes most string constants in RoboTour.
  * For easier translation.
  */

#ifndef __RT_ROBSTRINGS__
#define __RT_ROBSTRINGS__

namespace rt {

extern const char* simVarNames[];
extern const char* progVarNames[];
extern const char* botVarNames[];
extern const char* taskVarNames[];

/** Bot::exec() fail codes. Leave first one empty.
  * @see ExecReturnType */
extern const char* failMsg[];

/** RobLoader::load() fail codes. Leave first one empty.
  * @see RobLoadReturnType */
extern const char* robLoadFailMsg[];

/** RbiLoader::load() fail codes. Leave first one empty.
  * @see RbiLoadReturnType */
extern const char* rbiLoadFailMsg[];

/** Generic ProgramLoader::loadXxx() failure codes. 
  * @see GenLoadFailType
  */
extern const char* genLoadFailMsg[];

} // namespace

#endif

