#include "roy.h"


#define WRITE_BUF_SIZE 4096

static char *rmdbg_filename = "rmdbg.out";
static FILE *rmdbg_fd = NULL;
static int rmdbg_initialized = FALSE;

static RBuf *
rmdbg_stack_trace (void);

static RThreadMutex rmdbg_file_mutex;

void
rmdbg_set_outfile (char *filename)
{
    rmdbg_filename = filename;
}

static void
rmdbg_init (void)
{
    if (rmdbg_initialized == TRUE)
        return;

    rmdbg_file_mutex = rthread_mutex_new ();

    RDEBUG (("rmdbg", "initializing rmdbg with filename", rmdbg_filename));

    RTHREAD_MUTEX_ENTER (rmdbg_file_mutex) {

        /* It is possible that 2 threads tried to do the init at the same
         * time, so we test for initilialization again here in case
         * the last guy already did this. */
        if (rmdbg_initialized == TRUE)
            return;
        
        if (rmdbg_filename) {
            rmdbg_fd = fopen (rmdbg_filename, "w");
            if (!rmdbg_fd) {
                fprintf (stderr, "rmdbg subsystem was unable to open file '%s' for writing: %s\n",
                         rmdbg_filename, strerror (errno));
                return;
            }
        }


        rmdbg_initialized = TRUE;
    
    } RTHREAD_MUTEX_EXIT (rmdbg_file_mutex);
}


/* These crazy gcc'ers think it's cool that it's a static
 * function and it's fun making us do hackish stuff like this
 * to get a stacktrace.  The way to get the address is
 * macroized in case we need to do hackery later on based
 * on platform. */

#define ADDY(address,x) \
    do { \
        frame = __builtin_frame_address (x); \
        if (frame <= (void *) 0x1) { \
            last_addy = TRUE; \
        } else { \
            address = __builtin_return_address (x); \
            if (address <= (void *) 0x1) { \
                last_addy = TRUE; \
            } \
        } \
    } while (0); \
    break;

static RBuf *
rmdbg_stack_trace (void)
{
    RBuf *buf = rbuf_new ();

#ifdef GCC_BUILTIN_RETURN_WORKS

    int i;
    void *address = NULL;
    void *frame;
    int last_addy = FALSE;
    
    /* Start at 1 so we ignore this function and the previous */
    for (i = 1; i < 50; i++) {
        switch (i) {

            case 1:
                ADDY (address, 1);
            case 2:
                ADDY (address, 2);
            case 3:
                ADDY (address, 3);
            case 4:
                ADDY (address, 4);
            case 5:
                ADDY (address, 5);
            case 6:
                ADDY (address, 6);
            case 7:
                ADDY (address, 7);
            case 8:
                ADDY (address, 8);
            case 9:
                ADDY (address, 9);
            case 10:
                ADDY (address, 10);
            case 11:
                ADDY (address, 11);
            case 12:
                ADDY (address, 12);
            case 13:
                ADDY (address, 13);
            case 14:
                ADDY (address, 14);
            case 15:
                ADDY (address, 15);
            case 16:
                ADDY (address, 16);
            case 17:
                ADDY (address, 17);
            case 18:
                ADDY (address, 18);
            case 19:
                ADDY (address, 19);
            case 20:
                ADDY (address, 20);
            case 21:
                ADDY (address, 21);
            case 22:
                ADDY (address, 22);
            case 23:
                ADDY (address, 23);
            case 24:
                ADDY (address, 24);
            case 25:
                ADDY (address, 25);
            case 26:
                ADDY (address, 26);
            case 27:
                ADDY (address, 27);
            case 28:
                ADDY (address, 28);
            case 29:
                ADDY (address, 29);
            case 30:
                ADDY (address, 30);
            case 31:
                ADDY (address, 31);
            case 32:
                ADDY (address, 32);
            case 33:
                ADDY (address, 33);
            case 34:
                ADDY (address, 34);
            case 35:
                ADDY (address, 35);
            case 36:
                ADDY (address, 36);
            case 37:
                ADDY (address, 37);
            case 38:
                ADDY (address, 38);
            case 39:
                ADDY (address, 39);
            case 40:
                ADDY (address, 40);
            case 41:
                ADDY (address, 41);
            case 42:
                ADDY (address, 42);
            case 43:
                ADDY (address, 43);
            case 44:
                ADDY (address, 44);
            case 45:
                ADDY (address, 45);
            case 46:
                ADDY (address, 46);
            case 47:
                ADDY (address, 47);
            case 48:
                ADDY (address, 48);
            case 49:
                ADDY (address, 49);
            case 50:
                ADDY (address, 50);
            case 51:
                ADDY (address, 51);
            case 52:
                ADDY (address, 52);
            case 53:
                ADDY (address, 53);
            case 54:
                ADDY (address, 54);
            case 55:
                ADDY (address, 55);
            case 56:
                ADDY (address, 56);
            case 57:
                ADDY (address, 57);
            case 58:
                ADDY (address, 58);
            case 59:
                ADDY (address, 59);
            case 60:
                ADDY (address, 60);
            case 61:
                ADDY (address, 61);
            case 62:
                ADDY (address, 62);
            case 63:
                ADDY (address, 63);
            case 64:
                ADDY (address, 64);
            case 65:
                ADDY (address, 65);
            case 66:
                ADDY (address, 66);
            case 67:
                ADDY (address, 67);
            case 68:
                ADDY (address, 68);
            case 69:
                ADDY (address, 69);
            case 70:
                ADDY (address, 70);
            case 71:
                ADDY (address, 71);
            case 72:
                ADDY (address, 72);
            case 73:
                ADDY (address, 73);
            case 74:
                ADDY (address, 74);
            case 75:
                ADDY (address, 75);
            case 76:
                ADDY (address, 76);
            case 77:
                ADDY (address, 77);
            case 78:
                ADDY (address, 78);
            case 79:
                ADDY (address, 79);
            case 80:
                ADDY (address, 80);
            case 81:
                ADDY (address, 81);
            case 82:
                ADDY (address, 82);
            case 83:
                ADDY (address, 83);
            case 84:
                ADDY (address, 84);
            case 85:
                ADDY (address, 85);
            case 86:
                ADDY (address, 86);
            case 87:
                ADDY (address, 87);
            case 88:
                ADDY (address, 88);
            case 89:
                ADDY (address, 89);
            case 90:
                ADDY (address, 90);
            case 91:
                ADDY (address, 91);
            case 92:
                ADDY (address, 92);
            case 93:
                ADDY (address, 93);
            case 94:
                ADDY (address, 94);
            case 95:
                ADDY (address, 95);
            case 96:
                ADDY (address, 96);
            case 97:
                ADDY (address, 97);
            case 98:
                ADDY (address, 98);
            case 99:
                ADDY (address, 99);
            default:
                last_addy = TRUE;
                break;

        }

        if (last_addy) {
            goto out;
        }
        rbuf_append_sprintf (buf, "%p,", address);
    }

out:

    /* strip remaining ',' */
    rbuf_truncate (buf, rbuf_len (buf) - 1);

#else
    
    /* If GCC backtraces don't work, mention it. */
    rbuf_append_str (buf, "NULL");

#endif

    return (buf);
}

void *
rmdbg_rmem_realloc__P (void *ptr, int size, char *file__, 
                       int line__, char *pretty_function)
{
    void *alloc_ptr;

    rmdbg_free__P (file__, line__, "rmem_free", 
                   ptr, TRUE);
    alloc_ptr = realloc (ptr, size);
    rmdbg_alloc__P (file__, line__, pretty_function, "rmem_realloc",
                    "rmem_free", size, alloc_ptr);

    return (alloc_ptr);
}

int 
rmdbg_rxp_decode_rbuf__P (RXpDecoder *decoder, RBuf **value, char *file__,
                          int line__, char *pretty_function)
{
    int ret;

    ret = rxp_decode_rbuf (decoder, (RBuf **) value);

    rmdbg_alloc__P (file__, line__, pretty_function, "rxp_decode_rbuf",
                    "rbuf_free", sizeof (RBuf), *value);

    return (ret);
}


RList *
rmdbg_rbuf_split__P (const RBuf *string, char *separators, int max_splits,
                     char *file__, int line__, char *pretty_function)
{
    RList *list;
    RListOfRBufEntry *entry;

    list = rbuf_split (string, separators, max_splits);

    RLIST_FOREACH (list, entry) {
        rmdbg_alloc__P (file__, line__, pretty_function, "rbuf_split",
                        "rbuf_free", sizeof (RBuf), entry->buf);
    } RFOREACH_CLOSE;
        
    rmdbg_alloc__P (file__, line__, pretty_function, "rbuf_split",
                    "rlist_free", sizeof (RList), list);

    return (list);
}

void
rmdbg_rlist_of_rbufs_free__P (RList *list, char *file__, 
                              int line__, char *pretty_function)
{
    RListOfRBufEntry *rbuf_entry;

    RLIST_FOREACH (list, rbuf_entry) {
        rmdbg_free__P (file__, line__, "rbuf_free", 
                       rbuf_entry->buf, 
                       rbuf_entry->buf ? !RFLAG_ISSET((rbuf_entry->buf), RBUF_OWNED) : TRUE);
        rbuf_free (rbuf_entry->buf);
        rlist_remove (list, rbuf_entry);
        rlist_of_rbuf_entry_free (rbuf_entry);
    } RFOREACH_CLOSE;
    
    rmdbg_free__P (file__, line__, "rlist_free", list, TRUE);
    rlist_free (list);
}

void *
rmdbg_alloc__P (char *file__, int line__, char *pretty_function, 
                char *function_name, char *free_function_name, 
                unsigned int size, void *ptr)
{
    char buf[4096];
    RBuf *strace;

    if (rmdbg_initialized == FALSE)
        rmdbg_init ();

    if (rmdbg_fd == NULL)
        return (ptr);

    RDEBUG (("rmdbg", "writing out alloc entry for %s", function_name));
    
    strace = rmdbg_stack_trace ();
    snprintf (buf, sizeof (buf), "ALLOC %s:%d:%s %s %s %s %u %p\n",
              file__, line__, pretty_function, rbuf_str (strace), 
              function_name, free_function_name, size, ptr);
    rbuf_free (strace);

    RTHREAD_MUTEX_ENTER (rmdbg_file_mutex) {
        fwrite (buf, strlen (buf), 1, rmdbg_fd);
    } RTHREAD_MUTEX_EXIT (rmdbg_file_mutex);

    return (ptr);
}

void
rmdbg_free__P (char *file__, int line__, char *function_name, 
               void *ptr, int really_free)
{
    char buf[WRITE_BUF_SIZE];
    int len;
    RBuf *strace;

    if (rmdbg_initialized == FALSE)
        rmdbg_init ();

    if (rmdbg_fd == 0)
        return;

    if (!really_free)
        return;

    RDEBUG (("rmdbg", "writing out free entry for %s", function_name));

    strace = rmdbg_stack_trace ();
    len = snprintf (buf, sizeof (buf), "FREE %s:%d %s %s %p\n",
                    file__, line__, rbuf_str (strace), 
                    function_name, ptr);
    rbuf_free (strace);

    RTHREAD_MUTEX_ENTER (rmdbg_file_mutex) {
        fwrite (buf, RMIN (len, WRITE_BUF_SIZE), 1, rmdbg_fd);
    } RTHREAD_MUTEX_EXIT (rmdbg_file_mutex);
}

void
rmdbg_nop (void)
{
    return;
}


