#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ButtonButton {button text cmd} {
    button $button \
	-text $text \
	-command $cmd \
	-takefocus 0 \
	-bd 1 \
	-height 1 \
	-padx 2 -pady 2

    pack $button -side left -fill x -expand true
}

proc RadioButton {button text var value cmd} {
    radiobutton $button \
	-text $text \
	-variable $var \
	-value $value \
	-command $cmd \
	-indicatoron false \
	-selectcolor "" \
	-takefocus 0 \
	-bd 1 \
	-height 1 \
	-padx 2 -pady 3

    pack $button -side left -fill x -expand true
}

proc CheckButton {button text var cmd} {
    checkbutton $button \
	-text $text \
	-variable $var \
	-command $cmd \
	-indicatoron false \
	-selectcolor "" \
	-takefocus 0 \
	-bd 1 \
	-height 1 \
	-padx 2 -pady 3

    pack $button -side left -fill x -expand true
}

proc CreateButtons {} {
    global buttons

    set buttons(name) [frame .ds9.buttons]

    # Major buttons

    frame $buttons(name).major
    pack $buttons(name).major -side top -fill x -expand true

    RadioButton $buttons(name).major.file $buttons(file) \
	buttons(majorCurrent) $buttons(name).file MajorButton
    RadioButton $buttons(name).major.edit $buttons(edit) \
	buttons(majorCurrent) $buttons(name).edit MajorButton
    RadioButton $buttons(name).major.frame $buttons(frame) \
	buttons(majorCurrent) $buttons(name).frame MajorButton
    RadioButton $buttons(name).major.bin1 $buttons(bin) \
	buttons(majorCurrent) $buttons(name).bin1 MajorButton
    RadioButton $buttons(name).major.zoom $buttons(zoom) \
	buttons(majorCurrent) $buttons(name).zoom MajorButton
    RadioButton $buttons(name).major.scale $buttons(scale) \
	buttons(majorCurrent) $buttons(name).scale MajorButton
    RadioButton $buttons(name).major.color1 $buttons(color) \
	buttons(majorCurrent) $buttons(name).color1 MajorButton
    RadioButton $buttons(name).major.region $buttons(region) \
	buttons(majorCurrent) $buttons(name).region1 MajorButton
    RadioButton $buttons(name).major.wcs1 $buttons(wcs) \
	buttons(majorCurrent) $buttons(name).wcs1 MajorButton

    FileButtons
    EditButtons
    FrameButtons
    BinButtons
    ZoomButtons
    ScaleButtons
    ColorButtons
    RegionButtons
    WCSButtons

    set buttons(majorPrev) ""
    set buttons(majorCurrent) $buttons(name).file
    MajorButton
}

proc MajorButton {} {
    global buttons

    pack forget $buttons(majorPrev)
    pack $buttons(majorCurrent) -side top -fill x -expand true
    set buttons(majorPrev) $buttons(majorCurrent)
}

proc FileButtons {} {
    global buttons

    frame $buttons(name).file

    ButtonButton $buttons(name).file.about $buttons(file,about) AboutBox
    ButtonButton $buttons(name).file.open $buttons(file,open) OpenFits
    ButtonButton $buttons(name).file.saveimage $buttons(file,saveimage) \
	SaveImageDialog
    ButtonButton $buttons(name).file.savefits $buttons(file,savefits) \
	SaveFitsDialog
    ButtonButton $buttons(name).file.savempeg $buttons(file,savempeg) \
	SaveMPEGDialog
    ButtonButton $buttons(name).file.header $buttons(file,header) \
	DisplayHeaderMenu
    ButtonButton $buttons(name).file.src $buttons(file,source) OpenSource
    ButtonButton $buttons(name).file.print $buttons(file,print) Print
    ButtonButton $buttons(name).file.page $buttons(file,page) PageSetupDialog
    ButtonButton $buttons(name).file.exit $buttons(file,exit) QuitDS9
}

proc EditButtons {} {
    global buttons

    frame $buttons(name).edit
    ButtonButton $buttons(name).edit.undo $buttons(edit,undo) UndoFrame
    ButtonButton $buttons(name).edit.cut $buttons(edit,cut) CutFrame
    ButtonButton $buttons(name).edit.copy $buttons(edit,copy) CopyFrame
    ButtonButton $buttons(name).edit.paste $buttons(edit,paste) PasteFrame
    RadioButton $buttons(name).edit.default $buttons(edit,default) \
	ds9(mode) none ChangeMode
    RadioButton $buttons(name).edit.pointer $buttons(edit,pointer) \
	ds9(mode) pointer ChangeMode
    RadioButton $buttons(name).edit.crosshair $buttons(edit,crosshair) \
	ds9(mode) crosshair ChangeMode
    RadioButton $buttons(name).edit.colorbar $buttons(edit,colorbar) \
	ds9(mode) colorbar ChangeMode
    RadioButton $buttons(name).edit.pan $buttons(edit,pan) \
	ds9(mode) pan ChangeMode
    RadioButton $buttons(name).edit.zoom $buttons(edit,zoom) \
	ds9(mode) zoom ChangeMode
    RadioButton $buttons(name).edit.rotate $buttons(edit,rotate) \
	ds9(mode) rotate ChangeMode
    RadioButton $buttons(name).edit.examine $buttons(edit,examine) \
	ds9(mode) examine ChangeMode
}

proc FrameButtons {} {
    global buttons
    global ds9

    frame $buttons(name).frame
    ButtonButton $buttons(name).frame.new $buttons(frame,new) CreateFrame
    ButtonButton $buttons(name).frame.newrgb $buttons(frame,newrgb) \
	CreateRGBFrame
    ButtonButton $buttons(name).frame.delete $buttons(frame,delete) \
	DeleteFrameMenu
    ButtonButton $buttons(name).frame.deleteall $buttons(frame,deleteall) \
	DeleteAllFramesMenu
    ButtonButton $buttons(name).frame.clear $buttons(frame,clear) \
	ClearCurrentFrame
    ButtonButton $buttons(name).frame.reset $buttons(frame,reset) \
	ResetCurrentFrame
    RadioButton $buttons(name).frame.single $buttons(frame,single) \
	ds9(display,user) single DisplayMode
    RadioButton $buttons(name).frame.tile $buttons(frame,tile) \
	ds9(display,user) tile DisplayMode
    RadioButton $buttons(name).frame.blink $buttons(frame,blink) \
	ds9(display,user) blink DisplayMode
    ButtonButton $buttons(name).frame.first $buttons(frame,first) FirstFrame
    ButtonButton $buttons(name).frame.prev $buttons(frame,prev) PrevFrame
    ButtonButton $buttons(name).frame.next $buttons(frame,next) NextFrame
    ButtonButton $buttons(name).frame.last $buttons(frame,last) LastFrame
}

proc BinButtons {} {
    global buttons

    frame $buttons(name).bin1
    ButtonButton $buttons(name).bin1.in $buttons(bin1,in) "Bin .5 .5"
    ButtonButton $buttons(name).bin1.out $buttons(bin1,out) "Bin 2 2"
    RadioButton $buttons(name).bin1.b1 $buttons(bin1,block1) \
	bin(factor) { 1 1 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b2 $buttons(bin1,block2) \
	bin(factor) { 2 2 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b4 $buttons(bin1,block4) \
	bin(factor) { 4 4 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b8 $buttons(bin1,block8) \
	bin(factor) { 8 8 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b16 $buttons(bin1,block16) \
	bin(factor) { 16 16 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b32 $buttons(bin1,block32) \
	bin(factor) { 32 32 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b64 $buttons(bin1,block64) \
	bin(factor) { 64 64 } ChangeBinFactor
    RadioButton $buttons(name).bin1.b128 $buttons(bin1,block128) \
	bin(factor) { 128 128 } ChangeBinFactor
    RadioButton $buttons(name).bin1.more $buttons(bin1,more) \
	buttons(majorCurrent) $buttons(name).bin2 MajorButton
    
    frame $buttons(name).bin2
    CheckButton $buttons(name).bin2.none $buttons(bin2,none) \
	bin(smooth) ChangeBinSmooth
    RadioButton $buttons(name).bin2.boxcar $buttons(bin2,boxcar) \
	bin(smooth,function) boxcar ChangeBinSmoothFunction
    RadioButton $buttons(name).bin2.tophat $buttons(bin2,tophat) \
	bin(smooth,function) tophat ChangeBinSmoothFunction
    RadioButton $buttons(name).bin2.gaussian $buttons(bin2,gaussian) \
	bin(smooth,function) gaussian ChangeBinSmoothFunction
    RadioButton $buttons(name).bin2.more $buttons(bin2,more) \
	buttons(majorCurrent) $buttons(name).bin1 MajorButton
}

proc ZoomButtons {} {
    global buttons
    global wcs

    frame $buttons(name).zoom
    CheckButton $buttons(name).zoom.align "align wcs" wcs(align) AlignWCSFrame
    ButtonButton $buttons(name).zoom.in "in" "Zoom 2"
    ButtonButton $buttons(name).zoom.out "out" "Zoom .5"
    ButtonButton $buttons(name).zoom.center "center" CenterCurrentFrame
    RadioButton $buttons(name).zoom.none none current(orient) none ChangeOrient
    RadioButton $buttons(name).zoom.x x current(orient) x ChangeOrient
    RadioButton $buttons(name).zoom.y y current(orient) y ChangeOrient
    RadioButton $buttons(name).zoom.xy xy current(orient) xy ChangeOrient
}

proc ScaleButtons {} {
    global buttons
    global scale

    frame $buttons(name).scale
    RadioButton $buttons(name).scale.linear "linear" \
	scale(type) linear ChangeScale
    RadioButton $buttons(name).scale.log "log" \
	scale(type) log ChangeScale
    RadioButton $buttons(name).scale.squared "squared" \
	scale(type) squared ChangeScale
    RadioButton $buttons(name).scale.sqrt "sqrt" \
	scale(type) sqrt ChangeScale
    RadioButton $buttons(name).scale.histogram "hist equ" \
	scale(type) histequ ChangeScale
    RadioButton $buttons(name).scale.minmax "minmax" \
	scale(mode) minmax ChangeScaleMode
    RadioButton $buttons(name).scale.minmax1 "99.5%" \
	scale(mode) 99.5 ChangeScaleMode
    RadioButton $buttons(name).scale.minmax2 "99%" \
	scale(mode) 99 ChangeScaleMode
    RadioButton $buttons(name).scale.minmax3 "98%" \
	scale(mode) 98 ChangeScaleMode
    RadioButton $buttons(name).scale.zscale "zscale" \
	scale(mode) zscale ChangeScaleMode
    RadioButton $buttons(name).scale.zmax "zmax" \
	scale(mode) zmax ChangeScaleMode
}

proc ColorButtons {} {
    global buttons
    global colorbar

    set ids [colorbar list id]

    frame $buttons(name).color1
    for {set i 0} {$i<9} {incr i} {
	set id [lindex $ids $i]
	set title [colorbar get name $id]
	set name [string tolower $title]
	RadioButton $buttons(name).color1.$i $name \
	    colorbar(map) $title "ChangeColormapID $id"
    }
    RadioButton $buttons(name).color1.more "more..." buttons(majorCurrent) \
	$buttons(name).color2 MajorButton

    frame $buttons(name).color2
    for {set i 9} {$i<18} {incr i} {
	set id [lindex $ids $i]
	set title [colorbar get name $id]
	set name [string tolower $title]
	RadioButton $buttons(name).color2.$i $name \
	    colorbar(map) $title "ChangeColormapID $id"
    }
    RadioButton $buttons(name).color2.more "more..." buttons(majorCurrent) \
	$buttons(name).color3 MajorButton

    frame $buttons(name).color3
    CheckButton $buttons(name).color3.invert invert \
	colorbar(invert) InvertColorbar
    ButtonButton $buttons(name).color3.reset reset ResetColormap
    RadioButton $buttons(name).color3.more "more..." buttons(majorCurrent) \
	$buttons(name).color1 MajorButton
}

proc RegionButtons {} {
    global buttons

    frame $buttons(name).region1
    ButtonButton $buttons(name).region1.info info InfoMarker
    ButtonButton $buttons(name).region1.front front FrontMarker
    ButtonButton $buttons(name).region1.back back BackMarker
    ButtonButton $buttons(name).region1.all selall SelectAllMarker
    ButtonButton $buttons(name).region1.none selnone UnselectAllMarker
    ButtonButton $buttons(name).region1.delete del DeleteSelectMarker
    ButtonButton $buttons(name).region1.deleteall delall DeleteAllMarker
    ButtonButton $buttons(name).region1.load load OpenMarkerFile
    ButtonButton $buttons(name).region1.save save SaveMarker
    ButtonButton $buttons(name).region1.newgrp newgrp GroupCreate
    ButtonButton $buttons(name).region1.grps grps GroupDialog
    ButtonButton $buttons(name).region1.list list DisplayMarker
    RadioButton $buttons(name).region1.more "more..." buttons(majorCurrent) \
	$buttons(name).region2 MajorButton
    
    frame $buttons(name).region2
    RadioButton $buttons(name).region2.circle circle marker(shape) circle ""
    RadioButton $buttons(name).region2.ellipse ellipse marker(shape) ellipse ""
    RadioButton $buttons(name).region2.box box marker(shape) box ""
    RadioButton $buttons(name).region2.polygon poly marker(shape) polygon ""
    RadioButton $buttons(name).region2.line line marker(shape) line ""
    RadioButton $buttons(name).region2.text text marker(shape) text ""
    RadioButton $buttons(name).region2.ruler ruler marker(shape) ruler ""
    RadioButton $buttons(name).region2.compass compass marker(shape) compass ""
    RadioButton $buttons(name).region2.projection proj \
	marker(shape) projection ""
    RadioButton $buttons(name).region2.point point \
	marker(shape) "circle point" ""
    RadioButton $buttons(name).region2.more "more..." buttons(majorCurrent) \
	$buttons(name).region3 MajorButton

    frame $buttons(name).region3
    RadioButton $buttons(name).region3.annulus annulus marker(shape) annulus ""
    RadioButton $buttons(name).region3.ellispsannulus "ellipse annulus" \
	marker(shape) "ellipse annulus" ""
    RadioButton $buttons(name).region3.boxannulus "box annulus" \
	marker(shape) "box annulus" ""
    RadioButton $buttons(name).region3.panda panda marker(shape) panda ""
    RadioButton $buttons(name).region3.more "more..." buttons(majorCurrent) \
	$buttons(name).region1 MajorButton
}

proc WCSButtons {} {
    global buttons
    global wcs

    frame $buttons(name).wcs1
    RadioButton $buttons(name).wcs1.fk5 fk5 wcs(sky) fk5 UpdateWCS
    RadioButton $buttons(name).wcs1.icrs icrs wcs(sky) icrs UpdateWCS
    RadioButton $buttons(name).wcs1.galactic galactic wcs(sky) galactic \
	UpdateWCS
    RadioButton $buttons(name).wcs1.ecliptic ecliptic wcs(sky) ecliptic \
	UpdateWCS
    RadioButton $buttons(name).wcs1.degrees deg wcs(skyformat) degrees \
	UpdateWCS
    RadioButton $buttons(name).wcs1.sexagesimal sexagesimal wcs(skyformat) \
	sexagesimal UpdateWCS
    RadioButton $buttons(name).wcs1.more "more..." buttons(majorCurrent) \
	$buttons(name).wcs2 MajorButton

    frame $buttons(name).wcs2
    RadioButton $buttons(name).wcs2.wcs WCS wcs(system) wcs UpdateWCS
    RadioButton $buttons(name).wcs2.wcsA WCSA wcs(system) wcsA UpdateWCS
    RadioButton $buttons(name).wcs2.wcsB WCSB wcs(system) wcsB UpdateWCS
    RadioButton $buttons(name).wcs2.wcsC WCSC wcs(system) wcsC UpdateWCS
    RadioButton $buttons(name).wcs2.wcsD WCSD wcs(system) wcsD UpdateWCS
    RadioButton $buttons(name).wcs2.wcsE WCSE wcs(system) wcsE UpdateWCS
    RadioButton $buttons(name).wcs2.wcsF WCSF wcs(system) wcsF UpdateWCS
    RadioButton $buttons(name).wcs2.wcsG WCSG wcs(system) wcsG UpdateWCS
    RadioButton $buttons(name).wcs2.wcsH WCSH wcs(system) wcsH UpdateWCS
    RadioButton $buttons(name).wcs2.wcsI WCSI wcs(system) wcsI UpdateWCS
    RadioButton $buttons(name).wcs2.more "more..." buttons(majorCurrent) \
	$buttons(name).wcs3 MajorButton

    frame $buttons(name).wcs3
    RadioButton $buttons(name).wcs3.wcsJ WCSJ wcs(system) wcsJ UpdateWCS
    RadioButton $buttons(name).wcs3.wcsK WCSK wcs(system) wcsK UpdateWCS
    RadioButton $buttons(name).wcs3.wcsL WCSL wcs(system) wcsL UpdateWCS
    RadioButton $buttons(name).wcs3.wcsM WCSM wcs(system) wcsM UpdateWCS
    RadioButton $buttons(name).wcs3.wcsN WCSN wcs(system) wcsN UpdateWCS
    RadioButton $buttons(name).wcs3.wcsO WCSO wcs(system) wcsO UpdateWCS
    RadioButton $buttons(name).wcs3.wcsP WCSP wcs(system) wcsP UpdateWCS
    RadioButton $buttons(name).wcs3.wcsQ WCSQ wcs(system) wcsQ UpdateWCS
    RadioButton $buttons(name).wcs3.wcsR WCSR wcs(system) wcsR UpdateWCS
    RadioButton $buttons(name).wcs3.wcsS WCSS wcs(system) wcsS UpdateWCS
    RadioButton $buttons(name).wcs3.more "more..." buttons(majorCurrent) \
	$buttons(name).wcs4 MajorButton

    frame $buttons(name).wcs4
    RadioButton $buttons(name).wcs4.wcsT WCST wcs(system) wcsT UpdateWCS
    RadioButton $buttons(name).wcs4.wcsU WCSU wcs(system) wcsU UpdateWCS
    RadioButton $buttons(name).wcs4.wcsV WCSV wcs(system) wcsV UpdateWCS
    RadioButton $buttons(name).wcs4.wcsW WCSW wcs(system) wcsW UpdateWCS
    RadioButton $buttons(name).wcs4.wcsX WCSX wcs(system) wcsX UpdateWCS
    RadioButton $buttons(name).wcs4.wcsY WCSY wcs(system) wcsY UpdateWCS
    RadioButton $buttons(name).wcs4.wcsZ WCSZ wcs(system) wcsZ UpdateWCS
    RadioButton $buttons(name).wcs4.more "more..." buttons(majorCurrent) \
	$buttons(name).wcs1 MajorButton
}
