#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc VODialog {} {
    global vo
    global ds9
    global menu
    global current

    if [winfo exists $vo(top)] {
	raise $vo(top)
	return
    }

    set w $vo(top)
    set title "Virtual Observatory"

    # create the window

    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW VODestroyDialog

    # menu

    $w configure -menu $vo(mb)
    menu $vo(mb) -tearoff 0
    $vo(mb) add cascade -label File -menu $vo(mb).file
    menu $vo(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $vo(mb).file add command -label Update -command VOUpdateDialog
    $vo(mb).file add command -label Cancel -command VOCancelDialog
    $vo(mb).file add separator
    $vo(mb).file add command -label Close -command VODestroyDialog

    frame $w.param -relief groove -borderwidth 2
    label $w.param.status  -text "Connecting to Server..."
    frame $w.opt -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.param $w.opt $w.buttons -fill x -expand true -ipadx 4 -ipady 4

    frame $w.opt.o
    pack $w.opt.o -side left
    checkbutton $w.opt.o.hv -text "Use internal web display" \
	-variable vo(hv) -selectcolor $menu(selectcolor)
    grid $w.opt.o.hv -padx 4 -sticky w

    button $w.buttons.close -text "Close" -command VODestroyDialog
    pack $w.buttons.close -side left -padx 10 -expand true

    if {[string length $vo(server,host)] == 0} {
	VOUpdateDialog
    } else {
	set l [llength $vo(server,host)]
	for {set ii 0} {$ii<$l} {incr ii} {
	    set b [lindex $vo(server,button) $ii]
	    checkbutton $b \
-text "[lindex $vo(server,title) $ii] ([lindex $vo(server,url) $ii])" \
		-variable vo(b$ii) -command "VOCheck $ii"
	    pack $b -anchor w -padx 4

	    # update color
	    if {$vo(b$ii)} {
		$b configure -selectcolor yellow

		global debug
		if {$debug(tcl,idletasks)} {
		    puts "VODialog"
		}
		update idletasks

		$b configure -selectcolor green
	    } else {
		$b configure -selectcolor yellow
		$b select

		global debug
		if {$debug(tcl,idletasks)} {
		    puts "VODialog"
		}
		update idletasks

		$b configure -selectcolor {}
		$b deselect
	    }
	}
    }
}

proc VODestroyDialog {} {
    global vo

    if {[info exists vo(token)]} {
	set vo(state) 0
	http::reset $vo(token)
    }

    destroy $vo(top)
    destroy $vo(mb)
}

proc VOUpdateDialog {} {
    global vo
    global xpa
    global http
    global message

    set w $vo(top)
    # delete old servers
    for {set ii 0} {$ii < [llength $vo(server,button)]} {incr ii} {
	catch {xparemote $xpa [lindex $vo(server,host) $ii] - -proxy}
	catch {destroy [lindex $vo(server,button) $ii]}
	catch {unset vo(b$ii)}
    }
    set vo(server,host) {}
    set vo(server,title) {}
    set vo(server,url) {}
    set vo(server,button) {}

    pack $w.param.status -ipadx 4 -ipady 4

    if [catch {set vo(token) [http::geturl $vo(server) -command VOFinish -timeout $vo(timeout) -headers "[ProxyHTTP]"]}] {
	Error "$message(error,vo,server) $vo(server)"
	VODestroyDialog
    } else {
	set vo(state) 1
    }
}

proc VOCancelDialog {} {
    global vo

    if {[info exists vo(token)]} {
	set vo(state) 0
	http::reset $vo(token)
    }
}

proc VOFinish {token} {
    global vo

    set w $vo(top)
    pack forget $w.param.status

    HTTPLog $token

    set data [string trimright [http::data $token] \n]
    if {$vo(state)} {
	set lines [split $data \n]
	set l [llength $lines]
	for {set ii 0} {$ii<$l} {incr ii} {
	    set line [lindex $lines $ii]
	    set b "$w.param.b$ii"

	    set ll [split $line \t]
	    lappend vo(server,host) [lindex $ll 0]
	    lappend vo(server,title) [lindex $ll 1]
	    lappend vo(server,url) [lindex $ll 2]
	    lappend vo(server,button) $b
	    checkbutton $b \
-text "[lindex $vo(server,title) $ii] ([lindex $vo(server,url) $ii])" \
		-variable vo(b$ii) -command "VOCheck $ii"
	    pack $b -anchor w -padx 4
	}
    }
    set vo(state) 0

    http::cleanup $vo(token)
    catch {unset vo(token)}
}

proc VOCheck {ii} {
    global vo
    global xpa
    global message

    set w $vo(top)
    set b "$w.param.b$ii"

    if {$vo(b$ii)} {
	$b configure -selectcolor yellow

	global debug
	if {$debug(tcl,idletasks)} {
	    puts "VOCheck"
	}
	update idletasks

	if {[catch {xparemote $xpa [lindex $vo(server,host) $ii] + -proxy}]} {
	    $b configure -selectcolor {}
	    $b deselect
	    set vo(b$ii) 0
	    Error "$message(error,vo,server)"
	    return
	}

	$b configure -selectcolor green

	if {$vo(hv)} {
	    set url [lindex $vo(server,url) $ii]
	    ParseURL $url r
	    HV "vo$ii" "$r(authority)" $url 4 1 {}
	}
    } else {
	$b configure -selectcolor yellow
	$b select

	global debug
	if {$debug(tcl,idletasks)} {
	    puts "VOCheck"
	}
	update idletasks

	catch {xparemote $xpa [lindex $vo(server,host) $ii] - -proxy}

	$b configure -selectcolor {}
	$b deselect
    }
}

proc VOPref {} {
    global vo
    set result $vo(server)
    if [EntryDialog "VO Server" "Enter VO Server List URL:" 80 result] {
	set vo(server) $result
    }
}

proc ProcessVOCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global vo
    global xpa
    global http
    global message

    # get new list
    if {[string length $vo(server,host)] == 0} {
	if [catch {set token [http::geturl $vo(server) -timeout $vo(timeout) -headers "[ProxyHTTP]"]}] {
	    Error "$message(error,vo,server) $vo(server)"
	    return
	}

	HTTPLog $token
	set data [string trimright [http::data $token] \n]
	set lines [split $data \n]
	set l [llength $lines]
	for {set ii 0} {$ii<$l} {incr ii} {
	    set line [lindex $lines $ii]

	    set ll [split $line \t]
	    lappend vo(server,host) [lindex $ll 0]
	    lappend vo(server,title) [lindex $ll 1]
	    lappend vo(server,url) [lindex $ll 2]
	    lappend vo(server,button) "$vo(top).param.b$ii"
	}

	http::cleanup $token
    }

    # find best match
    set ii [lsearch $vo(server,host) "*[lindex $var $i]*"]
    if {$ii>=0} {
	set vo(b$ii) 1
	xparemote $xpa [lindex $vo(server,host) $ii] + -proxy

	if {$vo(hv)} {
	    set url [lindex $vo(server,url) $ii]
	    ParseURL $url 
	    HV "vo$ii" "$r(authority)" $url 4 1 {}
	}
    }
}
