// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifdef HAVE_SYS_SHM_H
#include <sys/shm.h>
#include <sys/ipc.h>

#include "share.h"

FitsShareID::FitsShareID(int shmid, const char* filter)
{
  parse(filter);

  // find size
  struct shmid_ds info;
  if (shmctl(shmid, IPC_STAT, &info)) {
    cerr << "Fitsy++ Internal Error: shctl failed" << endl;
    return;
  }
  mapsize_ = info.shm_segsz;

  // Attach the memory segment
  if ((long)(mapdata_ = (char*)shmat(shmid, 0, SHM_RDONLY)) == -1) {
    cerr << "Fitsy++ Internal Error: shmat failed" << endl;
    return;
  }

  // so far so good
  valid_ = 1;
}

FitsShareID::~FitsShareID()
{
  shmdt(mapdata_);
}

FitsShareKey::FitsShareKey(int key, const char* filter)
{
  parse(filter);

  // get shmid
  int shmid;
  if ((shmid = shmget(key, 0, 0)) < 0) {
    cerr << "Fitsy++ Internal Error: shmget failed" << endl;
    return;
  }

  // find size
  struct shmid_ds info;
  if (shmctl(shmid, IPC_STAT, &info)) {
    cerr << "Fitsy++ Internal Error: shctl failed" << endl;
    return;
  }
  mapsize_ = info.shm_segsz;

  // Attach the memory segment
  if ((long)(mapdata_ = (char*)shmat(shmid, 0, SHM_RDONLY)) == -1) {
    cerr << "Fitsy++ Internal Error: shmat failed" << endl;
    return;
  }

  // so far so good
  valid_ = 1;
}

FitsShareKey::~FitsShareKey()
{
  if (mapdata_>0)
    shmdt(mapdata_);
}
#else
#include "share.h"

FitsShareID::FitsShareID(int shmid, const char* filter)
{
  // shared memory not supported
  valid_ = 0;
}

FitsShareID::~FitsShareID() {}

FitsShareKey::FitsShareKey(int key, const char* filter)
{
  // shared memory not supported
  valid_ = 0;
}

FitsShareKey::~FitsShareKey() {}
#endif
