// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __line_h__
#define __line_h__

#include "marker.h"

class Line : public Marker {
private:
  Vector p1;
  Vector p2;
  int p1Arrow;
  int p2Arrow;

  void render(Drawable, const Matrix&, double, RenderMode);

public:
  Line(const Line&);
  Line(FrameBase* parent, const Vector& ctr, const Vector& p, int a1, int a2,
       const char* clr, int w, const char* f, 
       const char* t, unsigned short prop, const char* c, 
       const List<Tag>& tag);

  Marker* dup() {return new Line(*this);}
  void updateBBox();
  void updateCoords(const Matrix&);

  void move(const Vector&);
  void moveTo(const Vector&);
  void edit(const Vector&, int);

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  void ps(int);
  int isIn(const Vector&);

  const Vector& getP1() {return p1;}
  const Vector& getP2() {return p2;}
  void setPoints(const Vector&, const Vector&);
  void setArrows(int,int);
  int getP1Arrow() {return p1Arrow;}
  int getP2Arrow() {return p2Arrow;}
  void listProperties(ostream&, char);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
