
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ArrayTypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "savant.hh"

IIRBase_ArrayTypeDefinition::IIRBase_ArrayTypeDefinition(){
  my_index_subtype = NULL;
  my_element_subtype =  NULL;
  my_is_element = FALSE;
}

IIRBase_ArrayTypeDefinition::~IIRBase_ArrayTypeDefinition(){
}

void 
IIRBase_ArrayTypeDefinition::set_index_subtype( IIR_ScalarTypeDefinition *index_subtype ){
  my_index_subtype = index_subtype;
}

IIR_ScalarTypeDefinition *
IIRBase_ArrayTypeDefinition::get_index_subtype(){
  return my_index_subtype;
}

void 
IIRBase_ArrayTypeDefinition::set_element_subtype( IIR_TypeDefinition *element_subtype ){
  my_element_subtype = element_subtype;
}

IIR_TypeDefinition *
IIRBase_ArrayTypeDefinition::get_element_subtype(){
  return my_element_subtype;
}

IIR_Boolean 
IIRBase_ArrayTypeDefinition::is_element(){
  return my_is_element;
}

void
IIRBase_ArrayTypeDefinition::set_is_element( IIR_Boolean new_is_element ){
  my_is_element = new_is_element;
}
